/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.entrada.IVerificacaoCriptografia3DES;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.ChavesCriptografiaUtil;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.PesquisaChavesException;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicVerificacaoCriptografia3DES {
    public static final String SUCCESS_3DES = "SUCCESS_3DES";
    public static final String SUCCESS = "SUCCESS";
    public static final String SUCCESS_CRIPTOGRAFIA_CONTINGENCIA = "SUCCESS_CRIPTOGRAFIA_CONTINGENCIA";
    public static final String NOT_REQUIRED = "NOT_REQUIRED";
    public static final String NO_PINPAD = "NO_PINPAD";
    public static final String ERROR = "ERROR";
    private Logger logger = CTFClientLogger.getPeriferico();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String execute(IVerificacaoCriptografia3DES dados) throws ExcecaoApiAc {
        ControladorPerifericos periferico = dados.getPerifericos();
        boolean multiTerminal = false;
        boolean delivery = false;
        if (dados.getEntradaIntegracao() != null) {
            multiTerminal = dados.getEntradaIntegracao().isMultiTerminal();
            delivery = dados.getEntradaIntegracao().getCodigoOrigemTransacao() == 1;
        } else {
            boolean bl = delivery = dados.getCodigoOrigemTransacao() == 1;
        }
        if (multiTerminal || delivery) {
            return NOT_REQUIRED;
        }
        SaidaApiTefC saida = dados.getSaidaApiTef();
        TabelaCriptografia tabelaCriptografia = null;
        if (saida != null) {
            tabelaCriptografia = dados.getTabelaCriptografia();
        }
        PinEMV pinpad = null;
        try {
            pinpad = periferico.getPin();
        }
        catch (ExcecaoPerifericos e1) {
            e1.printStackTrace();
        }
        if (pinpad == null) {
            return NO_PINPAD;
        }
        if (tabelaCriptografia != null) {
            boolean utiliza3DESDados = false;
            boolean utiliza3DESSenha = false;
            if (tabelaCriptografia.getCriptografiaSenhaPrincipal() != null && tabelaCriptografia.getCriptografiaSenhaPrincipal().getAlgoritmo() == 1) {
                utiliza3DESSenha = true;
            }
            if (tabelaCriptografia.getCriptografiaDadosPrincipal() != null && tabelaCriptografia.getCriptografiaDadosPrincipal().getAlgoritmo() == 1) {
                utiliza3DESDados = true;
            }
            if ((utiliza3DESSenha || utiliza3DESDados) && !(pinpad instanceof BibliotecaPinpad)) {
                this.logger.log((Priority)Level.INFO, (Object)"Biblioteca compartilhada n\u00e3o utilizada, ignorando o tratamento de suporte da criptografia 3DES");
                return NO_PINPAD;
            }
            boolean tripleDESOk = false;
            if (utiliza3DESDados) {
                try {
                    ChavesCriptografiaUtil.pesquisaChavesK3(dados.getPerifericos(), tabelaCriptografia, 2);
                    tripleDESOk = true;
                }
                catch (PesquisaChavesException e) {
                    this.logger.log((Priority)Level.DEBUG, (Object)"Ocorreu erro durante a pesquisa de chaves de dados, tentando utilizar m\u00e9todo alternativo");
                    try {
                        BibliotecaPinpad pinCompartilhado = (BibliotecaPinpad)pinpad;
                        pinCompartilhado.encryptBuffer(1, tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey(), tabelaCriptografia.getCriptografiaDadosPrincipal().getWorkingKey(), "1234567890123456");
                        tripleDESOk = true;
                    }
                    catch (ExcecaoPerifericos e1) {
                        this.logger.log((Priority)Level.WARN, (Object)("Erro ao tentar 3DES, \u00edndice: " + tabelaCriptografia.getCriptografiaDadosPrincipal().getIndiceMasterKey() + ". Desc: " + e1.getMessage()));
                    }
                }
                if (!tripleDESOk) {
                    CriptografiaUtil.utilizaCriptografiaContingenciaDados(tabelaCriptografia, this.logger);
                    return SUCCESS_CRIPTOGRAFIA_CONTINGENCIA;
                }
                this.logger.log((Priority)Level.DEBUG, (Object)"Criptografia 3DES suportada pelo Pinpad");
            } else {
                this.logger.log((Priority)Level.DEBUG, (Object)"3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (utiliza3DESSenha) {
                try {
                    ChavesCriptografiaUtil.pesquisaChavesK3(dados.getPerifericos(), tabelaCriptografia, 1);
                }
                catch (PesquisaChavesException e) {
                    this.logger.log((Priority)Level.DEBUG, (Object)"Ocorreu erro durante a pesquisa de chaves de senha, a pesquisa n\u00e3o ser\u00e1 realizada");
                }
            } else {
                this.logger.log((Priority)Level.DEBUG, (Object)"3DES n\u00e3o utilizado para criptografia de dados");
            }
            if (tripleDESOk) {
                return SUCCESS_3DES;
            }
            return SUCCESS;
        }
        if (dados.getSaidaApiTef() != null) {
            dados.getSaidaApiTef().setRetorno(20);
        }
        this.logger.log((Priority)Level.ERROR, (Object)"Tabela de criptografia n\u00e3o carregada para tentativa de uso de cripto 3DES");
        return ERROR;
    }
}

