/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.microoperacoes;

import com.csi.ctfclient.operacoes.entrada.ITentativasUtilizarDukpt;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class MicVerificacaoTentativaInjecao {
    public static final String REFAZER_TENTATIVA_INJECAO = "REFAZER_TENTATIVA_INJECAO";
    public static final String TENTATIVAS_ESGOTADAS = "TENTATIVAS_ESGOTADAS";
    private Logger logger = CTFClientLogger.getPeriferico();

    public String execute(ITentativasUtilizarDukpt dados) {
        String mensagemLog = "Tentativa de inje\u00e7\u00e3o " + dados.getTentativaInjecao() + " no total de " + dados.getNumeroMaximoTentativasInjecaoDUKPT() + ". ";
        if (dados.getNumeroMaximoTentativasInjecaoDUKPT() > 0 && dados.getTentativaInjecao() < dados.getNumeroMaximoTentativasInjecaoDUKPT()) {
            this.logger.log((Priority)Level.INFO, (Object)(mensagemLog + "Uma nova tentativa de inje\u00e7\u00e3o ser\u00e1 realizada."));
            dados.setTentativaInjecao(dados.getTentativaInjecao() + 1);
            return REFAZER_TENTATIVA_INJECAO;
        }
        this.logger.log((Priority)Level.INFO, (Object)(mensagemLog + "Tentativas esgotadas."));
        TabelaCriptografia tabelaCriptografia = dados.getTabelaCriptografia();
        CriptografiaUtil.utilizaCriptografiaContingenciaDUKPT(tabelaCriptografia, this.logger);
        return TENTATIVAS_ESGOTADAS;
    }
}

