/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractCartaoAtributosComuns
implements Cartao {
    private static Logger logger = CTFClientLogger.getCTFClient();

    public abstract String getNumero();

    public abstract String getPAN();

    public String getNumeroFormatado() {
        String numeroCartao = this.getNumero();
        StringBuffer sb = new StringBuffer();
        String separador = "";
        if (numeroCartao != null) {
            for (int i = 0; i < numeroCartao.length(); i += 4) {
                sb.append(separador + numeroCartao.substring(i, i + 4));
                separador = "-";
            }
            return sb.toString();
        }
        return null;
    }

    public String getNumeroMascara(int formatoCartao) {
        String numeroCartao = this.getPAN().trim();
        return AbstractCartaoAtributosComuns.getNumeroMascara(numeroCartao, formatoCartao);
    }

    public static String getNumeroMascara(String numeroCartao, int formatoCartao) {
        String numeroCartaoFormatado = null;
        if (formatoCartao == 1) {
            numeroCartaoFormatado = numeroCartao.substring(0, 4) + numeroCartao.substring(4, 6) + "-" + numeroCartao.substring(numeroCartao.length() - 4, numeroCartao.length());
        } else if (formatoCartao == 2) {
            numeroCartaoFormatado = numeroCartao.substring(0, 4) + numeroCartao.substring(4, 6) + "******" + numeroCartao.substring(numeroCartao.length() - 4, numeroCartao.length());
        } else {
            throw new IllegalArgumentException("Tipo do formato do n\u00famero do cart\u00e3o inesperado");
        }
        return numeroCartaoFormatado;
    }

    public String getNumeroMascaradoLegado() {
        if (this.getPAN() != null) {
            String pan = this.getPAN().trim();
            String panFormatado = StringUtil.completaString(pan.substring(0, 6), pan.length(), '*', 4);
            return panFormatado;
        }
        return null;
    }

    public String getNumeroMascaradoLegado4UltimosDigitos() {
        if (this.getPAN() != null && this.getPAN().trim().length() >= 10) {
            String pan = this.getPAN().trim();
            String panFormatado = StringUtil.completaString(pan.substring(0, 6), pan.length() - 4, '*', 4) + pan.substring(pan.length() - 4);
            return panFormatado;
        }
        if (this.getPAN() == null) {
            logger.log((Priority)Level.WARN, (Object)"O PAN do cart\u00e3o n\u00e3o pode ser formatado para a AC, valor nulo");
            return null;
        }
        logger.log((Priority)Level.WARN, (Object)"PAN do cart\u00e3o possui menos que 10 d\u00edgitos, repassando-o integralmente para a AC.");
        return this.getPAN().trim();
    }
}

