/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.DadosCMOSPinpad;
import com.csi.ctfclient.tools.util.PersistenciaObjetos;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CMOSPinPad {
    private PersistenciaObjetos persistenciaObjetos;
    private static final String PATH_NAME = "./CMOS_PinPad.dat";
    private static CMOSPinPad instance;
    private Map dadosCMOS;
    private static final String KEY_DADOS_CMOS = "KEY_DADOS_CMOS";
    private int qtdErroConexao = 0;
    private Logger logger = CTFClientLogger.getCTFClient();

    public static CMOSPinPad getInstance() throws ExcecaoApiAc {
        if (instance == null) {
            instance = new CMOSPinPad();
        }
        return instance;
    }

    private CMOSPinPad() throws ExcecaoApiAc {
        this.persistenciaObjetos = new PersistenciaObjetos(PATH_NAME);
        try {
            this.dadosCMOS = (Map)this.persistenciaObjetos.get(KEY_DADOS_CMOS);
        }
        catch (Exception e) {
            this.logger.log((Priority)Level.INFO, (Object)"Problema ao recuperar a CMOS do Pinpad, criando uma nova");
        }
        if (this.dadosCMOS == null) {
            this.dadosCMOS = new HashMap();
        }
    }

    private void inicializaDadosRede(String rede) {
        if (!this.dadosCMOS.containsKey(rede)) {
            this.dadosCMOS.put(rede + "", new DadosCMOSPinpad());
        }
    }

    public void solicitarCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede + "");
        dadosPinpad.setTimestamp(this.gerarTimeStamp(rede + ""));
        try {
            dadosPinpad.setCargaTabelasSolicitada(true);
            this.persistirDados();
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
        }
    }

    public boolean isCargaTabelasSolicitada(int rede) {
        try {
            if (this.dadosCMOS.containsKey(rede + "")) {
                return ((DadosCMOSPinpad)this.dadosCMOS.get(rede + "")).isCargaTabelasSolicitada();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    private String gerarTimeStamp(String rede) {
        int sequencial = 1;
        this.inicializaDadosRede(rede);
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede);
        String timeStamp = dadosPinpad.getTimestamp();
        Date nowDate = new Date();
        Date dateTimeStamp = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        if (timeStamp != null) {
            try {
                if (timeStamp.substring(0, 8).equals(dateFormat.format(nowDate))) {
                    int tentativas = Integer.parseInt(timeStamp.substring(8));
                    sequencial = tentativas == 99 ? 1 : tentativas + 1;
                    dateTimeStamp = dateFormat.parse(timeStamp.substring(0, 8));
                } else {
                    dateTimeStamp = nowDate;
                    sequencial = 1;
                }
            }
            catch (ParseException e) {
                dateTimeStamp = nowDate;
                sequencial = 1;
            }
        }
        DecimalFormat decimalFormat = new DecimalFormat("00");
        return dateFormat.format(dateTimeStamp) + decimalFormat.format(sequencial);
    }

    public String getTimeStamp(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede + "");
        if (dadosPinpad.getTimestamp() == null || dadosPinpad.isRefazCargaTabelas()) {
            dadosPinpad.setTimestamp(this.gerarTimeStamp(rede + ""));
            if (this.isRefazCargaTabelas(rede)) {
                this.refazerCargaTabelas(rede, false);
            }
            try {
                this.persistirDados();
            }
            catch (ExcecaoApiAc e) {
                e.printStackTrace();
            }
        }
        return dadosPinpad.getTimestamp();
    }

    private void persistirDados() throws ExcecaoApiAc {
        this.persistenciaObjetos.save(KEY_DADOS_CMOS, this.dadosCMOS);
        this.persistenciaObjetos.persist(true);
    }

    public void habilitaCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede + "");
        dadosPinpad.setCargaTabelasSolicitada(false);
        try {
            this.persistirDados();
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
        }
    }

    public void refazerCargaTabelas(int rede) {
        this.refazerCargaTabelas(rede, true);
    }

    private void refazerCargaTabelas(int rede, boolean value) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede + "");
        dadosPinpad.setRefazCargaTabelas(value);
        try {
            this.persistirDados();
        }
        catch (ExcecaoApiAc e) {
            e.printStackTrace();
        }
    }

    public boolean isRefazCargaTabelas(int rede) {
        this.inicializaDadosRede(rede + "");
        DadosCMOSPinpad dadosPinpad = (DadosCMOSPinpad)this.dadosCMOS.get(rede + "");
        return dadosPinpad.isRefazCargaTabelas();
    }

    public int novaTentativaConexao() {
        ++this.qtdErroConexao;
        return this.qtdErroConexao;
    }

    public void limpaTentativaConexoes() {
        this.qtdErroConexao = 0;
    }
}

