/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.operacoes.model.AbstractCartaoAtributosComuns;
import com.csi.ctfclient.operacoes.model.Cartao;
import com.csi.ctfclient.tools.util.StringUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class CartaoDigitado
extends AbstractCartaoAtributosComuns
implements Cartao {
    private String numero;
    private String numeroCriptografado;
    private String panCripto;
    private String vencimento;
    private String emissao;
    private boolean fallback = false;

    public CartaoDigitado(String numeroCartao) throws IllegalArgumentException {
        if (!this.isValidNumeroDigitado(numeroCartao)) {
            throw new IllegalArgumentException("Numero do cart\u00e3o invalido");
        }
        this.numero = numeroCartao;
    }

    public CartaoDigitado(String numeroCartao, boolean fallback) throws IllegalArgumentException {
        if (!this.isValidNumeroDigitado(numeroCartao)) {
            throw new IllegalArgumentException("Numero do cart\u00e3o invalido");
        }
        this.numero = numeroCartao;
        this.fallback = fallback;
    }

    public String getNumero() {
        return this.numero;
    }

    private boolean isValidNumeroDigitado(String digito) {
        return digito != null && digito.length() >= 11 && digito.length() <= 19;
    }

    public String getVencimento() {
        return this.vencimento;
    }

    public String getEmissao() {
        return this.emissao;
    }

    public void setEmissao(String dataEmissao) {
        this.emissao = dataEmissao;
    }

    public Date getDateVencimento() {
        if (this.vencimento.length() != 4) {
            throw new IllegalArgumentException("Vencimento Invalido " + this.vencimento);
        }
        try {
            int year = 2000 + Integer.parseInt(this.vencimento.substring(2));
            int month = Integer.parseInt(this.vencimento.substring(0, 2));
            int day = 1;
            String dataString = StringUtil.completaString("" + day, 2, '0', 3);
            dataString = dataString + StringUtil.completaString("" + month, 2, '0', 3);
            dataString = dataString + year;
            Date date = new SimpleDateFormat("ddMMyyyy").parse(dataString);
            return date;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Vencimento Invalido " + this.vencimento);
        }
    }

    public void setVencimento(String vencimento) {
        this.vencimento = vencimento;
    }

    public static boolean isValidaVencimento21Anos(String vencimento) {
        try {
            Date dataVencimento;
            Date nowDate = new Date();
            Calendar calender = GregorianCalendar.getInstance();
            calender.setTime(nowDate);
            calender.add(1, 20);
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMyy");
            dateFormat.setLenient(false);
            String monthStr = String.valueOf(month);
            if (month < 10) {
                monthStr = "0" + month;
            }
            return !(dataVencimento = dateFormat.parse(monthStr + year)).after(calender.getTime());
        }
        catch (ParseException e) {
            return false;
        }
    }

    public static boolean isValidaVencimento(String vencimento) {
        if (vencimento.length() != 4) {
            return false;
        }
        try {
            Date dataVencimento;
            Date nowDate = new Date();
            SimpleDateFormat nowFormat = new SimpleDateFormat("MMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            int year = 2000 + Integer.parseInt(vencimento.substring(2));
            int month = Integer.parseInt(vencimento.substring(0, 2));
            SimpleDateFormat dateFormat = new SimpleDateFormat("MMyyyy");
            dateFormat.setLenient(false);
            String monthStr = String.valueOf(month);
            if (month < 10) {
                monthStr = "0" + month;
            }
            return !(dataVencimento = dateFormat.parse(monthStr + year)).before(nowDate);
        }
        catch (ParseException e) {
            return false;
        }
    }

    public String getPAN() {
        return this.numero;
    }

    public boolean isFallback() {
        return this.fallback;
    }

    public void setFallback(boolean fallback) {
        this.fallback = fallback;
    }

    public String getNumeroCriptografado() {
        return this.numeroCriptografado;
    }

    public void setNumeroCriptografado(String numeroCriptografado) {
        this.numeroCriptografado = numeroCriptografado;
    }

    public String getPanCripto() {
        return this.panCripto;
    }

    public void setPanCripto(String panCripto) {
        this.panCripto = panCripto;
    }
}

