/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.operacoes.model.AbstractCodigoPagamento;
import java.math.BigDecimal;

public class CodigoBarrasConvenio
extends AbstractCodigoPagamento {
    public static final int SEGMENTO_PREFEITURA = 1;
    public static final int SEGMENTO_SANEAMENTO = 2;
    public static final int SEGMENTO_ENERGIA_ELETRICA_E_GAS = 3;
    public static final int SEGMENTO_TELECOMUNICACOES = 4;
    public static final int SEGMENTO_ORGAOS_GOVERNAMENTAIS = 5;
    public static final int SEGMENTO_CARNES = 6;
    public static final int SEGMENTO_USO_INTERNO_BANCO = 9;
    private String segmento;
    private int identificadorRealReferencia;
    private BigDecimal valor;

    public CodigoBarrasConvenio(String codigoBarras) {
        super(codigoBarras);
        if (codigoBarras != null && codigoBarras.length() >= 44) {
            if (!codigoBarras.substring(0, 1).equals("8")) {
                throw new IllegalArgumentException("O c\u00f3digo de barras informado n\u00e3o \u00e9 um conv\u00eanio");
            }
        } else {
            throw new IllegalArgumentException("C\u00f3digo de barras nulo ou de tamanho inv\u00e1lido");
        }
        this.setTipoConta(2);
        this.segmento = codigoBarras.substring(1, 2);
        this.identificadorRealReferencia = new Integer(codigoBarras.substring(2, 3));
        this.valor = new BigDecimal(codigoBarras.substring(4, 15));
        this.valor = this.valor.movePointLeft(2);
    }

    public int getIdentificadorRealReferencia() {
        return this.identificadorRealReferencia;
    }

    public String getSegmento() {
        return this.segmento;
    }

    public BigDecimal getValor() {
        return this.valor;
    }
}

