/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.Criptografia;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.generic.Ansi98Crypto;
import com.csi.ctfclient.tools.devices.generic.Des;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ControladorModeloPinPad {
    private static Logger logger = CTFClientLogger.getCTFClient();
    public static String VERIFONE = "VERIFONE";
    public static String INGENICO = "INGENICO";
    public static String GERTEC = "GERTEC";
    public static String DIONE = "DIONE";
    public static String FILE_PPVISA = "PPVISA.INI";
    private static String PINPAD = "./PinPad.properties";
    private static Map pinpad = null;
    private static ControladorModeloPinPad controladorModeloPinPad = null;
    private Properties properties = null;

    private ControladorModeloPinPad() throws ExcecaoApiAc {
        try {
            this.properties = new Properties();
            pinpad = new HashMap();
            InputStream inputStream = ClassLoader.getSystemResourceAsStream(PINPAD);
            this.properties.load(inputStream);
            pinpad.put(VERIFONE, this.createCriptografia((String)this.properties.get(VERIFONE)));
            pinpad.put(INGENICO, this.createCriptografia((String)this.properties.get(INGENICO)));
            pinpad.put(GERTEC, this.createCriptografia((String)this.properties.get(GERTEC)));
            pinpad.put(DIONE, this.createCriptografia((String)this.properties.get(DIONE)));
        }
        catch (Exception e) {
            logger.log((Priority)Level.ERROR, (Object)"Erro ao ler arquivo PinPad.properties");
            throw new ExcecaoApiAc("Erro ao ler arquivo PinPad.properties");
        }
    }

    public static ControladorModeloPinPad getInstance() throws ExcecaoApiAc {
        if (controladorModeloPinPad == null) {
            controladorModeloPinPad = new ControladorModeloPinPad();
        }
        return controladorModeloPinPad;
    }

    public Criptografia getCriptografia(PinEMV pinEMV) throws ExcecaoApiAc {
        Criptografia value = null;
        String fabricante = "";
        if (pinEMV.isBibliotecaEMV()) {
            SaidaGetInfoEMV info = pinEMV.getInfo();
            fabricante = info.getFabricante().toUpperCase();
        } else {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"localizando fabricante pinpad em ppvisa.ini");
                }
                File file = new File(FILE_PPVISA);
                FileReader fileReader = new FileReader(file);
                BufferedReader reader = new BufferedReader(fileReader);
                String line = null;
                while ((line = reader.readLine()) != null) {
                    String parametro;
                    int i = line.indexOf(61);
                    if (i == -1 || !(parametro = line.substring(0, i).trim()).equalsIgnoreCase("DRIVER") || line.length() - i <= 1) continue;
                    fabricante = line.substring(i + 1).trim();
                    break;
                }
            }
            catch (IOException e) {
                logger.log((Priority)Level.ERROR, (Object)("Erro ao ler arquivo -> " + FILE_PPVISA));
                throw new ExcecaoApiAc(e.getMessage());
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("fabricante pinpad em ppvisa.ini - > " + fabricante));
        }
        if (fabricante.indexOf(DIONE) != -1 || fabricante.indexOf("DIO") != -1) {
            value = (Criptografia)pinpad.get(DIONE);
        } else if (fabricante.indexOf(GERTEC) != -1 || fabricante.indexOf("GER") != -1) {
            value = (Criptografia)pinpad.get(GERTEC);
        } else if (fabricante.indexOf(VERIFONE) != -1 || fabricante.indexOf("VFN") != -1) {
            value = (Criptografia)pinpad.get(VERIFONE);
        } else if (fabricante.indexOf(INGENICO) != -1 || fabricante.indexOf("ING") != -1) {
            value = (Criptografia)pinpad.get(INGENICO);
        }
        if (value != null) {
            return value;
        }
        logger.log((Priority)Level.ERROR, (Object)"Fabricante ou modelo de PinPad n\u00e3o compativel com CTFClient");
        throw new ExcecaoApiAc("Erro ao localizar configura\u00e7\u00f5es do fabricante do PinPad");
    }

    private Criptografia createCriptografia(String value) {
        String[] info = value.split(";");
        Criptografia criptografia = new Criptografia(0, Integer.parseInt(info[1]), ControladorModeloPinPad.decriptografa(info[0]), true);
        return criptografia;
    }

    private static String decriptografa(String workingKey) {
        String workingKeyDecriptografada = "";
        byte[] workingKeyBytes = Ansi98Crypto.chaveStrHex2Bin(workingKey);
        byte[] chaveBytes = Ansi98Crypto.chaveStrHex2Bin("9212470633610598");
        workingKeyDecriptografada = Ansi98Crypto.chaveBin2StrHex(Des.decrypt(chaveBytes, workingKeyBytes));
        return workingKeyDecriptografada;
    }
}

