/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.tools.util.StringUtil;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class CorrespondenteBancario {
    private String cedente;
    private Date dataContabil;
    private boolean pagamentoDinheiro;
    private boolean pagamentoCheque;
    private boolean pagamentoChequeBanco;
    private boolean pagamentoDebito;
    private boolean pagamentoCredito;
    private boolean pagamentoCartaoProprio;
    private String numeroConvenio;
    private BigDecimal valorDevido;
    private BigDecimal valorOriginal;
    private String filler;
    private String autenticacao;

    public static CorrespondenteBancario createCorrespondenteBancario(String strCorBan) {
        Date date;
        if (strCorBan == null || strCorBan.length() < 116) {
            return null;
        }
        CorrespondenteBancario corban = new CorrespondenteBancario();
        corban.setCedente(strCorBan.substring(0, 40).trim());
        String strData = strCorBan.substring(40, 46);
        try {
            date = new SimpleDateFormat("yyMMdd").parse(strData);
        }
        catch (ParseException e) {
            date = null;
        }
        corban.setDataContabil(date);
        char[] formasPagamento = strCorBan.substring(46, 54).toCharArray();
        corban.setPagamentoDinheiro(formasPagamento[0] == '1');
        corban.setPagamentoCheque(formasPagamento[1] == '1');
        corban.setPagamentoChequeBanco(formasPagamento[2] == '1');
        corban.setPagamentoDebito(formasPagamento[3] == '1');
        corban.setPagamentoCredito(formasPagamento[4] == '1');
        corban.setPagamentoCartaoProprio(formasPagamento[5] == '1');
        corban.setNumeroConvenio(strCorBan.substring(54, 71).trim());
        String strValorDevido = strCorBan.substring(71, 83).trim();
        BigDecimal valorDevido = null;
        if (strValorDevido.length() > 0) {
            try {
                valorDevido = new BigDecimal(strValorDevido);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        corban.setValorDevido(valorDevido);
        String strValorOriginal = strCorBan.substring(83, 95).trim();
        BigDecimal valorOriginal = null;
        if (strValorOriginal.length() > 0) {
            try {
                valorOriginal = new BigDecimal(strValorOriginal);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        corban.setValorOriginal(valorOriginal);
        corban.setFiller(strCorBan.substring(95, 100).trim());
        corban.setAutenticacao(strCorBan.substring(100, 116).trim());
        return corban;
    }

    public static CorrespondenteBancario getStringCorrespondenteBancario(CorrespondenteBancario corban) {
        return null;
    }

    public String getAutenticacao() {
        return this.autenticacao;
    }

    public void setAutenticacao(String autenticacao) {
        this.autenticacao = autenticacao;
    }

    public String getCedente() {
        return this.cedente;
    }

    public void setCedente(String cedente) {
        this.cedente = cedente;
    }

    public Date getDataContabil() {
        return this.dataContabil;
    }

    public void setDataContabil(Date dataContabil) {
        this.dataContabil = dataContabil;
    }

    public String getFiller() {
        return this.filler;
    }

    public void setFiller(String filler) {
        this.filler = filler;
    }

    public String getNumeroConvenio() {
        return this.numeroConvenio;
    }

    public void setNumeroConvenio(String numeroConvenio) {
        this.numeroConvenio = numeroConvenio;
    }

    public BigDecimal getValorDevido() {
        return this.valorDevido;
    }

    public void setValorDevido(BigDecimal valorDevido) {
        this.valorDevido = valorDevido;
    }

    public BigDecimal getValorOriginal() {
        return this.valorOriginal;
    }

    public void setValorOriginal(BigDecimal valorOriginal) {
        this.valorOriginal = valorOriginal;
    }

    public boolean isPagamentoCartaoProprio() {
        return this.pagamentoCartaoProprio;
    }

    public void setPagamentoCartaoProprio(boolean pagamentoCartaoProprio) {
        this.pagamentoCartaoProprio = pagamentoCartaoProprio;
    }

    public boolean isPagamentoCheque() {
        return this.pagamentoCheque;
    }

    public void setPagamentoCheque(boolean pagamentoCheque) {
        this.pagamentoCheque = pagamentoCheque;
    }

    public boolean isPagamentoChequeBanco() {
        return this.pagamentoChequeBanco;
    }

    public void setPagamentoChequeBanco(boolean pagamentoChequeBanco) {
        this.pagamentoChequeBanco = pagamentoChequeBanco;
    }

    public boolean isPagamentoCredito() {
        return this.pagamentoCredito;
    }

    public void setPagamentoCredito(boolean pagamentoCredito) {
        this.pagamentoCredito = pagamentoCredito;
    }

    public boolean isPagamentoDebito() {
        return this.pagamentoDebito;
    }

    public void setPagamentoDebito(boolean pagamentoDebito) {
        this.pagamentoDebito = pagamentoDebito;
    }

    public boolean isPagamentoDinheiro() {
        return this.pagamentoDinheiro;
    }

    public void setPagamentoDinheiro(boolean pagamentoDinheiro) {
        this.pagamentoDinheiro = pagamentoDinheiro;
    }

    public static String montaEntrada(int modoEntrada, String codigoBarras, int modalidadePagamento) {
        String entrada = "";
        DecimalFormat format2Zeros = new DecimalFormat("00");
        entrada = entrada + modoEntrada;
        String codigoBarrasFormatado = codigoBarras.length() < 48 ? StringUtil.completaString(codigoBarras, 48, '0', 3) : codigoBarras;
        entrada = entrada + codigoBarrasFormatado;
        entrada = entrada + format2Zeros.format(modalidadePagamento);
        return entrada;
    }
}

