/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.model.ControladorEstatistica;
import com.csi.ctfclient.operacoes.model.DadosEstatistica;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoMensagem;
import com.csi.ctfclient.tools.devices.EventoPin;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoLeitorCartaoEMV;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Logger;

public class PerifericoEventHandler
implements PerifericoEntradaDadosListener {
    private Logger logger = CTFClientLogger.getPeriferico();
    private ControladorPerifericos perifericos;
    private static boolean active;

    public static synchronized void setActive(boolean a) {
        active = a;
    }

    public PerifericoEventHandler(ControladorPerifericos perifericos) {
        this.perifericos = perifericos;
    }

    public void eventoOcorrido(EventoDispositivoEntrada evt) {
        if (evt instanceof EventoMensagem && active) {
            EventoMensagem eventoMensagem = (EventoMensagem)evt;
            try {
                LayoutDisplay displayModel = new LayoutDisplay(eventoMensagem.getMensagem());
                this.perifericos.imprimeDisplay(displayModel);
            }
            catch (Exception e) {}
        } else if (evt instanceof EventoLeitorCartaoEMV) {
            EventoLeitorCartaoEMV evento = (EventoLeitorCartaoEMV)evt;
            try {
                boolean persistirDados = false;
                ControladorEstatistica controladorEstatistica = ControladorEstatistica.getInstance();
                DadosEstatistica dadosEstatistica = controladorEstatistica.getDadosEstatistica();
                if (!evento.getCartaoComErro() && evento.getErroCodigo() == 0) {
                    if (evento.getTipoCartao() == 0) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Cartao magnetico");
                        }
                        dadosEstatistica.addLeituraMagnetico();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 3) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Cartao chip EMV");
                        }
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    } else if (evento.getTipoCartao() == 4) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)"Cartao Easy Entry (Smart)");
                        }
                        dadosEstatistica.addLeituraSmart();
                        persistirDados = true;
                    }
                } else {
                    switch (evento.getErroCodigo()) {
                        case 41: {
                            dadosEstatistica.addErroLeituraMagnetico();
                            persistirDados = true;
                            break;
                        }
                        case 60: {
                            break;
                        }
                    }
                }
                if (persistirDados) {
                    controladorEstatistica.persistirDados(dadosEstatistica);
                }
            }
            catch (ExcecaoApiAc e) {
                this.logger.error((Object)"Erro ao contabilizar estat\u00edstica em PerifericoEventHandler", (Throwable)e);
            }
        } else if (evt instanceof EventoLeitorDocumento) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"EventoLeitorDocumento");
            }
        } else if (evt instanceof EventoPin) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"EventoPin");
            }
        } else if (evt instanceof EventoScanner) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"EventoScanner");
            }
        } else if (evt instanceof EventoTeclado && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"EventoTeclado");
        }
    }
}

