/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model;

import com.csi.ctfclient.operacoes.model.PlanoAPrazo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class PlanoParcelado
extends PlanoAPrazo {
    private int prazoAgendamentoDia = -1;
    private int prazoAgendamentoMes = -1;

    public int getPrazoAgendamentoDia() {
        return this.prazoAgendamentoDia;
    }

    public void setPrazoAgendamentoDia(int prazoAgendamentoDia) {
        this.prazoAgendamentoDia = prazoAgendamentoDia;
    }

    public int getPrazoAgendamentoMes() {
        return this.prazoAgendamentoMes;
    }

    public void setPrazoAgendamentoMes(int prazoAgendamentoMes) {
        this.prazoAgendamentoMes = prazoAgendamentoMes;
    }

    public boolean isData1ParcelaValida(Date nowDate) {
        Date nowDateSemHora = null;
        try {
            nowDateSemHora = this.removerHora(nowDate);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (this.getData1parcela().before(nowDateSemHora)) {
            return false;
        }
        GregorianCalendar calender = new GregorianCalendar();
        calender.setTime(nowDate);
        if (this.getPrazoAgendamentoDia() >= 0) {
            calender.add(5, this.getPrazoAgendamentoDia());
            return !this.getData1parcela().after(calender.getTime());
        }
        if (this.getPrazoAgendamentoMes() >= 0) {
            calender.add(2, this.getPrazoAgendamentoMes());
            return !this.getData1parcela().after(calender.getTime());
        }
        return true;
    }

    public boolean isData1ParcelaValida(Date nowDate, Date data1Parcela) {
        try {
            SimpleDateFormat nowFormat = new SimpleDateFormat("ddMMyyyy");
            nowDate = nowFormat.parse(nowFormat.format(nowDate));
            data1Parcela = nowFormat.parse(nowFormat.format(data1Parcela));
            if (data1Parcela.before(nowDate)) {
                return false;
            }
            GregorianCalendar calender = new GregorianCalendar();
            calender.setTime(nowDate);
            if (this.getPrazoAgendamentoDia() >= 0) {
                calender.add(5, this.getPrazoAgendamentoDia());
                return !data1Parcela.after(calender.getTime());
            }
            if (this.getPrazoAgendamentoMes() >= 0) {
                calender.add(2, this.getPrazoAgendamentoMes());
                return !data1Parcela.after(calender.getTime());
            }
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private Date removerHora(Date nowDate) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat("ddMMyy");
        df.setLenient(false);
        Calendar calendar = Calendar.getInstance();
        int day = calendar.get(5);
        int month = calendar.get(2) + 1;
        int year = calendar.get(1);
        String dayString = null;
        String monthString = null;
        dayString = day < 10 ? "0" + day : String.valueOf(day);
        monthString = month < 10 ? "0" + month : String.valueOf(month);
        return df.parse(dayString + monthString + year);
    }
}

