/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.operacoes.model.Aid;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ControladorAIDs {
    public static final String TIPO_APLICACAO_CREDITO = "01";
    public static final String TIPO_APLICACAO_DEBITO = "02";
    public static final String TIPO_APLICACAO_MOEDEIRO = "03";
    public static final String TIPO_APLICACAO_PRIVATE_LABEL = "05";
    public static final String TIPO_APLICACAO_COMPRA_E_SAQUE = "06";
    private static final String TABELA_PARAMETROS_X_AID = "1";
    private static final String TABELA_CHAVES_PUBLICAS = "2";
    private Logger logger = CTFClientLogger.getCTFClient();
    private Map mapListAIDs = new HashMap();

    public void addLinhaCargaTabelas(String linhaCarga) {
        if (linhaCarga != null && linhaCarga.length() > 42 && linhaCarga.substring(3, 4).equals(TABELA_PARAMETROS_X_AID)) {
            Aid aid = new Aid();
            aid.setRede(linhaCarga.substring(4, 6));
            aid.setIndice(linhaCarga.substring(6, 8));
            int tamanhoAid = Integer.parseInt(linhaCarga.substring(8, 10));
            aid.setApplicationId(linhaCarga.substring(10, 10 + tamanhoAid * 2));
            aid.setTipoAplicacao(linhaCarga.substring(42, 44));
            if (aid.getTipoAplicacao().equals(TIPO_APLICACAO_PRIVATE_LABEL)) {
                this.logger.log((Priority)Level.DEBUG, (Object)("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + TIPO_APLICACAO_CREDITO));
                aid.setTipoAplicacao(TIPO_APLICACAO_CREDITO);
            } else if (aid.getTipoAplicacao().equals(TIPO_APLICACAO_MOEDEIRO) || aid.getTipoAplicacao().equals(TIPO_APLICACAO_COMPRA_E_SAQUE)) {
                this.logger.log((Priority)Level.DEBUG, (Object)("Substituindo AID tipo: " + aid.getTipoAplicacao() + " pelo tipo: " + TIPO_APLICACAO_DEBITO));
                aid.setTipoAplicacao(TIPO_APLICACAO_DEBITO);
            }
            LinkedList<Aid> listTipoAplicacao = (LinkedList<Aid>)this.mapListAIDs.get(aid.getTipoAplicacao());
            if (listTipoAplicacao == null) {
                listTipoAplicacao = new LinkedList<Aid>();
                this.mapListAIDs.put(aid.getTipoAplicacao(), listTipoAplicacao);
            }
            if (!listTipoAplicacao.contains(aid)) {
                listTipoAplicacao.add(aid);
                this.logger.log((Priority)Level.DEBUG, (Object)("AID adicionado: " + aid.getApplicationId() + " do tipo: " + this.getDescricaoTipoAplicacao(aid.getTipoAplicacao())));
            } else {
                this.logger.log((Priority)Level.DEBUG, (Object)("AID ignorado:   " + aid.getApplicationId()));
            }
        }
    }

    private String getDescricaoTipoAplicacao(String tipoAplicacao) {
        if (TIPO_APLICACAO_CREDITO.equals(tipoAplicacao)) {
            return "Cr\u00e9dito";
        }
        if (TIPO_APLICACAO_DEBITO.equals(tipoAplicacao)) {
            return "D\u00e9bito";
        }
        if (TIPO_APLICACAO_MOEDEIRO.equals(tipoAplicacao)) {
            return "Moedeiro";
        }
        return "Desconhecido";
    }

    public Map getMapAIDs() {
        return this.mapListAIDs;
    }
}

