/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.servicos.IdentTerminal;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ControladorPersistencia {
    private static ControladorPersistencia controladorPersistencia;
    private final String PERSISTENCE_FILE = "Controles.dat";
    private static Logger logger;

    public static synchronized ControladorPersistencia getInstance() {
        if (controladorPersistencia == null) {
            controladorPersistencia = new ControladorPersistencia();
        }
        return controladorPersistencia;
    }

    private String formatPathName(IdentTerminal identTerminal, int versaoPathTerminal) throws ExcecaoApiAc {
        int idxEmpresa = versaoPathTerminal == 1 ? 0 : 1;
        String path = "./" + identTerminal.getEstabelecimento().substring(idxEmpresa) + identTerminal.getLoja() + "." + identTerminal.getTerminal() + "/";
        return path + "/";
    }

    private String formatPath(IdentTerminal identTerminal, int versaoPathTerminal) throws ExcecaoApiAc {
        return this.formatPathName(identTerminal, versaoPathTerminal) + "Controles.dat";
    }

    public synchronized void persistirDados(IdentTerminal identTerminal, DadosPersistencia obj, int versaoPathTerminal) throws ExcecaoApiAc {
        String path = this.formatPath(identTerminal, versaoPathTerminal);
        this.createPath(path);
        try {
            ObjectOutputStream output = new ObjectOutputStream(new FileOutputStream(path));
            output.writeObject(obj);
            output.close();
        }
        catch (Exception e) {
            throw new ExcecaoApiAc(null, "Erro ao gravar arquivo", "", e);
        }
    }

    public DadosPersistencia getDadosPersistencia(IdentTerminal identTerminal, int versaoPathTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal, versaoPathTerminal);
        DadosPersistencia obj = null;
        try {
            ObjectInputStream input = null;
            FileInputStream fileInput = null;
            try {
                fileInput = new FileInputStream(name);
                input = new ObjectInputStream(fileInput);
            }
            catch (StreamCorruptedException e) {
                logger.log((Priority)Level.WARN, (Object)("O arquivo " + name + " est\u00e1 corrompido e ser\u00e1 deletado"));
                fileInput.close();
                File file = new File(name);
                if (file.exists()) {
                    logger.log((Priority)Level.WARN, (Object)(name + " deletado " + file.delete()));
                }
                throw new ExcecaoApiAc(null, "LOAD", "ARQUIVO CORROMPIDO", e);
            }
            try {
                obj = (DadosPersistencia)input.readObject();
            }
            catch (ClassNotFoundException e) {
                throw new ExcecaoApiAc("CMOS00", "LOAD", "CLASSNOTFOUND", e);
            }
            input.close();
            fileInput.close();
        }
        catch (IOException e) {
            throw new ExcecaoApiAc("CMOS00", "ERRO", "ERRO_FILE", e);
        }
        return obj;
    }

    public void remove(IdentTerminal identTerminal, int versaoPathTerminal) throws ExcecaoApiAc {
        String name = this.formatPath(identTerminal, versaoPathTerminal);
        File file = new File(name);
        file.delete();
    }

    private void createPath(String path) {
        File arquivo;
        if (path.lastIndexOf("/") != -1 && !(arquivo = new File(path.substring(0, path.lastIndexOf("/")))).exists()) {
            arquivo.mkdirs();
        }
    }

    static {
        logger = CTFClientLogger.getCTFClient();
    }
}

