/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.apitef.Apitef;
import com.csi.ctfclient.apitef.EntradaApiTefC;
import com.csi.ctfclient.apitef.IdentApiTefC;
import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.operacoes.model.DadoPersistencia;
import com.csi.ctfclient.operacoes.model.DadosPersistencia;
import com.csi.ctfclient.operacoes.model.controller.ControladorPersistencia;
import com.csi.ctfclient.servicos.EntradaCTFClientCtrl;
import com.csi.ctfclient.servicos.IdentTerminal;
import java.util.Date;

public class ControladorTransacaoPersistencia {
    private static final String OPERACAO_CONSULTA_OPERADORAS = "4S";
    private SaidaApiTefC saida;
    private EntradaApiTefC entrada;

    public void executaConsultaOperadoras(int tipoOperadora) throws ExcecaoApiAc {
        this.executaConsultaOperadoras(null, tipoOperadora);
    }

    public void executaConsultaOperadoras(EntradaCTFClientCtrl entradaIntegracao, int tipoOperadora) throws ExcecaoApiAc {
        EntradaApiTefC entrada = new EntradaApiTefC();
        entrada.setOperacao(OPERACAO_CONSULTA_OPERADORAS);
        IdentTerminal identTerminal = null;
        Date today = null;
        Apitef apiTef = Apitef.newInstance();
        ConfCTFClient conf = ControladorConfCTFClient.getInstance().getConfig();
        if (entradaIntegracao == null) {
            identTerminal = new IdentTerminal(conf.getEstabelecimento(), conf.getLoja(), conf.getTerminal());
            today = new Date();
        } else {
            identTerminal = entradaIntegracao.getIdentTerminal();
            today = entradaIntegracao.getDataAbertura();
        }
        IdentApiTefC ident = new IdentApiTefC();
        ident.setNumeroEstabelecimento(identTerminal.getEstabelecimento());
        ident.setNumeroLoja(identTerminal.getLoja());
        ident.setNumeroPdv(identTerminal.getTerminal());
        entrada.setDataCliente(today);
        entrada.setTimeoutCtf(15);
        entrada.setTimestamp(today);
        ident.setNumeroSites(String.valueOf(conf.getNumeroSites()));
        ident.setListaIP(conf.getIps());
        ident.setQuantidadeVias(conf.getQuantidadeVias());
        entrada.setTipoAutorizadora(tipoOperadora);
        SaidaApiTefC saida = apiTef.solicitacao(ident, entrada);
        if (saida.getRetorno() == 0) {
            DadosPersistencia persistenciaNova;
            ControladorPersistencia controladorPersistencia = ControladorPersistencia.getInstance();
            try {
                persistenciaNova = controladorPersistencia.getDadosPersistencia(identTerminal, conf.getVersaoPathTerminal());
            }
            catch (ExcecaoApiAc e) {
                persistenciaNova = new DadosPersistencia();
            }
            DadoPersistencia dadoPersistencia = new DadoPersistencia();
            dadoPersistencia.setUltimaAtualizacao(saida.getDataAutorizadora());
            switch (tipoOperadora) {
                case 3: {
                    dadoPersistencia.setDado(saida.getOperadoras());
                    persistenciaNova.setListOperadorasValeGas(dadoPersistencia);
                    break;
                }
                case 4: {
                    dadoPersistencia.setDado(saida.getOperadoras());
                    persistenciaNova.setListOperadorasTelefonia(dadoPersistencia);
                    break;
                }
                case 8: {
                    dadoPersistencia.setDado(saida.getOperadorasRecarga());
                    persistenciaNova.setListaOperadorasRecarga(dadoPersistencia);
                    break;
                }
            }
            controladorPersistencia.persistirDados(identTerminal, persistenciaNova, conf.getVersaoPathTerminal());
        }
        this.entrada = entrada;
        this.saida = saida;
    }

    public SaidaApiTefC getSaida() {
        return this.saida;
    }

    public void setSaida(SaidaApiTefC saida) {
        this.saida = saida;
    }

    public EntradaApiTefC getEntrada() {
        return this.entrada;
    }

    public void setEntrada(EntradaApiTefC entrada) {
        this.entrada = entrada;
    }
}

