/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.operacoes.model.controller;

import com.csi.ctfclient.apitef.SaidaApiTefC;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class PinpadUtil {
    private static final String TOKEN_VALOR = "%valor%";
    private static Logger logger = CTFClientLogger.getCTFClient();

    public static String montaDisplaySenha(BigDecimal valor, SaidaApiTefC saida) {
        String msgDisplay = "";
        NumberFormat format = DecimalFormat.getInstance(new Locale("pt", "BR"));
        format.setMinimumFractionDigits(2);
        format.setGroupingUsed(true);
        String valorFormatado = null;
        if (valor != null) {
            valorFormatado = format.format(valor);
        }
        if (saida.getMensagemSenhaPinpad() != null) {
            if (valorFormatado != null && valor.compareTo(new BigDecimal(0)) == 1) {
                String mensagemPinpad = saida.getMensagemSenhaPinpad();
                int posicaoToken = mensagemPinpad.indexOf(TOKEN_VALOR);
                if (posicaoToken > -1) {
                    int posicaoValor;
                    if (posicaoToken - valorFormatado.length() - 1 >= 0) {
                        posicaoValor = posicaoToken - valorFormatado.length() - 1;
                        valorFormatado = " " + valorFormatado;
                    } else {
                        posicaoValor = 0;
                    }
                    msgDisplay = mensagemPinpad = mensagemPinpad.substring(0, posicaoValor) + valorFormatado + mensagemPinpad.substring(posicaoToken + TOKEN_VALOR.length(), mensagemPinpad.length());
                } else {
                    logger.log((Priority)Level.WARN, (Object)("Token (%valor%) n\u00e3o encontrado no display do Pinpad respondido pelo CTF. Retorno: (" + mensagemPinpad + ")"));
                    msgDisplay = mensagemPinpad;
                }
            } else {
                msgDisplay = saida.getMensagemSenhaPinpad();
            }
        } else {
            if (valorFormatado != null) {
                msgDisplay = msgDisplay + StringUtil.completaString(valorFormatado, 11, ' ', 3);
                msgDisplay = valorFormatado.length() > 10 ? StringUtil.completaString(msgDisplay, 16, ' ', 3) : "Valor" + msgDisplay;
            }
            msgDisplay = msgDisplay + "Senha:";
        }
        return msgDisplay;
    }

    public static String montaDisplayNovaSenha() {
        return "DIGITE          NOVA SENHA      ";
    }

    public static String montaDisplayConfirmacaoNovaSenha() {
        return "CONFIRMACAO     NOVA SENHA      ";
    }

    public static String montaDisplayMensagemValor(String mensagem, BigDecimal valor, boolean alinhamentoEsqueda) {
        String msgDisplay = "";
        NumberFormat format = DecimalFormat.getInstance(new Locale("pt", "BR"));
        format.setMinimumFractionDigits(2);
        format.setGroupingUsed(true);
        String valorFormatado = null;
        if (valor != null) {
            valorFormatado = format.format(valor);
        }
        if (valorFormatado != null) {
            msgDisplay = msgDisplay + StringUtil.completaString(valorFormatado, 11, ' ', 3);
            msgDisplay = valorFormatado.length() > 10 ? StringUtil.completaString(msgDisplay, 16, ' ', 3) : "Valor" + msgDisplay;
        }
        msgDisplay = alinhamentoEsqueda ? msgDisplay + mensagem : msgDisplay + StringUtil.completaString(mensagem, 16, ' ', 3);
        return msgDisplay;
    }

    public static void main(String[] args) {
        PinpadUtil.montaDisplaySenha(new BigDecimal("3.12"), new SaidaApiTefC());
        PinpadUtil.montaDisplaySenha(new BigDecimal("9999999.99"), new SaidaApiTefC());
        PinpadUtil.montaDisplayMensagemValor("Confirma?", new BigDecimal("100.80"), true);
        PinpadUtil.montaDisplayMensagemValor("Confirma?", new BigDecimal("9999999.99"), true);
    }
}

