/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.servicos;

public class IdentTerminal {
    private String estabelecimento;
    private String loja;
    private String terminal;

    public IdentTerminal() {
    }

    public IdentTerminal(String estabelecimento, String loja, String terminal) {
        this.estabelecimento = estabelecimento;
        this.loja = loja;
        this.terminal = terminal;
    }

    public String getEstabelecimento() {
        return this.estabelecimento;
    }

    public void setEstabelecimento(String estabelecimento) {
        this.estabelecimento = estabelecimento;
    }

    public String getLoja() {
        return this.loja;
    }

    public void setLoja(String loja) {
        this.loja = loja;
    }

    public String getTerminal() {
        return this.terminal;
    }

    public void setTerminal(String terminal) {
        this.terminal = terminal;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.estabelecimento == null ? 0 : this.estabelecimento.hashCode());
        result = 31 * result + (this.loja == null ? 0 : this.loja.hashCode());
        result = 31 * result + (this.terminal == null ? 0 : this.terminal.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdentTerminal other = (IdentTerminal)obj;
        if (this.estabelecimento == null ? other.estabelecimento != null : !this.estabelecimento.equals(other.estabelecimento)) {
            return false;
        }
        if (this.loja == null ? other.loja != null : !this.loja.equals(other.loja)) {
            return false;
        }
        return !(this.terminal == null ? other.terminal != null : !this.terminal.equals(other.terminal));
    }

    public static IdentTerminal parseIdentTerminal(String bufferTerminal) {
        if (bufferTerminal == null || bufferTerminal.trim().length() < 12) {
            throw new IllegalArgumentException("Terminal inv\u00e1lido");
        }
        String estabelecimento = bufferTerminal.substring(0, 5);
        String loja = bufferTerminal.substring(5, 9);
        String terminal = bufferTerminal.substring(9, 12);
        IdentTerminal iTerminal = new IdentTerminal(estabelecimento, loja, terminal);
        return iTerminal;
    }

    public static String parseCodigoMultitransacao(IdentTerminal iTerminal) {
        return iTerminal.getEstabelecimento() + iTerminal.getLoja() + iTerminal.getTerminal();
    }

    public Object clone() {
        IdentTerminal iTerminal = new IdentTerminal(this.getEstabelecimento(), this.getLoja(), this.getTerminal());
        return iTerminal;
    }

    public String toString() {
        String estab = this.estabelecimento != null ? this.estabelecimento : "";
        String loj = this.loja != null ? this.loja : "";
        String termin = this.terminal != null ? this.terminal : "";
        return estab + loj + "." + termin;
    }
}

