/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.communication.access;

import com.csi.ctfclient.excecoes.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.communication.Host;
import com.csi.ctfclient.tools.communication.Servico;
import com.csi.ctfclient.tools.communication.access.Conector;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoJaEstabelecida;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoNaoEstabelecida;
import com.csi.ctfclient.tools.communication.access.ExcecaoConexaoRecusada;
import com.csi.ctfclient.tools.communication.access.ExcecaoImpossivelEncontrarHost;
import com.csi.ctfclient.tools.communication.access.ExcecaoServicoLocalNaoDisponivel;
import com.csi.ctfclient.tools.communication.access.ExcecaoServicoNaoDefinido;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class ConectorTCPIP
extends Conector {
    private Socket socket = null;
    public static int SIT_CON_ESPERANDO = 0;
    public static int SIT_CON_ESTABELECENDO = 1;
    public static int SIT_CON_ESTABELECIDA = 2;
    public static int SIT_CON_ERRO = 3;

    public ConectorTCPIP(Servico remoto) throws ExcecaoParametroInvalido {
        super(remoto);
        this.servLocalAuto = true;
    }

    public ConectorTCPIP(Servico local, Servico remoto) throws ExcecaoParametroInvalido {
        super(local, remoto);
    }

    public ConectorTCPIP(Socket socket) throws ExcecaoParametroInvalido, ExcecaoImpossivelEncontrarHost, IOException {
        if (socket == null) {
            throw new ExcecaoParametroInvalido("COM033");
        }
        Host hostLocal = null;
        Host hostRemoto = null;
        try {
            hostLocal = new Host(InetAddress.getLocalHost().getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new ExcecaoImpossivelEncontrarHost("COM034", InetAddress.getLocalHost().getHostAddress(), "", e);
        }
        hostRemoto = new Host(socket.getInetAddress().getHostAddress());
        this.servicoLocal = new Servico(hostLocal, "" + socket.getLocalPort());
        this.servicoRemoto = new Servico(hostRemoto, "" + socket.getPort());
        this.fluxoEntrada = socket.getInputStream();
        this.fluxoSaida = socket.getOutputStream();
        this.socket = socket;
    }

    /*
     * Loose catch block
     */
    private void conecta() throws ExcecaoServicoNaoDefinido, ExcecaoImpossivelEncontrarHost, ExcecaoServicoLocalNaoDisponivel, ExcecaoConexaoJaEstabelecida, ExcecaoConexaoRecusada {
        block15: {
            boolean erro;
            block14: {
                if (this.socket != null) {
                    throw new ExcecaoConexaoJaEstabelecida();
                }
                erro = false;
                if (this.servLocalAuto) {
                    this.socket = new Socket(this.servicoRemoto.getHost().getEndereco(), Integer.parseInt(this.servicoRemoto.getIdentificadorServico()));
                    if (this.socket != null) {
                        Host hostLocal = new Host(InetAddress.getLocalHost().getHostAddress());
                        Servico servLocal = new Servico(hostLocal, "" + this.socket.getLocalPort());
                        this.setServicoLocal(servLocal);
                    }
                } else {
                    InetAddress localAddress = InetAddress.getByName(this.servicoLocal.getHost().getEndereco());
                    this.socket = new Socket(this.servicoRemoto.getHost().getEndereco(), Integer.parseInt(this.servicoRemoto.getIdentificadorServico()), localAddress, Integer.parseInt(this.servicoLocal.getIdentificadorServico()));
                }
                if (this.socket == null) break block14;
                this.socket.setSoTimeout(this.timeoutTransmissao);
                this.socket.setTcpNoDelay(true);
                this.socket.setSoLinger(true, 0);
                this.fluxoEntrada = this.socket.getInputStream();
                this.fluxoSaida = this.socket.getOutputStream();
            }
            Object var5_8 = null;
            if (!erro || this.socket == null) break block15;
            try {
                this.socket.close();
            }
            catch (Exception e2) {
                // empty catch block
            }
            this.socket = null;
            this.fluxoEntrada = null;
            this.fluxoSaida = null;
            {
                break block15;
                catch (UnknownHostException e) {
                    erro = true;
                    throw new ExcecaoImpossivelEncontrarHost("COM035", this.servicoRemoto.toString(), "", e);
                }
                catch (IOException e) {
                    erro = true;
                    throw new ExcecaoConexaoRecusada("COM028", this.servicoRemoto.toString(), "", e);
                }
                catch (ExcecaoParametroInvalido e) {
                    erro = true;
                    throw new ExcecaoServicoLocalNaoDisponivel("COM028", this.servicoLocal.toString(), "", e);
                }
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (erro && this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    this.socket = null;
                    this.fluxoEntrada = null;
                    this.fluxoSaida = null;
                }
                throw throwable;
            }
        }
    }

    protected void implAbreConexao(int timeoutConexao) throws ExcecaoServicoNaoDefinido, ExcecaoImpossivelEncontrarHost, ExcecaoServicoLocalNaoDisponivel, ExcecaoConexaoJaEstabelecida, ExcecaoConexaoRecusada {
        if (timeoutConexao == TO_CONEXAO_LIVRE) {
            this.conecta();
            return;
        }
        ThreadConexao criacao = new ThreadConexao();
        criacao.start();
        long marcador = System.currentTimeMillis();
        long decorrido = 0L;
        while (true) {
            int situacao;
            if ((situacao = criacao.obterSituacao()) == SIT_CON_ESTABELECIDA) {
                criacao.finalizar();
                return;
            }
            if (situacao == SIT_CON_ERRO) {
                Exception e = criacao.obterErro();
                criacao.finalizar();
                if (e instanceof ExcecaoServicoNaoDefinido) {
                    throw (ExcecaoServicoNaoDefinido)e;
                }
                if (e instanceof ExcecaoImpossivelEncontrarHost) {
                    throw (ExcecaoImpossivelEncontrarHost)e;
                }
                if (e instanceof ExcecaoServicoLocalNaoDisponivel) {
                    throw (ExcecaoServicoLocalNaoDisponivel)e;
                }
                if (e instanceof ExcecaoConexaoJaEstabelecida) {
                    throw (ExcecaoConexaoJaEstabelecida)e;
                }
                if (e instanceof ExcecaoConexaoRecusada) {
                    throw (ExcecaoConexaoRecusada)e;
                }
                throw new ExcecaoImpossivelEncontrarHost("COM002");
            }
            decorrido = System.currentTimeMillis() - marcador;
            if (decorrido >= (long)timeoutConexao) {
                criacao.finalizar();
                try {
                    criacao.interrupt();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                throw new ExcecaoImpossivelEncontrarHost("COM116");
            }
            int tempoEspera = decorrido < 1000L ? 50 : (decorrido < 2000L ? 100 : (decorrido < 5000L ? 200 : (decorrido < 10000L ? 500 : 1000)));
            if ((long)tempoEspera > (long)timeoutConexao - decorrido) {
                tempoEspera = (int)((long)timeoutConexao - decorrido);
            }
            try {
                Thread.sleep(tempoEspera);
            }
            catch (Exception e) {
            }
        }
    }

    protected void implFechaConexao() throws ExcecaoConexaoNaoEstabelecida {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
    }

    protected void implSetTimeout(int timeout) throws ExcecaoParametroInvalido {
        if (timeout < 0) {
            throw new ExcecaoParametroInvalido("COM014");
        }
        this.timeoutTransmissao = timeout;
        if (this.socket != null) {
            try {
                this.socket.setSoTimeout(timeout);
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
    }

    private class ThreadConexao
    extends Thread {
        private int situacao = SIT_CON_ESPERANDO;
        private Exception erro = null;
        private boolean finalizado = false;

        private ThreadConexao() {
        }

        public int obterSituacao() {
            return this.situacao;
        }

        public Exception obterErro() {
            return this.erro;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finalizar() {
            this.finalizado = true;
            ThreadConexao threadConexao = this;
            synchronized (threadConexao) {
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.situacao = SIT_CON_ESTABELECENDO;
            try {
                ConectorTCPIP.this.conecta();
                this.situacao = SIT_CON_ESTABELECIDA;
            }
            catch (Exception e) {
                this.erro = e;
                this.situacao = SIT_CON_ERRO;
            }
            while (!this.finalizado) {
                ThreadConexao threadConexao = this;
                synchronized (threadConexao) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

