/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.config.ConfPeriferico;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ConfiguracaoPerifericos {
    private static Logger logger = CTFClientLogger.getPeriferico();
    public static final String DRIVER_TECLADO = "DRIVER_TECLADO";
    public static final String DRIVER_SCANNER = "DRIVER_SCANNER";
    public static final String DRIVER_LEITOR_DOCUMENTO = "DRIVER_LEITOR_DOCUMENTO";
    public static final String DRIVER_DISPLAY_CLIENTE = "DRIVER_DISPLAY_CLIENTE";
    public static final String DRIVER_DISPLAY_OPERADOR = "DRIVER_DISPLAY_OPERADOR";
    public static final String DRIVER_LEITOR_CARTAO = "com.csi.ctfclient.tools.devices.LeitorCartaoHandler";
    public static final String CONFIG_PINPAD = "CONFIG_PINPAD";
    public static final String PARAMS_LEITOR_CARTAO = "PARAMS_LEITOR_CARTAO";
    public static final String DRIVER_PINPAD = "com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad";
    public static final String PARAMS_PINPAD = "PARAMS_PINPAD";
    public static final String DRIVER_POSTEF = "DRIVER_POSTEF";
    public static final String PARAMS_POSTEF = "PARAMS_POSTEF";
    public static final String TIPO_POSTEF = "TIPO_POSTEF";
    public static final String TIPO_TECLADO_PC = "TECLADO_PC";
    public static final String TIPO_TECLADO_JAVAPOS = "TECLADO_JAVAPOS";
    public static final String TIPO_TECLADO_TOUCH_LINX = "TECLADO_TOUCH_LINX";
    public static final String TIPO_DISPLAY_AUTTAR = "DISPLAY_AUTTAR";
    public static final String TIPO_DISPLAY_CSI = "DISPLAY_CSI";
    public static final String TIPO_DISPLAY_JAVAPOS = "DISPLAY_JAVAPOS";
    public static final String TIPO_DISPLAY_CTFCLIENT = "DISPLAY_CTFCLIENT";
    public static final String TIPO_DISPLAY_OPERADOR = "DISPLAY_OPERADOR";
    public static final String TIPO_LEITOR_CARTAO_BIB_COMPARTILHADA = "LEITOR_CARTAO_BIB_COMPARTILHADA";
    public static final String TIPO_PINPAD_BIB_COMPARTILHADA = "PINPAD_BIB_COMPARTILHADA";
    public static final String TIPO_SCANNER_JAVAPOS = "SCANNER_JAVAPOS";
    public static final String TIPO_SCANNER_SERIAL = "SCANNER_SERIAL";
    public static final String TIPO_LEITOR_DOCUMENTO_CHRONOS = "LEITOR_DOCUMENTO_CHRONOS";
    public static final String TIPO_LEITOR_DOCUMENTO_LOGGER2 = "LEITOR_DOCUMENTO_LOGGER2";
    public static final String TIPO_LEITOR_DOCUMENTO_TECPOINTTL840 = "LEITOR_DOCUMENTO_TECPOINTTL840";
    private static final String MSG_ERRO_TECLADO = "N\u00e3o foi encontrado nenhum tecladoconfigurado, teclado obrigat\u00f3rio";
    private HashMap confPerifericos;
    private ConfPeriferico displayCliente;
    private static ConfiguracaoPerifericos instancia;

    public ConfiguracaoPerifericos(boolean carregarDisplay) {
        this.initialize(carregarDisplay);
    }

    public static ConfiguracaoPerifericos getInstancia() throws ExcecaoPerifericos {
        if (instancia == null) {
            instancia = new ConfiguracaoPerifericos(true);
        }
        return instancia;
    }

    private ConfCTFClient getConfigCTFClient() throws ExcecaoPerifericos {
        try {
            return ControladorConfCTFClient.getInstance().getConfig();
        }
        catch (ExcecaoApiAc e) {
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
    }

    private void initialize(boolean carregarDisplay) {
        logger.log((Priority)Level.INFO, (Object)"Inicializando mapa de perifericos...");
        this.confPerifericos = new HashMap();
        if (carregarDisplay) {
            this.displayCliente = new ConfPeriferico("DRIVE_DISPLAY_CLIENTE");
            this.displayCliente.setNomeClasse("com.csi.ctfclient.tools.devices.generic.JPanelDisplay");
            this.displayCliente.setParametros("40,35".split(","));
        }
        logger.log((Priority)Level.INFO, (Object)"Mapa de perifericos inicializado...");
        this.carregarDrives();
    }

    private static Object getInstancia(String nomeClasse, String[] parametros) throws ExcecaoPerifericos {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Carregando inst\u00e1ncia '" + nomeClasse + "' ");
        for (int x = 0; x < parametros.length; ++x) {
            buffer.append("'" + parametros[x] + "' ");
        }
        logger.info((Object)buffer.toString());
        Object result = null;
        try {
            Class<?> c = Class.forName(nomeClasse);
            Class[] classeParams = new Class[parametros.length];
            for (int i = 0; i < parametros.length; ++i) {
                classeParams[i] = String.class;
            }
            Constructor<?> cons = c.getConstructor(classeParams);
            result = cons.newInstance(parametros);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Erro: " + e));
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)("Erro: " + e));
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)("Erro: " + e));
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
        catch (InstantiationException e) {
            logger.error((Object)("Erro: " + e));
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExcecaoPerifericos) {
                logger.error((Object)("Erro: " + t));
                logger.error((Object)("Erro original: " + ((ExcecaoPerifericos)t).getExcecaoOriginal().getStackTrace()));
                throw (ExcecaoPerifericos)t;
            }
            logger.error((Object)("Erro: " + e));
            throw new ExcecaoPerifericos(null, "PER00", e);
        }
        logger.log((Priority)Level.INFO, (Object)(nomeClasse + ", carregado..."));
        return result;
    }

    private void carregarDrives() {
        try {
            logger.log((Priority)Level.INFO, (Object)"Inicializando drivers...");
        }
        catch (Exception e) {
            logger.error((Object)"Erro ao carregar as configura\u00e7\u00f5es dos drivers", (Throwable)e);
        }
    }

    public Display getPerifericoDisplayCliente() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_DISPLAY_CLIENTE) == null) {
            Display display = this.carregaDriveDisplay(this.displayCliente);
            this.confPerifericos.put(DRIVER_DISPLAY_CLIENTE, display);
            return display;
        }
        return (Display)this.confPerifericos.get(DRIVER_DISPLAY_CLIENTE);
    }

    public Display getPerifericoDisplayOperador() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_DISPLAY_OPERADOR) == null) {
            if (this.getConfigCTFClient().getDisplayOperador() != null) {
                Display display = this.carregaDriveDisplay(this.getConfigCTFClient().getDisplayOperador());
                this.confPerifericos.put(DRIVER_DISPLAY_OPERADOR, display);
                return display;
            }
            return null;
        }
        return (Display)this.confPerifericos.get(DRIVER_DISPLAY_OPERADOR);
    }

    public boolean isDisplayExterno() {
        try {
            if (this.getConfigCTFClient().getDisplayOperador() != null && TIPO_DISPLAY_AUTTAR.equals(this.getConfigCTFClient().getDisplayOperador().getNomeLogico())) {
                return true;
            }
        }
        catch (ExcecaoPerifericos excecaoPerifericos) {
            // empty catch block
        }
        return false;
    }

    public Teclado getPerifericoTeclado() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_TECLADO) == null) {
            if (this.getConfigCTFClient().getTeclado() != null) {
                if (this.getConfigCTFClient().getMapaTeclado() != null) {
                    logger.info((Object)("mapaTeclado configurado para -> " + this.getConfigCTFClient().getMapaTeclado()));
                    System.setProperty("com.csi.mapateclado.path", this.getConfigCTFClient().getMapaTeclado());
                } else if (this.getConfigCTFClient().getTeclado().getNomeLogico().equals(TIPO_TECLADO_JAVAPOS)) {
                    logger.info((Object)"mapaTeclado configurado para -> mapatecladoCTFClientJPOS.xml");
                    System.setProperty("com.csi.mapateclado.path", "mapatecladoCTFClientJPOS.xml");
                }
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getTeclado());
                this.confPerifericos.put(DRIVER_TECLADO, periferico);
                return (Teclado)periferico;
            }
            logger.error((Object)MSG_ERRO_TECLADO);
            throw new ExcecaoPerifericos(null, MSG_ERRO_TECLADO);
        }
        return (Teclado)this.confPerifericos.get(DRIVER_TECLADO);
    }

    public Scanner getPerifericoScanner() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_SCANNER) == null) {
            if (this.getConfigCTFClient().getScanner() != null) {
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getScanner());
                this.confPerifericos.put(DRIVER_SCANNER, periferico);
                return (Scanner)periferico;
            }
            return null;
        }
        return (Scanner)this.confPerifericos.get(DRIVER_SCANNER);
    }

    public PinEMV getPerifericoPin() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_PINPAD) == null) {
            if (this.getConfigCTFClient().getPin() != null) {
                this.getConfigCTFClient().getPin().setNomeClasse(DRIVER_PINPAD);
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getPin());
                this.confPerifericos.put(DRIVER_PINPAD, periferico);
                return (PinEMV)periferico;
            }
            return null;
        }
        return (PinEMV)this.confPerifericos.get(DRIVER_PINPAD);
    }

    public ILeitorCartaoHandler getPerifericoLeitorCartao() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_LEITOR_CARTAO) == null) {
            if (this.getConfigCTFClient().getLeitorCartao() != null) {
                this.getConfigCTFClient().getPin().setNomeClasse(DRIVER_LEITOR_CARTAO);
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getLeitorCartao());
                this.confPerifericos.put(DRIVER_LEITOR_CARTAO, periferico);
                return (ILeitorCartaoHandler)((Object)periferico);
            }
            return null;
        }
        return (ILeitorCartaoHandler)this.confPerifericos.get(DRIVER_LEITOR_CARTAO);
    }

    public LeitorDocumento getPerifericoLeitorDocumento() throws ExcecaoPerifericos {
        if (this.confPerifericos.get(DRIVER_LEITOR_DOCUMENTO) == null) {
            if (this.getConfigCTFClient().getLeitorDocumento() != null) {
                Periferico periferico = this.carregaDriverPeriferico(this.getConfigCTFClient().getLeitorDocumento());
                this.confPerifericos.put(DRIVER_LEITOR_DOCUMENTO, periferico);
                return (LeitorDocumento)periferico;
            }
            return null;
        }
        return (LeitorDocumento)this.confPerifericos.get(DRIVER_LEITOR_DOCUMENTO);
    }

    public boolean perifericoCarregado(String driver) {
        return this.confPerifericos.get(driver) != null;
    }

    public void liberaPeriferico(String driver) {
        this.confPerifericos.remove(driver);
    }

    private Display carregaDriveDisplay(ConfPeriferico confPeriferico) throws ExcecaoPerifericos {
        try {
            return (Display)ConfiguracaoPerifericos.getInstancia(confPeriferico.getNomeClasse(), confPeriferico.getParametros());
        }
        catch (Exception e) {
            logger.error((Object)("Erro ao carregar o driver " + confPeriferico.getNomeLogico()));
            throw new ExcecaoPerifericos(null, e.getMessage());
        }
    }

    private Periferico carregaDriverPeriferico(ConfPeriferico confPeriferico) throws ExcecaoPerifericos {
        try {
            return (Periferico)ConfiguracaoPerifericos.getInstancia(confPeriferico.getNomeClasse(), confPeriferico.getParametros());
        }
        catch (Exception e) {
            logger.error((Object)("Erro ao carregar o driver " + confPeriferico.getNomeLogico()));
            throw new ExcecaoPerifericos(null, e.getMessage());
        }
    }
}

