/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.config.ConfCTFClient;
import com.csi.ctfclient.config.ControladorConfCTFClient;
import com.csi.ctfclient.excecoes.ExcecaoNaoLocal;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.tools.devices.EntradaDeDados;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.ItemMenu;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.display.LayoutMenu;
import com.csi.ctfclient.tools.devices.display.Linha;
import com.csi.ctfclient.tools.util.ByteUtil;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class ControladorTranslator {
    private static Logger logger = CTFClientLogger.getTranslator();
    private static final int MAX_RETRY = 3;
    int colunasDisplayOpe = 20;
    int linhasDisplayOpe = 2;
    private OutputStream os;
    private InputStream is;
    private boolean started = false;
    private static ControladorTranslator controladorTranslator = null;

    private ControladorTranslator() {
        try {
            ConfCTFClient confCTFClient = ControladorConfCTFClient.getInstance().getConfig();
            String[] params = confCTFClient.getDisplayOperador().getParametros();
            this.linhasDisplayOpe = Integer.parseInt(params[0]);
            this.colunasDisplayOpe = Integer.parseInt(params[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static ControladorTranslator getInstancia() {
        if (controladorTranslator == null) {
            controladorTranslator = new ControladorTranslator();
        }
        return controladorTranslator;
    }

    public void bindSocketTranslator(InputStream is, OutputStream os) {
        this.os = os;
        this.is = is;
        this.started = true;
    }

    public void clearSocketTranslator() {
        this.started = false;
    }

    public static String[] recuperaPosentra(ByteArrayInputStream bis) {
        logger.debug((Object)"recupera posentra");
        String[] linhas = null;
        byte[] arrayTam = new byte[2];
        byte[] arrayHeard = new byte[2];
        byte[] arrayPosentra = null;
        try {
            bis.read(arrayTam, 0, arrayTam.length);
            short tam = ByteUtil.byteArrayToShort(arrayTam);
            if (tam > 0) {
                bis.read(arrayHeard, 0, arrayHeard.length);
                arrayPosentra = new byte[tam - 2];
                bis.read(arrayPosentra, 0, tam - 2);
                String posentra = new String(arrayPosentra);
                linhas = posentra.split("\r\n");
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return linhas;
    }

    public static void montaPossaida(OutputStream os, StringBuffer possaida) {
        logger.debug((Object)"monta possaida");
        try {
            String msg = possaida.toString();
            byte[] resp = new byte[4 + msg.length()];
            os.write(ByteUtil.shortToByteArray(resp.length - 2));
            os.write(1);
            os.write(4);
            os.write(msg.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void limpaDisplay() throws ExcecaoNaoLocal {
        byte tipoDisplay = 3;
        this.limpaDisplay(tipoDisplay);
    }

    private void limpaDisplay(byte display) throws ExcecaoNaoLocal {
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 3;
        byte[] comando = new byte[]{0, 4, versao, tipoMsg, tipoComando, display};
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            logger.debug((Object)"executa comando limpa display");
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 3) {
                logger.debug((Object)"erro na execucao do comando limpa display");
                ++retray;
                continue;
            }
            logger.debug((Object)"comando limpa display executado com sucesso");
            comandoOK = true;
        }
    }

    public int exibeDisplay(LayoutDisplay displayModel) throws ExcecaoNaoLocal {
        int i;
        int tamHeard = 6;
        byte versao = 1;
        int tipoMsg = 2;
        byte tipoComando = 1;
        int tipoDisplay = displayModel.getTipo();
        this.limpaDisplay((byte)tipoDisplay);
        logger.debug((Object)"montando texto do Display");
        String textoDisplay = "";
        List linhas = displayModel.getLinhas();
        for (int i2 = 1; i2 <= linhas.size(); ++i2) {
            Linha linha = (Linha)linhas.get(i2 - 1);
            String textoLinha = linha.getTexto();
            if (linha.getColuna() > 0) {
                textoLinha = StringUtil.completaString(textoLinha, textoLinha.length() + linha.getColuna(), ' ', 3);
            }
            if (linha.getPularLinha() > 0) {
                textoLinha = StringUtil.completaString(textoLinha, textoLinha.length() + linha.getPularLinha(), ';', 4);
            }
            textoDisplay = textoDisplay + textoLinha;
            if (i2 == linhas.size()) continue;
            textoDisplay = textoDisplay + ";";
        }
        if (displayModel.getTipo() == 1) {
            if (displayModel.getLinhas().size() == 1) {
                Linha linha = (Linha)displayModel.getLinhas().get(0);
                String texto = linha.getTexto().trim();
                if (texto.length() > this.colunasDisplayOpe) {
                    StringBuffer buffer = new StringBuffer();
                    for (int i3 = 0; i3 < texto.length(); ++i3) {
                        char c = texto.charAt(i3);
                        if (c == ' ' && i3 + 1 != texto.length() && texto.charAt(i3 + 1) == ' ') continue;
                        buffer.append(c);
                    }
                    if (textoDisplay.length() > this.colunasDisplayOpe) {
                        tipoDisplay = 2;
                    }
                    textoDisplay = buffer.toString();
                }
            } else {
                String[] arrayDisplay = textoDisplay.split(";");
                if (arrayDisplay.length == this.linhasDisplayOpe + 1 && arrayDisplay[arrayDisplay.length - 1].length() < this.colunasDisplayOpe) {
                    String ultimaLinha = arrayDisplay[arrayDisplay.length - 1];
                    if (ultimaLinha.substring(ultimaLinha.length() - 3).equals("...")) {
                        ultimaLinha = ultimaLinha.substring(0, ultimaLinha.length() - 3);
                    }
                    if (arrayDisplay[arrayDisplay.length - 2].length() + ultimaLinha.length() <= this.colunasDisplayOpe) {
                        String penultimaLinha = arrayDisplay[arrayDisplay.length - 2];
                        arrayDisplay[arrayDisplay.length - 2] = penultimaLinha + " " + ultimaLinha;
                        textoDisplay = "";
                        String[] array = new String[arrayDisplay.length - 1];
                        for (i = 0; i < arrayDisplay.length - 1; ++i) {
                            array[i] = arrayDisplay[i];
                            textoDisplay = textoDisplay + arrayDisplay[i];
                            if (i == arrayDisplay.length - 2) continue;
                            textoDisplay = textoDisplay + ";";
                        }
                        arrayDisplay = array;
                    }
                }
                if (arrayDisplay.length > this.linhasDisplayOpe) {
                    tipoDisplay = 2;
                }
            }
        }
        byte[] comando = new byte[tamHeard + (textoDisplay == null ? 0 : textoDisplay.length())];
        byte[] tamComando = ByteUtil.shortToByteArray(comando.length - 2);
        comando[0] = tamComando[0];
        comando[1] = tamComando[1];
        comando[2] = versao;
        comando[3] = tipoMsg;
        comando[4] = tipoComando;
        comando[5] = tipoDisplay;
        if (textoDisplay != null) {
            byte[] arrayMsg = textoDisplay.getBytes();
            int x = 0;
            i = tamHeard;
            while (i < comando.length) {
                comando[i] = arrayMsg[x];
                ++i;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            logger.debug((Object)"executa comando exibe display");
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 1) {
                logger.debug((Object)"erro na execucao do comando exibe display");
                ++retray;
                continue;
            }
            logger.debug((Object)"executa comando exibe display executado com sucesso");
            comandoOK = true;
            if (displayModel.getDelay() <= 0L) continue;
            try {
                Thread.sleep(displayModel.getDelay());
            }
            catch (InterruptedException e) {}
        }
        return 0;
    }

    protected void exibeTextoMenu(LayoutMenu displayModel) throws ExcecaoNaoLocal {
        logger.debug((Object)"executa comando exibeTextoMenu");
        int tamHeard = 6;
        byte versao = 1;
        int tipoMsg = 2;
        int tipoComando = 2;
        int tipoDisplay = 3;
        String textoTitulo = "";
        String[] titulo = displayModel.getTitulo();
        for (int i = 0; i < titulo.length; ++i) {
            textoTitulo = textoTitulo + titulo[i];
            if (i == titulo.length - 1) continue;
            textoTitulo = textoTitulo + ";";
        }
        byte[] comando = new byte[tamHeard + (textoTitulo == null ? 0 : textoTitulo.length())];
        byte[] tamComando = ByteUtil.shortToByteArray(comando.length - 2);
        comando[0] = tamComando[0];
        comando[1] = tamComando[1];
        comando[2] = versao;
        comando[3] = tipoMsg;
        comando[4] = tipoComando;
        comando[5] = tipoDisplay;
        if (textoTitulo != null) {
            byte[] arrayMsg = textoTitulo.getBytes();
            int x = 0;
            int i = tamHeard;
            while (i < comando.length) {
                comando[i] = arrayMsg[x];
                ++i;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        while (!comandoOK && retray < 3) {
            byte[] resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 2) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
    }

    public EventoTeclado exibeMenu(LayoutMenu displayModel) throws ExcecaoNaoLocal {
        Object idxSelecionado;
        this.limpaDisplay();
        this.exibeTextoMenu(displayModel);
        logger.debug((Object)"executa comando exibeMenu");
        int tamHeard = 5;
        byte versao = 1;
        int tipoMsg = 2;
        int tipoComando = 5;
        String opcoesMenu = "";
        ArrayList<String> indices = new ArrayList<String>();
        List itens = displayModel.getItens();
        for (int i = 0; i < itens.size(); ++i) {
            ItemMenu item = (ItemMenu)itens.get(i);
            indices.add(item.getTeclaFinalizadora());
            opcoesMenu = opcoesMenu + item.getTeclaFinalizadora() + ":" + item.getTexto();
            if (i == itens.size() - 1) continue;
            opcoesMenu = opcoesMenu + ";";
        }
        byte[] comando = new byte[tamHeard + (opcoesMenu == null ? 0 : opcoesMenu.length())];
        byte[] tamComando = ByteUtil.shortToByteArray(comando.length - 2);
        comando[0] = tamComando[0];
        comando[1] = tamComando[1];
        comando[2] = versao;
        comando[3] = tipoMsg;
        comando[4] = tipoComando;
        if (opcoesMenu != null) {
            byte[] arrayMsg = opcoesMenu.getBytes();
            int x = 0;
            int i = tamHeard;
            while (i < comando.length) {
                comando[i] = arrayMsg[x];
                ++i;
                ++x;
            }
        }
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta[2] == 8 && resposta.length != 3 && resposta[2] == 5 && resposta.length != 4) {
                ++retray;
                continue;
            }
            if (resposta[2] != 5 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            if (resposta[2] == 5 && !indices.contains(idxSelecionado = (Object)new String(ByteUtil.copyOfRange(resposta, 3, resposta.length)))) continue;
            comandoOK = true;
        }
        if (comandoOK) {
            if (resposta[2] == 8) {
                EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                return evTeclado;
            }
            idxSelecionado = ByteUtil.copyOfRange(resposta, 3, resposta.length);
            String stringLida = new String((byte[])idxSelecionado);
            EventoTeclado evTeclado = new EventoTeclado(stringLida, stringLida.trim(), stringLida.length());
            return evTeclado;
        }
        throw new ExcecaoNaoLocal(null, "");
    }

    public EventoDispositivoEntrada confirmaDado(LayoutDisplay displayModel) throws ExcecaoNaoLocal {
        this.exibeDisplay(displayModel);
        logger.debug((Object)"executa comando confirmaDado");
        byte versao = 1;
        byte tipoMsg = 2;
        byte tipoComando = 6;
        byte[] comando = new byte[]{0, 3, versao, tipoMsg, tipoComando};
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta.length != 3) {
                ++retray;
                continue;
            }
            if (resposta[2] != 6 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
        if (comandoOK) {
            if (resposta[2] == 8) {
                EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                return evTeclado;
            }
            EventoTeclado evTeclado = new EventoTeclado("", "ENTRA", 0);
            return evTeclado;
        }
        throw new ExcecaoNaoLocal(null, "");
    }

    public EventoDispositivoEntrada capturaDado(LayoutDisplay displayModel, ConstantesApiAc.TipoCampo tipoCampo, boolean aceitaZerosEsquerda, long[] perifericos, EntradaDeDados entradaDeDados) throws ExcecaoNaoLocal {
        boolean capturaCartaoPinpad;
        if (displayModel != null) {
            this.exibeDisplay(displayModel);
        }
        logger.debug((Object)"executa comando capturaDado");
        boolean ouvindoPinpad = false;
        long aux = 0L;
        for (int i = 0; i < perifericos.length; ++i) {
            if (perifericos[i] == 1L || perifericos[i] == 2L || perifericos[i] == 8L || perifericos[i] == 16L || perifericos[i] != 4L) {
                // empty if block
            }
            aux |= perifericos[i];
            if (perifericos[i] != 8L) continue;
            ouvindoPinpad = true;
        }
        if (tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS_CONVENIO_BL1) || tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS_TITULO_BL1)) {
            tipoCampo = ConstantesApiAc.CAP_CODIGO_BARRAS;
        }
        boolean bl = capturaCartaoPinpad = tipoCampo.equals(ConstantesApiAc.CAP_CARTAO_DIGITADO) && entradaDeDados.getLeitorCartao() != null && ouvindoPinpad;
        if (capturaCartaoPinpad || tipoCampo.equals(ConstantesApiAc.CAP_LEITURA_PIN)) {
            VerificaAbort verificaAbort = new VerificaAbort(this, entradaDeDados);
            verificaAbort.start();
            EventoDispositivoEntrada ev = entradaDeDados.leValor(aux);
            if (ev != null) {
                verificaAbort.cancelaVerificacao();
                while (verificaAbort.isAlive()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {}
                }
            }
            return ev;
        }
        int tamHeard = 12;
        byte versao = 1;
        int tipoMsg = 2;
        int tipoComando = 7;
        byte[] comando = new byte[tamHeard];
        byte[] tamComando = ByteUtil.shortToByteArray(comando.length - 2);
        byte[] campo = tipoCampo.getCodigo().getBytes();
        byte[] maxDigitos = ByteUtil.shortToByteArray(tipoCampo.getMascaraEdicao().length());
        comando[0] = tamComando[0];
        comando[1] = tamComando[1];
        comando[2] = versao;
        comando[3] = tipoMsg;
        comando[4] = tipoComando;
        comando[5] = campo[0];
        comando[6] = campo[1];
        comando[7] = campo[2];
        comando[8] = campo[3];
        comando[9] = maxDigitos[0];
        comando[10] = maxDigitos[1];
        comando[11] = aceitaZerosEsquerda ? 1 : 2;
        int retray = 0;
        boolean comandoOK = false;
        byte[] resposta = new byte[3];
        while (!comandoOK && retray < 3) {
            resposta = this.executaComando(comando);
            if (resposta[2] == 8 && resposta.length != 3 && resposta[2] == 7) {
                ++retray;
                continue;
            }
            if (resposta[2] != 7 && resposta[2] != 8) {
                ++retray;
                continue;
            }
            comandoOK = true;
        }
        if (comandoOK) {
            if (resposta[2] == 8) {
                EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                return evTeclado;
            }
            byte[] valor = ByteUtil.copyOfRange(resposta, 3, resposta.length);
            String stringLida = new String(valor);
            if (tipoCampo.equals(ConstantesApiAc.CAP_CMC7)) {
                String cmc7 = stringLida.substring(1);
                if (stringLida.subSequence(0, 1).equals("1")) {
                    EventoLeitorDocumento evLeitorDocumento = new EventoLeitorDocumento(cmc7, 0, false, false, "");
                    return evLeitorDocumento;
                }
                EventoTeclado evTeclado = new EventoTeclado(cmc7, "", cmc7.length());
                return evTeclado;
            }
            if (tipoCampo.equals(ConstantesApiAc.CAP_CODIGO_BARRAS)) {
                String documento = stringLida.substring(1);
                if (stringLida.subSequence(0, 1).equals("1")) {
                    EventoLeitorDocumento evLeitorDocumento = new EventoLeitorDocumento(documento, 1, false, false, "");
                    return evLeitorDocumento;
                }
                EventoTeclado evTeclado = new EventoTeclado(documento, "", documento.length());
                return evTeclado;
            }
            EventoTeclado evTeclado = new EventoTeclado(stringLida, "ENTRA", stringLida.length());
            return evTeclado;
        }
        throw new ExcecaoNaoLocal(null, "");
    }

    protected final synchronized byte[] executaComando(byte[] comando) {
        try {
            this.os.write(comando);
            this.os.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] tamResp = new byte[2];
        while (this.started) {
            try {
                this.is.read(tamResp, 0, tamResp.length);
                short tam = ByteUtil.byteArrayToShort(tamResp);
                if (tam > 0) {
                    byte[] resp = new byte[tam];
                    this.is.read(resp, 0, resp.length);
                    return resp;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                this.started = false;
            }
        }
        return tamResp;
    }

    public static void main(String[] args) {
        byte[] b = ByteUtil.intToByteArray(7002);
        int i = ByteUtil.byteArrayToInt(b);
        System.out.println(i);
        System.out.println(ByteUtil.byteArrayToShort(new byte[]{0, 3}));
    }

    static interface ComunicacaoHandler {
        public void send(byte[] var1);

        public void read(byte[] var1);
    }

    class VerificaAbort
    extends Thread {
        private EntradaDeDados entradaDeDados;
        private ControladorTranslator controlador;
        private boolean abort = false;

        public VerificaAbort(ControladorTranslator controlador, EntradaDeDados entradaDeDados) {
            this.entradaDeDados = entradaDeDados;
            this.controlador = controlador;
        }

        public boolean isAbort() {
            return this.abort;
        }

        public void cancelaVerificacao() {
            this.abort = true;
        }

        public void run() {
            byte versao = 1;
            byte tipoMsg = 2;
            byte tipoComando = 8;
            byte[] comando = new byte[]{0, 3, versao, tipoMsg, tipoComando};
            while (!this.abort) {
                int retray = 0;
                boolean comandoOK = false;
                byte[] resposta = new byte[3];
                while (!comandoOK && retray < 3) {
                    resposta = this.controlador.executaComando(comando);
                    if (resposta.length != 3) {
                        ++retray;
                        continue;
                    }
                    if (resposta[2] != 0 && resposta[2] != 8) {
                        ++retray;
                        continue;
                    }
                    comandoOK = true;
                }
                if (comandoOK && resposta[2] == 8) {
                    this.abort = true;
                    EventoTeclado evTeclado = new EventoTeclado("", "VOLTA", 0);
                    this.entradaDeDados.eventoOcorrido(evTeclado);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

