/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.excecoes.ExcecaoValorInvalido;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoGenericoEntradaDados;
import com.csi.ctfclient.tools.devices.EventoLeitorCartao;
import com.csi.ctfclient.tools.devices.EventoLeitorDocumento;
import com.csi.ctfclient.tools.devices.EventoPin;
import com.csi.ctfclient.tools.devices.EventoScanner;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorDocumento;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.Pin;
import com.csi.ctfclient.tools.devices.Scanner;
import com.csi.ctfclient.tools.devices.Teclado;
import com.csi.ctfclient.tools.devices.constants.TiposPerifericos;
import com.csi.ctfclient.tools.devices.postef.EventoPOSTef;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.Vector;

public class EntradaDeDados
implements TiposPerifericos,
PerifericoEntradaDadosListener {
    private Pin pin;
    private boolean pinHabilitado;
    private Teclado teclado;
    private boolean tecladoHabilitado;
    private Scanner scanner;
    private boolean scannerHabilitado;
    private ILeitorCartaoHandler leitorCartao;
    private boolean leitorCartaoHabilitado;
    private FilaEntradaDeDados filaEventos = new FilaEntradaDeDados();
    private ConjuntoListener ouvintesTeclado = new ConjuntoListener();
    private ConjuntoListener ouvintesScanner = new ConjuntoListener();
    private ConjuntoListener ouvintesLeitorCartao = new ConjuntoListener();
    private ConjuntoListener ouvintesPin = new ConjuntoListener();
    private ConjuntoListener ouvintesBalanca = new ConjuntoListener();
    private LeitorDocumento leitorDocumento;
    private boolean leitorDocumentoHabilitado;
    private ConjuntoListener ouvintesLeitorDocumento = new ConjuntoListener();
    private boolean balancaSincrona;
    private EventoDispositivoEntrada evtLeValor;
    private boolean leitorCartaoSincrono;
    private boolean leitorDocumentoSincrono;
    private ConjuntoListener ouvintesGenerico = new ConjuntoListener();
    private boolean pinSincrono;
    private boolean scannerSincrono;
    private boolean tecladoSincrono;
    private ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();

    public EntradaDeDados() {
        this(null, null, null, null);
    }

    public EntradaDeDados(Teclado teclado) {
        this(teclado, null, null, null);
    }

    public EntradaDeDados(Teclado teclado, Scanner scanner, ILeitorCartaoHandler leitor, Pin pin) {
        this.setTeclado(teclado);
        this.setScanner(scanner);
        this.setLeitorCartao(leitor);
        this.setPin(pin);
    }

    public void desabilitaLeitorCartao() throws ExcecaoPerifericos {
        this.leitorCartaoHabilitado = false;
        this.limpaFilaEventosLeitorCartao();
    }

    public void desabilitaPin() throws ExcecaoPerifericos {
        this.pinHabilitado = false;
        this.limpaFilaEventosPin();
    }

    public void desabilitaScanner() throws ExcecaoPerifericos {
        this.scannerHabilitado = false;
        this.limpaFilaEventosScanner();
    }

    public void desabilitaTeclado() throws ExcecaoPerifericos {
        this.tecladoHabilitado = false;
        this.limpaFilaEventosTeclado();
    }

    public synchronized ILeitorCartaoHandler getLeitorCartao() {
        return this.leitorCartao;
    }

    public synchronized Pin getPin() {
        return this.pin;
    }

    public synchronized Scanner getScanner() {
        return this.scanner;
    }

    public synchronized Teclado getTeclado() {
        return this.teclado;
    }

    public void habilitaLeitorCartao() throws ExcecaoPerifericos {
        this.leitorCartaoHabilitado = true;
        this.limpaFilaEventosLeitorCartao();
    }

    public void habilitaPin() throws ExcecaoPerifericos {
        this.pinHabilitado = true;
        this.limpaFilaEventosPin();
    }

    public void habilitaScanner() throws ExcecaoPerifericos {
        this.scannerHabilitado = true;
        this.limpaFilaEventosScanner();
    }

    public void habilitaTeclado() throws ExcecaoPerifericos {
        this.tecladoHabilitado = true;
        this.limpaFilaEventosTeclado();
    }

    public synchronized EventoDispositivoEntrada leValor(long[] perifericos) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (int i = 0; i < perifericos.length; ++i) {
            if (perifericos[i] != 1L && perifericos[i] != 2L && perifericos[i] != 8L && perifericos[i] != 16L && perifericos[i] != 4L) {
                throw new ExcecaoValorInvalido();
            }
            aux |= perifericos[i];
        }
        return this.leValor(aux);
    }

    public synchronized EventoDispositivoEntrada leValor(long perifericos) {
        boolean isLeitorDocumento;
        boolean isPin;
        boolean isLeitorCartao;
        boolean isScanner;
        boolean isTeclado = (perifericos & 1L) != 0L;
        EventoDispositivoEntrada evt = this.filaEventos.proximoEvento(isTeclado, isScanner = (perifericos & 2L) != 0L, isLeitorCartao = (perifericos & 8L) != 0L, isPin = (perifericos & 4L) != 0L, isLeitorDocumento = (perifericos & 0x10L) != 0L, false);
        if (evt == null) {
            evt = this.leValorDireto(perifericos, true);
        }
        if (this.tecladoHabilitado) {
            this.teclado.getParametros().setEmEdicao(false);
        }
        return evt;
    }

    public synchronized void limpaFilaEventosLeitorCartao() {
        this.filaEventos.limpaEventosLeitorCartao();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosPin() {
        this.filaEventos.limpaEventosPin();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosScanner() {
        this.filaEventos.limpaEventosScanner();
        this.notifyAll();
    }

    public synchronized void limpaFilaEventosTeclado() {
        this.filaEventos.limpaEventosTeclado();
        this.notifyAll();
    }

    public synchronized void setLeitorCartao(ILeitorCartaoHandler leitorCartao) {
        if (this.leitorCartao != null) {
            this.leitorCartao.removeListener(this);
        }
        this.leitorCartao = leitorCartao;
        this.leitorCartaoHabilitado = false;
        if (leitorCartao != null) {
            leitorCartao.addListener(this, false);
        }
        this.limpaFilaEventosLeitorCartao();
    }

    public synchronized void setPin(Pin pin) {
        if (this.pin != null) {
            this.pin.removeListener(this);
        }
        this.pin = pin;
        this.pinHabilitado = false;
        if (pin != null) {
            pin.addListener(this, false);
        }
        this.limpaFilaEventosPin();
    }

    public synchronized void setScanner(Scanner scanner) {
        if (this.scanner != null) {
            this.scanner.removeListener(this);
        }
        this.scanner = scanner;
        this.scannerHabilitado = false;
        if (scanner != null) {
            scanner.addListener(this, false);
        }
        this.limpaFilaEventosScanner();
    }

    public synchronized void setTeclado(Teclado teclado) {
        if (this.teclado != null) {
            this.teclado.removeListener(this);
        }
        this.teclado = teclado;
        this.tecladoHabilitado = false;
        if (teclado != null) {
            teclado.addListener(this, false);
        }
        this.limpaFilaEventosTeclado();
    }

    public void desabilitaLeitorDocumento() throws ExcecaoPerifericos {
        this.leitorDocumentoHabilitado = false;
        this.limpaFilaEventosLeitorDocumento();
    }

    public void habilitaLeitorDocumento() throws ExcecaoPerifericos {
        this.leitorDocumentoHabilitado = true;
        this.limpaFilaEventosLeitorDocumento();
    }

    public synchronized void limpaFilaEventosLeitorDocumento() {
        this.filaEventos.limpaEventosLeitorDocumento();
        this.notifyAll();
    }

    public synchronized void setLeitorDocumento(LeitorDocumento leitorDocumento) {
        if (this.leitorDocumento != null) {
            this.leitorDocumento.removeListener(this);
        }
        this.leitorDocumento = leitorDocumento;
        this.leitorDocumentoHabilitado = false;
        if (leitorDocumento != null) {
            leitorDocumento.addListener(this, false);
        }
        this.limpaFilaEventosLeitorDocumento();
    }

    public synchronized void limpaTodasFilasEventos() {
        this.filaEventos.limpaEventosLeitorCartao();
        this.filaEventos.limpaEventosLeitorDocumento();
        this.filaEventos.limpaEventosPin();
        this.filaEventos.limpaEventosScanner();
        this.filaEventos.limpaEventosTeclado();
        this.notifyAll();
    }

    public void addBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesBalanca.inclui(ouvinte);
    }

    public void addLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesLeitorCartao.inclui(ouvinte);
    }

    public void addLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesLeitorDocumento.inclui(ouvinte);
    }

    public void addPinListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesPin.inclui(ouvinte);
    }

    public void addScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesScanner.inclui(ouvinte);
    }

    public void addTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesTeclado.inclui(ouvinte);
    }

    public synchronized void eventoOcorrido(EventoDispositivoEntrada evt) {
        if (evt instanceof EventoScanner) {
            if (this.scannerSincrono) {
                this.evtLeValor = evt;
                this.notifyAll();
                return;
            }
            if (this.scannerHabilitado && this.ouvintesScanner.tamanho() > 0) {
                this.filaEventos.inclui(evt);
                this.threadEventos.prossegue();
            }
        } else if (evt instanceof EventoTeclado) {
            if (this.tecladoSincrono) {
                this.evtLeValor = evt;
                this.notifyAll();
                return;
            }
            if (this.tecladoHabilitado && this.ouvintesTeclado.tamanho() > 0) {
                this.filaEventos.inclui(evt);
                this.threadEventos.prossegue();
            }
        } else if (evt instanceof EventoLeitorCartao) {
            if (this.leitorCartaoSincrono) {
                this.evtLeValor = evt;
                this.notifyAll();
                return;
            }
            if (this.leitorCartaoHabilitado && this.ouvintesLeitorCartao.tamanho() > 0) {
                this.filaEventos.inclui(evt);
                this.threadEventos.prossegue();
            }
        } else if (evt instanceof EventoPin) {
            if (this.pinSincrono) {
                this.evtLeValor = evt;
                this.notifyAll();
                return;
            }
            if (this.pinHabilitado && this.ouvintesPin.tamanho() > 0) {
                this.filaEventos.inclui(evt);
                this.threadEventos.prossegue();
            }
        } else if (evt instanceof EventoLeitorDocumento) {
            if (this.leitorDocumentoSincrono) {
                this.evtLeValor = evt;
                this.notifyAll();
                return;
            }
            if (this.leitorDocumentoHabilitado && this.ouvintesLeitorDocumento.tamanho() > 0) {
                this.filaEventos.inclui(evt);
                this.threadEventos.prossegue();
            }
        } else if (evt instanceof EventoPOSTef) {
            this.evtLeValor = evt;
            this.notifyAll();
            return;
        }
    }

    public void removeBalancaListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesBalanca.deleta(ouvinte);
    }

    public void removeLeitorCartaoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesLeitorCartao.deleta(ouvinte);
    }

    public void removeLeitorDocumentoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesLeitorDocumento.deleta(ouvinte);
    }

    public void removePinListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesPin.deleta(ouvinte);
    }

    public void removeScannerListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesScanner.deleta(ouvinte);
    }

    public void removeTecladoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesTeclado.deleta(ouvinte);
    }

    public void addEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesGenerico.inclui(ouvinte);
    }

    public synchronized LeitorDocumento getLeitorDocumento() {
        return this.leitorDocumento;
    }

    public int getNumEventosLeitorCartao() {
        return this.filaEventos.getNumEventosLeitorCartao();
    }

    public int getNumEventosLeitorDocumento() {
        return this.filaEventos.getNumEventosLeitorDocumento();
    }

    public int getNumEventosPin() {
        return this.filaEventos.getNumEventosPin();
    }

    public int getNumEventosScanner() {
        return this.filaEventos.getNumEventosScanner();
    }

    public int getNumEventosTeclado() {
        return this.filaEventos.getNumEventosTeclado();
    }

    public void insereEventoComoGenerico(EventoDispositivoEntrada ev, String id) {
        EventoGenericoEntradaDados evt = new EventoGenericoEntradaDados(this, id, ev);
        evt.modificaInstanteCriacao(ev.getInstanteCriacao());
        this.filaEventos.inclui(evt);
        this.threadEventos.prossegue();
    }

    public boolean isListenerBalanca(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesBalanca.contem(ouvinte);
    }

    public boolean isListenerLeitorCartao(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorCartao.contem(ouvinte);
    }

    public boolean isListenerLeitorDocumento(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesLeitorDocumento.contem(ouvinte);
    }

    public boolean isListenerPin(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesPin.contem(ouvinte);
    }

    public boolean isListenerScanner(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesScanner.contem(ouvinte);
    }

    public boolean isListenerTeclado(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesTeclado.contem(ouvinte);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long[] perifericos) throws ExcecaoPerifericos, ExcecaoValorInvalido {
        long aux = 0L;
        for (int i = 0; i < perifericos.length; ++i) {
            if (perifericos[i] != 1L && perifericos[i] != 2L && perifericos[i] != 8L && perifericos[i] != 16L && perifericos[i] != 4L) {
                throw new ExcecaoValorInvalido();
            }
            aux |= perifericos[i];
        }
        return this.leValorDireto(aux);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long[] perifericos, boolean paralisaFila) throws ExcecaoValorInvalido {
        long aux = 0L;
        for (int i = 0; i < perifericos.length; ++i) {
            if (perifericos[i] != 1L && perifericos[i] != 2L && perifericos[i] != 8L && perifericos[i] != 16L && perifericos[i] != 4L) {
                throw new ExcecaoValorInvalido();
            }
            aux |= perifericos[i];
        }
        return this.leValorDireto(aux, paralisaFila);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long perifericos) {
        return this.leValorDireto(perifericos, true);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(long perifericos, boolean paralisaFila) {
        this.tecladoSincrono = (perifericos & 1L) != 0L;
        this.scannerSincrono = (perifericos & 2L) != 0L;
        this.leitorCartaoSincrono = (perifericos & 8L) != 0L;
        this.pinSincrono = (perifericos & 4L) != 0L;
        boolean bl = this.leitorDocumentoSincrono = (perifericos & 0x10L) != 0L;
        if (!(this.tecladoSincrono || this.scannerSincrono || this.leitorCartaoSincrono || this.pinSincrono || this.balancaSincrona || this.leitorDocumentoSincrono)) {
            return null;
        }
        if (paralisaFila) {
            this.threadEventos.pausa();
        }
        EventoDispositivoEntrada retorno = this.evtLeValor;
        while (retorno == null) {
            try {
                this.wait();
            }
            catch (Exception e) {
                // empty catch block
            }
            retorno = this.evtLeValor;
        }
        this.evtLeValor = null;
        this.tecladoSincrono = false;
        this.scannerSincrono = false;
        this.leitorCartaoSincrono = false;
        this.pinSincrono = false;
        this.balancaSincrona = false;
        this.leitorDocumentoSincrono = false;
        if (paralisaFila) {
            this.threadEventos.prossegue();
        }
        return retorno;
    }

    public synchronized void limpaFilaEventosGenericos() {
        this.filaEventos.limpaEventosGenericos();
        this.notifyAll();
    }

    public void removeEventoGenericoListener(PerifericoEntradaDadosListener ouvinte) {
        this.ouvintesGenerico.deleta(ouvinte);
    }

    public class FilaEntradaDeDados {
        private SortedSet elementos = Collections.synchronizedSortedSet(new TreeSet());

        public synchronized int getNumEventosLeitorCartao() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoLeitorCartao)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosPin() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoPin)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosScanner() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoScanner)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized int getNumEventosTeclado() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoTeclado)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized void inclui(EventoDispositivoEntrada elemento) {
            this.elementos.add(elemento);
        }

        public synchronized void limpaEventosGenericos() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoGenericoEntradaDados)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosLeitorCartao() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoLeitorCartao)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosPin() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoPin)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosScanner() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoScanner)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized void limpaEventosTeclado() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoTeclado)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized EventoDispositivoEntrada proximoEvento() {
            if (this.vazia()) {
                return null;
            }
            EventoDispositivoEntrada result = (EventoDispositivoEntrada)this.elementos.first();
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }

        public synchronized void removeEvento(EventoDispositivoEntrada ev) {
            try {
                this.elementos.remove(ev);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean vazia() {
            return this.elementos.size() == 0;
        }

        public synchronized int getNumEventosLeitorDocumento() {
            int retorno = 0;
            for (EventoDispositivoEntrada aux : this.elementos) {
                if (!(aux instanceof EventoLeitorDocumento)) continue;
                ++retorno;
            }
            return retorno;
        }

        public synchronized void limpaEventosLeitorDocumento() {
            Iterator set = this.elementos.iterator();
            Vector<EventoDispositivoEntrada> v = new Vector<EventoDispositivoEntrada>();
            while (set.hasNext()) {
                EventoDispositivoEntrada evt = (EventoDispositivoEntrada)set.next();
                if (!(evt instanceof EventoLeitorDocumento)) continue;
                v.add(evt);
            }
            this.elementos.removeAll(v);
        }

        public synchronized EventoDispositivoEntrada proximoEvento(boolean teclado, boolean scanner, boolean leitorCartao, boolean pin, boolean leitorDocumento, boolean generico) {
            EventoDispositivoEntrada result = null;
            Iterator set = this.elementos.iterator();
            while (set.hasNext() && result == null) {
                EventoDispositivoEntrada aux = (EventoDispositivoEntrada)set.next();
                if (teclado && aux instanceof EventoTeclado) {
                    result = aux;
                    break;
                }
                if (scanner && aux instanceof EventoScanner) {
                    result = aux;
                    break;
                }
                if (leitorCartao && aux instanceof EventoLeitorCartao) {
                    result = aux;
                    break;
                }
                if (pin && aux instanceof EventoPin) {
                    result = aux;
                    break;
                }
                if (leitorDocumento && aux instanceof EventoLeitorDocumento) {
                    result = aux;
                    break;
                }
                if (!generico || !(aux instanceof EventoGenericoEntradaDados)) continue;
                result = aux;
                break;
            }
            if (result != null) {
                this.removeEvento(result);
            }
            return result;
        }
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            this.start();
        }

        public synchronized void finaliza() {
            this.finalizada = true;
            this.notifyAll();
        }

        public void pausa() {
            this.pausada = true;
        }

        private void distribuiEventoOuvintes(EventoDispositivoEntrada evt) {
            ConjuntoListener c = null;
            if (evt instanceof EventoScanner) {
                c = EntradaDeDados.this.ouvintesScanner;
            } else if (evt instanceof EventoTeclado) {
                c = EntradaDeDados.this.ouvintesTeclado;
            } else if (evt instanceof EventoLeitorCartao) {
                c = EntradaDeDados.this.ouvintesLeitorCartao;
            } else if (evt instanceof EventoPin) {
                c = EntradaDeDados.this.ouvintesPin;
            } else if (evt instanceof EventoLeitorDocumento) {
                c = EntradaDeDados.this.ouvintesLeitorDocumento;
            } else if (evt instanceof EventoGenericoEntradaDados) {
                c = EntradaDeDados.this.ouvintesGenerico;
            }
            if (c != null && c.tamanho() > 0) {
                Enumeration e = c.elementos();
                while (e.hasMoreElements()) {
                    ((PerifericoEntradaDadosListener)e.nextElement()).eventoOcorrido(evt);
                }
            }
        }

        public synchronized void prossegue() {
            this.pausada = false;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.finalizada) {
                EventoDispositivoEntrada evt;
                do {
                    if ((evt = EntradaDeDados.this.filaEventos.proximoEvento()) == null) continue;
                    this.distribuiEventoOuvintes(evt);
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pausada = false;
            }
        }
    }

    public class ConjuntoListener {
        private Vector elementos = new Vector();

        public Enumeration elementos() {
            return this.elementos.elements();
        }

        public boolean contem(Object o) {
            return this.elementos.contains(o);
        }

        public int tamanho() {
            return this.elementos.size();
        }

        public boolean consulta(PerifericoEntradaDadosListener elemento) {
            return this.elementos.contains(elemento);
        }

        public void deleta(PerifericoEntradaDadosListener elemento) {
            this.elementos.removeElement(elemento);
        }

        public void inclui(PerifericoEntradaDadosListener elemento) {
            if (!this.elementos.contains(elemento)) {
                this.elementos.addElement(elemento);
            }
        }
    }
}

