/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.ILeitorCartaoHandler;
import com.csi.ctfclient.tools.devices.LeitorCartao;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emvfull.LeitorCartaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;

public class LeitorCartaoHandler
extends Periferico
implements ILeitorCartaoHandler {
    private String serial = null;
    private String msgCartao;
    private String msgPrompt;
    private ProtocoloBibliotecaCompartilhada protocolo = null;
    private LeitorCartaoBibliotecaCompartilhada leitorCartao = null;
    private int redeAdquirente = 0;
    private Integer indiceAID = null;

    public LeitorCartaoHandler(String serial, String msgCartao, String msgOcioso) throws ExcecaoPerifericos {
        LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV;
        this.serial = serial;
        this.msgCartao = msgCartao;
        this.msgPrompt = msgOcioso;
        this.protocolo = ProtocoloBibliotecaCompartilhada.getInstancia(serial);
        this.leitorCartao = leitorCartaoEMV = new LeitorCartaoBibliotecaCompartilhada(this.protocolo);
        this.leitorCartao.setIdRedeAdquirente(this.redeAdquirente);
        this.leitorCartao.setIndiceAID(this.indiceAID);
    }

    public LeitorCartao getLeitorCartao() {
        return this.leitorCartao;
    }

    public int getRedeAdquirente() {
        return this.redeAdquirente;
    }

    public void setRedeAdquirente(int redeAdquirente) {
        if (this.isBibliotecaCompartilhada()) {
            this.redeAdquirente = redeAdquirente;
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setIdRedeAdquirente(redeAdquirente);
        }
    }

    public boolean isHabilitado() {
        return this.getHabilitado();
    }

    public void habilita() throws ExcecaoPerifericos {
        this.leitorCartao.habilita();
        this.setHabilitado(true);
    }

    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido, ExcecaoPerifericos {
        this.leitorCartao.habilitaTrilha(numTrilha);
    }

    public int getSolicitaCargaTabelas() {
        if (this.isBibliotecaCompartilhada()) {
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            return leitorCartaoEMV.getSolicitaCargaTabelas();
        }
        return LeitorCartaoEMV.CARGA_TABELA_OK;
    }

    public void setSolicitaCargaTabelas(int atualizandoTabelas) {
        if (this.isBibliotecaCompartilhada()) {
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setSolicitaCargaTabelas(atualizandoTabelas);
        }
    }

    public void desabilita() throws ExcecaoPerifericos {
        this.leitorCartao.desabilita();
        this.setHabilitado(false);
    }

    public void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        this.leitorCartao.addListener(ouvinte, utilizarBuffer);
    }

    public void liberaRecursos() throws ExcecaoPerifericos {
        this.leitorCartao.liberaRecursos();
    }

    public void removeListener(PerifericoEntradaDadosListener ouvinte) {
        this.leitorCartao.removeListener(ouvinte);
    }

    public long getTipoPeriferico() {
        return this.leitorCartao.getTipoPeriferico();
    }

    public boolean isBibliotecaCompartilhada() {
        return ProtocoloBibliotecaCompartilhada.isBibliotecaEMV();
    }

    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        return this.leitorCartao.iniciaCargaTabelas(timeStamp);
    }

    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        return this.leitorCartao.executaCargaTabelas(tabela);
    }

    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        return this.leitorCartao.finalizaCargaTabelas();
    }

    public void setIndiceAID(Integer indiceAID) {
        if (this.isBibliotecaCompartilhada()) {
            this.indiceAID = indiceAID;
            LeitorCartaoBibliotecaCompartilhada leitorCartaoEMV = this.leitorCartao;
            leitorCartaoEMV.setIndiceAID(indiceAID);
        }
    }

    public Integer getIndiceAID() {
        return this.indiceAID;
    }
}

