/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices;

import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.PerifericoEntradaDadosListener;
import java.util.Vector;

public abstract class PerifericoEntradaDados
extends Periferico {
    FilaEventos filaEventos = new FilaEventos();
    private Vector ouvintesBuf = new Vector();
    private Vector ouvintesNaoBuf = new Vector();
    ThreadDisparaEventos threadEventos = new ThreadDisparaEventos();
    boolean emLeituraSincrona = false;
    EventoDispositivoEntrada evtLeValor = null;
    String subClasse = this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte) {
        this.addListener(ouvinte, true);
    }

    public synchronized void addListener(PerifericoEntradaDadosListener ouvinte, boolean utilizarBuffer) {
        if (utilizarBuffer) {
            this.ouvintesBuf.add(ouvinte);
        } else {
            this.ouvintesNaoBuf.add(ouvinte);
        }
    }

    protected synchronized void eventoOcorrido(EventoDispositivoEntrada evt) {
        if (this.emLeituraSincrona) {
            this.evtLeValor = evt;
            this.notifyAll();
            return;
        }
        if (this.ouvintesBuf.size() > 0) {
            this.filaEventos.inserirEvento(evt);
            this.threadEventos.prossegue();
        }
        if (this.ouvintesNaoBuf.size() > 0) {
            for (int i = 0; i < this.ouvintesNaoBuf.size(); ++i) {
                PerifericoEntradaDadosListener o = (PerifericoEntradaDadosListener)this.ouvintesNaoBuf.get(i);
                o.eventoOcorrido(evt);
            }
        }
    }

    public synchronized EventoDispositivoEntrada leValor() throws ExcecaoPerifericos {
        EventoDispositivoEntrada evt = this.filaEventos.obterProximoEvento();
        if (evt == null) {
            evt = this.leValorDireto(true);
        }
        return evt;
    }

    public synchronized void limpaFilaEventos() {
        this.filaEventos.limparEventos();
    }

    public synchronized int quantidadeEventosFila() {
        return this.filaEventos.tamanho();
    }

    public synchronized void desabilita() throws ExcecaoPerifericos {
        this.limpaFilaEventos();
    }

    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        this.desabilita();
        this.threadEventos.finaliza();
    }

    public synchronized void removeListener(PerifericoEntradaDadosListener ouvinte) {
        if (this.ouvintesBuf.remove(ouvinte) && this.ouvintesBuf.size() == 0) {
            this.ouvintesBuf.clear();
        }
        this.ouvintesNaoBuf.remove(ouvinte);
    }

    public synchronized EventoDispositivoEntrada leValorDireto() throws ExcecaoPerifericos {
        return this.leValorDireto(true);
    }

    public synchronized EventoDispositivoEntrada leValorDireto(boolean paralisaFila) throws ExcecaoPerifericos {
        if (!this.getHabilitado()) {
            throw new ExcecaoPerifericos(this, "PER72");
        }
        this.emLeituraSincrona = true;
        if (paralisaFila) {
            this.threadEventos.pausa();
        }
        EventoDispositivoEntrada retorno = this.evtLeValor;
        while (retorno == null) {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
            retorno = this.evtLeValor;
        }
        if (paralisaFila) {
            this.threadEventos.prossegue();
        }
        this.emLeituraSincrona = false;
        this.evtLeValor = null;
        return retorno;
    }

    public synchronized boolean isListener(PerifericoEntradaDadosListener ouvinte) {
        return this.ouvintesBuf.contains(ouvinte) || this.ouvintesNaoBuf.contains(ouvinte);
    }

    private class ThreadDisparaEventos
    extends Thread {
        private boolean finalizada = false;
        private boolean pausada = false;

        public ThreadDisparaEventos() {
            this.setName("Periferico");
            this.start();
        }

        public synchronized void finaliza() {
            this.finalizada = true;
            this.notifyAll();
        }

        public void pausa() {
            this.pausada = true;
        }

        public synchronized void prossegue() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.finalizada) {
                EventoDispositivoEntrada evt = null;
                do {
                    if ((evt = PerifericoEntradaDados.this.filaEventos.obterProximoEvento()) == null || PerifericoEntradaDados.this.ouvintesBuf.size() <= 0) continue;
                    for (int i = 0; i < PerifericoEntradaDados.this.ouvintesBuf.size(); ++i) {
                        PerifericoEntradaDadosListener o = (PerifericoEntradaDadosListener)PerifericoEntradaDados.this.ouvintesBuf.get(i);
                        o.eventoOcorrido(evt);
                    }
                } while (!this.finalizada && !this.pausada && evt != null);
                if (this.finalizada) continue;
                ThreadDisparaEventos threadDisparaEventos = this;
                synchronized (threadDisparaEventos) {
                    try {
                        this.wait();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.pausada = false;
            }
        }
    }

    private class FilaEventos {
        private Vector fila = new Vector();

        private FilaEventos() {
        }

        public void inserirEvento(EventoDispositivoEntrada evt) {
            this.fila.add(evt);
        }

        public void limparEventos() {
            this.fila.clear();
        }

        public EventoDispositivoEntrada obterProximoEvento() {
            if (this.fila.isEmpty()) {
                return null;
            }
            return (EventoDispositivoEntrada)this.fila.remove(0);
        }

        public int tamanho() {
            return this.fila.size();
        }
    }
}

