/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.config;

import com.csi.ctfclient.info.tiposgerais.ChaveInteira;
import com.csi.ctfclient.tools.devices.config.ConfiguracaoTeclado;
import com.csi.ctfclient.tools.devices.config.ConjuntoTecla;
import com.csi.ctfclient.tools.devices.config.RepositorioMapaTeclado;
import com.csi.ctfclient.tools.devices.config.Tecla;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class RepositorioMapaTecladoXML
implements RepositorioMapaTeclado {
    private String pathXml = System.getProperty("com.csi.mapateclado.path");
    private Document documentRoot;

    public RepositorioMapaTecladoXML() throws ExcecaoLocal {
        if (this.pathXml == null) {
            this.pathXml = "mapatecladoCTFClient.xml";
        }
        SAXBuilder parse = new SAXBuilder();
        InputStream is = this.getInputStream(new File(this.pathXml));
        try {
            this.documentRoot = parse.build(is);
        }
        catch (JDOMException e) {
            throw new ExcecaoLocal("", e);
        }
        catch (IOException e) {
            throw new ExcecaoLocal("", e);
        }
    }

    private ConfiguracaoTeclado readConfiguracaoTeclado() throws JDOMException {
        Element elementRoot = this.documentRoot.getRootElement();
        if (!"mapaTeclado".equals(elementRoot.getName())) {
            throw new JDOMException("Erro XML tag raiz diferente de mapaTeclado");
        }
        ConjuntoTecla conjuntoTecla = this.readConjuntoTeclas(elementRoot.getChildren("tecla"));
        ConfiguracaoTeclado configuracaoTeclado = new ConfiguracaoTeclado(elementRoot.getAttributeValue("tipo"), conjuntoTecla);
        configuracaoTeclado.setCodigoModelo(elementRoot.getAttributeValue("layout"));
        return configuracaoTeclado;
    }

    private ConjuntoTecla readConjuntoTeclas(List list) throws JDOMException {
        ConjuntoTecla conjuntoTecla = new ConjuntoTecla();
        for (int i = 0; i < list.size(); ++i) {
            Element elementTeclado = (Element)list.get(i);
            Tecla tecla = new Tecla();
            try {
                int codigo = Integer.parseInt(elementTeclado.getAttributeValue("codigo"));
                tecla.setChave(new ChaveInteira(codigo));
                tecla.setCodigo(codigo);
            }
            catch (NumberFormatException e) {
                throw new JDOMException(e.getMessage());
            }
            tecla.setCodigoAlfanumerico(elementTeclado.getAttributeValue("codigoAlfaNumerico"));
            tecla.setCodigoNumerico(elementTeclado.getAttributeValue("codigoNumerico"));
            tecla.setFinalizadoraAlfanumerico(new Boolean(elementTeclado.getAttributeValue("finalizadorAlfaNumerico")));
            tecla.setFinalizadoraNumerico(new Boolean(elementTeclado.getAttributeValue("finalizadorNumerico")));
            conjuntoTecla.inclui(tecla);
        }
        return conjuntoTecla;
    }

    public ConfiguracaoTeclado getconfiguracaoTeclado() throws ExcecaoLocal {
        try {
            return this.readConfiguracaoTeclado();
        }
        catch (JDOMException e) {
            throw new ExcecaoLocal("", e);
        }
    }

    private InputStream getInputStream(File file) {
        InputStream is = null;
        if (file != null) {
            try {
                is = new FileInputStream(file);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream(file.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/" + file.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("META-INF/" + file.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (is == null) {
            try {
                is = classLoader.getResourceAsStream("/META-INF/" + file.getName());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return is;
    }
}

