/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.DadoSolicitaPin;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.util.Vector;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class BibliotecaPinpad
extends PinEMV
implements Runnable,
ConstantesEMV {
    public static final int BIBLIOTECA_PP_VISA = 0;
    public static final int BIBLIOTECA_EMV = 1;
    public static final int BIBLIOTECA_AUTTAR_EMV = 2;
    Logger logger = CTFClientLogger.getPeriferico();
    Thread pinThread;
    private String versao;
    boolean threadPronta = false;
    private String msgSenha;
    private String msgAguardo;
    private boolean emLeitura;
    private ProtocoloBibliotecaCompartilhada protocolo;

    public static int getTipoBiblioteca() {
        return ProtocoloBibliotecaCompartilhada.getTipoBibliotecaPinpad();
    }

    public BibliotecaPinpad(String serial, String msgPrompt, String msgSenha, String msgAguardo) throws ExcecaoPerifericos {
        this.setMsgPrompt(msgPrompt);
        this.msgSenha = msgSenha;
        this.msgAguardo = msgAguardo;
        this.versao = ProtocoloBibliotecaCompartilhada.versaoBiblioteca;
        this.protocolo = ProtocoloBibliotecaCompartilhada.getInstancia(serial);
    }

    public boolean isBibliotecaEMV() {
        return ProtocoloBibliotecaCompartilhada.isBibliotecaEMV();
    }

    public void setMsgDisplay(String msg) throws ExcecaoPerifericos {
        if (this.getHabilitado()) {
            this.protocolo.display(this.versao.toCharArray(), msg.toCharArray());
        } else {
            this.protocolo.abrirComunicacao();
            this.protocolo.display(this.versao.toCharArray(), msg.toCharArray());
        }
    }

    public void displayProcessando() throws ExcecaoPerifericos {
        this.setMsgDisplay("PROCESSANDO...");
    }

    public static void main(String[] args) {
    }

    public String getKey() {
        return this.getWorkingKey();
    }

    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void desabilita(boolean liberaBBComp) throws ExcecaoPerifericos {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"desabilita periferico");
        }
        this.setHabilitado(false);
        BibliotecaPinpad bibliotecaPinpad = this;
        synchronized (bibliotecaPinpad) {
            this.protocolo.fecharComunicacao(liberaBBComp, this.versao.toCharArray(), this.getMsgPrompt().toCharArray());
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.notifyAll();
        }
    }

    public synchronized void habilita() throws ExcecaoPerifericos {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getClass().getName() + " -> habilita perif\u00e9rico"));
        }
        this.protocolo.abrirComunicacao();
        this.setHabilitado(true);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.getClass().getName() + " -> perif\u00e9rico habilitado"));
        }
        this.pinThread = new Thread(this);
        this.pinThread.start();
        this.notifyAll();
    }

    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        if (this.protocolo != null && this.protocolo.isComunicacaoAberta()) {
            this.desabilita(true);
        }
    }

    public synchronized void liberaRecursos(boolean liberaBBComp) throws ExcecaoPerifericos {
        block2: {
            block3: {
                if (this.protocolo == null) break block2;
                if (this.protocolo.isComunicacaoAberta()) break block3;
                BibliotecaPinpad bibliotecaPinpad = this;
                if (!bibliotecaPinpad.protocolo.isLibBBCompAberta()) break block2;
            }
            this.desabilita(liberaBBComp);
        }
    }

    public String getDUKPT(int modoCriptografia, int indMKey) throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        String cmdGetDUKPT = StringUtil.sprintf("%d%02d", new Object[]{new Integer(modoCriptografia), new Integer(indMKey)});
        SaidaGetDUKPTEMV result = this.protocolo.getDUKPT(this.versao.toCharArray(), cmdGetDUKPT.toCharArray());
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        return result.getKeySerialNumber();
    }

    public String getTimeStampTabelas(int idRede) throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        String id = (idRede < 10 ? "0" : "") + idRede;
        SaidaGetTimeStampEMV result = this.protocolo.getTimeStamp(this.versao.toCharArray(), id.toCharArray());
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("TimeStamp do Pin = " + result.getTimeStamp()));
        }
        this.protocolo.fecharComunicacao(this.versao.toCharArray(), this.getMsgPrompt().toCharArray());
        return result.getTimeStamp();
    }

    private String convChar2Hex(char num) {
        int nibble1 = num & 0xF;
        int nibble2 = num >> 4;
        return (char)(nibble2 < 10 ? 48 + nibble2 : 55 + nibble2) + "" + (char)(nibble1 < 10 ? 48 + nibble1 : 55 + nibble1);
    }

    private String convStrDadosStrHex(String strDados) {
        String strHex = "";
        for (int i = 0; i < strDados.length(); ++i) {
            strHex = strHex + this.convChar2Hex(strDados.charAt(i));
        }
        return strHex;
    }

    public String encryptBuffer(int tipoCriptografia, int indiceMasterKey, String workingKey, String dados) throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        SaidaEncryptBufferEMV saida = this.protocolo.encryptBuffer2(this.versao.toCharArray(), tipoCriptografia, indiceMasterKey, workingKey.toCharArray(), dados.toCharArray());
        int result = saida.getRetorno();
        this.logger.log((Priority)Level.INFO, (Object)("encryptBuffer = " + result));
        if (result == 0) {
            return saida.getDadosCriptografados();
        }
        throw new ExcecaoPerifericos(this, ProtocoloBibliotecaCompartilhada.retornaMensagemErro(saida.getRetorno()));
    }

    private void executaLeitura() {
        this.emLeitura = true;
        switch (this.cmdLeitura) {
            case 1: {
                this.esperaGoOnChip();
                break;
            }
            case 3: {
                this.esperaGetKey();
                break;
            }
            case 4: {
                this.esperaGenericCommand();
                break;
            }
            default: {
                this.esperaGetPin();
            }
        }
        this.emLeitura = false;
    }

    public void run() {
        this.executaLeitura();
    }

    private char[] parmsGetPin() {
        Vector v = this.getParmsPedido();
        String dados = "" + v.size();
        for (int i = 0; i < v.size(); ++i) {
            dados = dados + StringUtil.sprintf("%02d%02d%-32s", new Object[]{new Integer(((DadoSolicitaPin)v.elementAt(i)).getTamMin()), new Integer(((DadoSolicitaPin)v.elementAt(i)).getTamMax()), ((DadoSolicitaPin)v.elementAt(i)).getMensagemSolicitacao()});
        }
        this.resetParms();
        String numeroCartao = this.getNumeroCartaoCripto() != null && this.getNumeroCartaoCripto().trim().length() > 0 ? this.getNumeroCartaoCripto() : this.getNumeroCartao();
        String cmdGetPin = StringUtil.sprintf("%d%02d%-32s%02d%-19s%s", new Object[]{new Integer(this.getTipoCriptografia()), new Integer(this.getIndiceMasterKey()), this.getWorkingKey(), new Integer(numeroCartao.trim().length()), numeroCartao, dados});
        return cmdGetPin.toCharArray();
    }

    private char[] parmsGetGenericCommand() {
        String cmdGetGenericCommand = this.getBufferGenericCommand();
        return cmdGetGenericCommand.toCharArray();
    }

    private char[] parmsGoOnChip() {
        String tmpDadosRestantes = null;
        if (this.getDadosRestantes() == null) {
            tmpDadosRestantes = "000";
        } else {
            DecimalFormat decimalFormat = new DecimalFormat("000");
            tmpDadosRestantes = decimalFormat.format(this.getDadosRestantes().length()) + this.getDadosRestantes();
        }
        String thresholdValue = StringUtil.completaString("" + this.getThresholdValueBiasedRandomSelection(), 4, '0', true);
        thresholdValue = this.convStrDadosStrHex(thresholdValue);
        String workingKey = StringUtil.completaString(this.getWorkingKey(), 32, '0', false);
        String cmdGoOnChip = StringUtil.sprintf("%012ld%012ld%d%d%d%d%02d%s%d%s%02d%s%02d%s", new Object[]{new Long(this.getNovoValorTransacao()), new Long(this.getParcelaValorTransacao()), new Integer(this.getConstaListaNegra() ? 1 : 0), new Integer(this.getObrigaTransacaoOnline() ? 1 : 0), new Integer(this.getReqPINTabelasServTEF() ? 1 : 0), new Integer(this.getTipoCriptografia()), new Integer(this.getIndiceMasterKey()), workingKey, new Integer(this.getGerencRisco() ? 1 : 0), this.getTermFloorLimit(), new Integer(this.getTargetPercBiasedRandomSelection()), this.getThresholdValueBiasedRandomSelection(), new Integer(this.getMaxTargetPerc()), tmpDadosRestantes});
        return cmdGoOnChip.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCard(String msgPromo) throws ExcecaoPerifericos {
        SaidaRemoveCardEMV result;
        try {
            int retorno;
            this.protocolo.abrirComunicacao();
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                retorno = this.protocolo.startRemoveCard(this.versao.toCharArray(), StringUtil.completaString(msgPromo, 32, ' ', false).toCharArray());
            }
            this.logger.info((Object)("retorno startRemoveCard() = " + retorno));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    result = this.protocolo.removeCard(this.versao.toCharArray());
                }
                if (result.getRetorno() == 2 && result.getMsgNotify() != null && result.getMsgNotify().trim().length() > 0) {
                    this.lancaEventoMensagem(this, result.getMsgNotify());
                }
                this.logger.info((Object)("retorno da removeCard() = " + result.getRetorno()));
            } while (result.getRetorno() == 1 || result.getRetorno() == 2);
            Object var8_7 = null;
            this.protocolo.abort(this.versao.toCharArray());
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.protocolo.abort(this.versao.toCharArray());
            throw throwable;
        }
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCardNoClose(String msgPromo) throws ExcecaoPerifericos {
        SaidaRemoveCardEMV result;
        try {
            int retorno;
            this.protocolo.abrirComunicacao();
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                retorno = this.protocolo.startRemoveCard(this.versao.toCharArray(), StringUtil.completaString(msgPromo, 32, ' ', false).toCharArray());
            }
            this.logger.info((Object)("retorno startRemoveCard() = " + retorno));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    result = this.protocolo.removeCard(this.versao.toCharArray());
                }
                if (result.getRetorno() == 2 && result.getMsgNotify() != null && result.getMsgNotify().trim().length() > 0) {
                    this.lancaEventoMensagem(this, result.getMsgNotify());
                }
                this.logger.info((Object)("retorno da removeCard() = " + result.getRetorno()));
            } while (result.getRetorno() == 1 || result.getRetorno() == 2);
            Object var8_7 = null;
            this.protocolo.abort(this.versao.toCharArray());
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.protocolo.abort(this.versao.toCharArray());
            throw throwable;
        }
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void esperaGetPin() {
        try {
            SaidaGetPinEMV result;
            int retorno;
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                if (!this.getHabilitado()) {
                    return;
                }
                retorno = this.protocolo.startGetPIN(this.versao.toCharArray(), this.parmsGetPin());
            }
            this.logger.info((Object)("retorno startGetPin = " + retorno));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    if (!this.getHabilitado()) {
                        return;
                    }
                    result = this.protocolo.getPin(this.versao.toCharArray());
                    if (this.isBibliotecaEMV() && !this.emLeitura) {
                        this.logger.debug((Object)"abort esperaGetPin()");
                        result = new SaidaGetPinEMV();
                        result.setRetorno(13);
                        break;
                    }
                }
                this.logger.info((Object)("retorno getPin = " + result.getRetorno()));
                if (result.getRetorno() != 2) continue;
                this.lancaEventoMensagem(this, result.getMsgNotify());
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.lancaEventoPin(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), this.getTipoCriptografia(), result);
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)"erro no comando esperaGetPin.", (Throwable)e);
            this.lancaEventoPin(this, false, true, 999, this.getTipoCriptografia(), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void esperaGetKey() {
        block18: {
            block17: {
                block16: {
                    try {
                        try {
                            int result;
                            int retorno;
                            BibliotecaPinpad bibliotecaPinpad = this;
                            synchronized (bibliotecaPinpad) {
                                if (!this.getHabilitado()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 1, 6, 15] lbl6 : MonitorExitStatement: MONITOREXIT : var3_1
                                    Object var7_3 = null;
                                    break block16;
                                }
                                retorno = this.protocolo.startGetKey(this.versao.toCharArray());
                            }
                            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
                            do {
                                bibliotecaPinpad = this;
                                synchronized (bibliotecaPinpad) {
                                    if (!this.getHabilitado()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 10, 14] lbl17 : MonitorExitStatement: MONITOREXIT : var3_1
                                        break block17;
                                    }
                                    result = this.protocolo.getKey(this.versao.toCharArray());
                                    this.logger.debug((Object)"esperaGetKey()");
                                    if (this.isBibliotecaEMV() && !this.emLeitura) {
                                        this.logger.debug((Object)"abort esperaGetKey()");
                                        result = 13;
                                        break;
                                    }
                                    if (result != 2) continue;
                                }
                            } while ((result == 1 || result == 2) && this.getHabilitado());
                            if (this.getHabilitado()) {
                                this.lancaEventoKey(this, result == 13, result != 13 && result != 0 && result != 4 && result != 5 && result != 6 && result != 7 && result != 8, result);
                            }
                            break block18;
                        }
                        catch (ExcecaoPerifericos e) {
                            this.lancaEventoPin(this, false, true, 999, this.getTipoCriptografia(), null);
                            Object var7_6 = null;
                            this.setHabilitado(false);
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        this.setHabilitado(false);
                        throw throwable;
                    }
                }
                this.setHabilitado(false);
                return;
            }
            Object var7_4 = null;
            this.setHabilitado(false);
            return;
        }
        Object var7_5 = null;
        this.setHabilitado(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void esperaVariasGetKey() {
        block18: {
            block17: {
                int result = -1;
                try {
                    try {
                        StringBuffer digitosCapturados = new StringBuffer();
                        boolean i = true;
                        while (i) {
                            int retorno;
                            BibliotecaPinpad bibliotecaPinpad = this;
                            synchronized (bibliotecaPinpad) {
                                if (!this.getHabilitado()) {
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 1, 6, 10] lbl10 : MonitorExitStatement: MONITOREXIT : var6_5
                                    Object var10_6 = null;
                                    break block17;
                                }
                                retorno = this.protocolo.startGetKey(this.versao.toCharArray());
                            }
                            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
                            do {
                                bibliotecaPinpad = this;
                                synchronized (bibliotecaPinpad) {
                                    if (!this.getHabilitado()) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 10, 11, 14] lbl21 : MonitorExitStatement: MONITOREXIT : var6_5
                                        Object var10_7 = null;
                                        this.setHabilitado(false);
                                        return;
                                    }
                                    result = this.protocolo.getKey(this.versao.toCharArray());
                                    this.logger.debug((Object)"esperaGetKey()");
                                    if (this.isBibliotecaEMV() && !this.emLeitura) {
                                        this.logger.debug((Object)"abort esperaGetKey()");
                                        result = 13;
                                        break;
                                    }
                                    if (result != 2) continue;
                                }
                            } while ((result == 1 || result == 2) && this.getHabilitado());
                            System.out.println(result);
                        }
                        if (this.getHabilitado()) {
                            this.lancaEventoKey(this, result == 13, result != 13 && result != 0 && result != 4 && result != 5 && result != 6 && result != 7 && result != 8, result);
                        }
                        break block18;
                    }
                    catch (ExcecaoPerifericos e) {
                        this.lancaEventoPin(this, false, true, 999, this.getTipoCriptografia(), null);
                        Object var10_9 = null;
                        this.setHabilitado(false);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_10 = null;
                    this.setHabilitado(false);
                    throw throwable;
                }
            }
            this.setHabilitado(false);
            return;
        }
        Object var10_8 = null;
        this.setHabilitado(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void esperaGenericCommand() {
        try {
            SaidaGenericCmdEMV result;
            int retorno;
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                if (!this.getHabilitado()) {
                    return;
                }
                retorno = this.protocolo.startGenericCmd(this.versao.toCharArray(), this.parmsGetGenericCommand());
            }
            this.logger.info((Object)("retorno startGetGenericCommand = " + retorno));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    if (!this.getHabilitado()) {
                        return;
                    }
                    result = this.protocolo.genericCmd(this.versao.toCharArray());
                    if (this.isBibliotecaEMV() && !this.emLeitura) {
                        this.logger.debug((Object)"abort esperaGenericCommand()");
                        result = new SaidaGenericCmdEMV();
                        result.setRetorno(13);
                        break;
                    }
                }
                this.logger.info((Object)("retorno genericCommand = " + result.getRetorno()));
                if (result.getRetorno() != 2) continue;
                this.lancaEventoMensagem(this, result.getMsgNotify());
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.lancaEventoGenericCommand(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), result);
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)"erro no comando esperaGenericCommand.", (Throwable)e);
            this.lancaEventoPin(this, false, true, 999, this.getTipoCriptografia(), null);
        }
    }

    private char[] formataTags(String t) {
        if (t != null) {
            String tam = StringUtil.completaString("" + t.length() / 2, 3, '0', true);
            return (tam + t).toCharArray();
        }
        return "000".toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void esperaGoOnChip() {
        SaidaGoOnChipEMV result = null;
        try {
            int retorno;
            BibliotecaPinpad bibliotecaPinpad = this;
            synchronized (bibliotecaPinpad) {
                if (!this.getHabilitado()) {
                    return;
                }
                retorno = this.protocolo.startGoOnChip(this.versao.toCharArray(), this.parmsGoOnChip(), this.formataTags(this.getTags()), this.formataTags(this.getTagsOpt()));
            }
            this.logger.info((Object)("retorno startGoOnChip = " + retorno));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
            do {
                bibliotecaPinpad = this;
                synchronized (bibliotecaPinpad) {
                    if (!this.getHabilitado()) {
                        return;
                    }
                    result = this.protocolo.goOnChip(this.versao.toCharArray());
                    this.logger.debug((Object)"esperaGoOnChip");
                    if (this.isBibliotecaEMV() && !this.emLeitura) {
                        this.logger.debug((Object)"abort esperaGoOnChip()");
                        result = new SaidaGoOnChipEMV();
                        result.setRetorno(13);
                        break;
                    }
                }
                if (result.getRetorno() == 2) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("GoOnChip. notify result = " + result.getRetorno() + " - " + result.getMsgNotify()));
                    }
                    this.lancaEventoMensagem(this, result.getMsgNotify());
                }
                this.logger.info((Object)("retorno goOnChip = " + result.getRetorno()));
            } while ((result == null || result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                this.lancaEventoLeituraChip(this, result.getRetorno() == 13, result.getRetorno() != 13 && result.getRetorno() != 0, result.getRetorno(), this.getTipoCriptografia(), result);
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)"erro no comando esperaGoOnChip.", (Throwable)e);
            this.lancaEventoLeituraChip(this, false, true, 999, this.getTipoCriptografia(), null);
        }
    }

    public SaidaFinishChipEMV finishChip() throws ExcecaoPerifericos {
        String responseCode;
        String tags;
        this.protocolo.abrirComunicacao();
        String dadosRestantes = this.getDadosRestantes();
        if (dadosRestantes == null) {
            dadosRestantes = "";
        }
        if ((tags = this.getTags()) == null) {
            tags = "";
        }
        if ((responseCode = this.getAuthRespCode()).length() == 3) {
            responseCode = responseCode.substring(1);
        }
        String input = StringUtil.sprintf("%d%d%s%03d%s%03d%s", new Object[]{new Integer(this.getComunicacaoHost()), new Integer(this.getTipoEmissor()), responseCode, new Integer(this.getCampo55().length() / 2), this.getCampo55(), new Integer(dadosRestantes.length() / 2), dadosRestantes});
        SaidaFinishChipEMV result = this.protocolo.finishChip(ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray(), input.toCharArray(), this.formataTags(tags));
        this.logger.info((Object)("retorno finishChip = " + result.getRetorno()));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        return result;
    }

    public SaidaGetInfoEMV getInfo() throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        SaidaGetInfoEMV result = this.protocolo.getInfoEMV(ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray(), "00".toCharArray());
        if (this.logger.isDebugEnabled()) {
            this.logger.info((Object)("retorno getInfo = " + result.getRetorno()));
            this.logger.info((Object)(" info -> fabricante = " + result.getFabricante()));
            this.logger.info((Object)(" info -> Modelo hardware = " + result.getModeloHardware()));
            this.logger.info((Object)(" info -> N\u00famero serie pinpad = " + result.getNumSeriePinpad()));
            this.logger.info((Object)(" info -> Vers\u00e3o Aplic. basica= " + result.getVersaoAplBasica()));
            this.logger.info((Object)(" info -> Vers\u00e3o especifica\u00e7\u00e3o = " + result.getVersaoEspecificacao()));
            this.logger.info((Object)(" info -> Vers\u00e3o firmware = " + result.getVersaoFirmware()));
        }
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        this.protocolo.display(this.versao.toCharArray(), this.getMsgPrompt().toCharArray());
        return result;
    }

    public SaidaGetInfoVisanetEMV getInfoVisanet() throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        SaidaGetInfoVisanetEMV result = this.protocolo.getInfoCieloEMV(ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray());
        this.logger.info((Object)("retorno getInfoVisanet = " + result.getRetorno()));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        return result;
    }

    public SaidaGetInfoRedecardEMV getInfoRedecard() throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        SaidaGetInfoRedecardEMV result = this.protocolo.getInfoRedecardEMV(ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray());
        this.logger.info((Object)("retorno getInfoRedecard = " + result.getRetorno()));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
        this.protocolo.display(this.versao.toCharArray(), this.getMsgPrompt().toCharArray());
        return result;
    }

    public DadosGetInfoRedeEMV getInfoRedeEMV(int rede) throws ExcecaoPerifericos {
        try {
            this.protocolo.abrirComunicacao();
            DadosGetInfoRedeEMV result = this.protocolo.getInfoPorRedeEMV(rede, ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray());
            this.logger.info((Object)("retorno getInfoRedeEMV -> " + rede + " = " + result.getRetorno()));
            ProtocoloBibliotecaCompartilhada.testaRetorno(this, result.getRetorno());
            return result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void abort() {
        this.emLeitura = false;
        this.protocolo.abort(this.versao.toCharArray());
    }

    public int changeParameter(String parametrosTLV) throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        int retorno = this.protocolo.changeParameter(ProtocoloBibliotecaCompartilhada.versaoBiblioteca.toCharArray(), parametrosTLV.toCharArray());
        this.logger.debug((Object)("retorno changeParameter = " + retorno));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
        return retorno;
    }
}

