/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.excecoes.ExcecaoInteiroInvalido;
import com.csi.ctfclient.operacoes.model.Aid;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.LeitorCartaoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.ProtocoloBibliotecaCompartilhada;
import com.csi.ctfclient.tools.util.CSISecurity;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class LeitorCartaoBibliotecaCompartilhada
extends LeitorCartaoEMV
implements ConstantesEMV,
Runnable {
    private static Logger loggerStatic = CTFClientLogger.getPeriferico();
    private Logger logger = CTFClientLogger.getPeriferico();
    private Thread leitor = null;
    private String versao = "";
    private String srvConPar = "";
    private ProtocoloBibliotecaCompartilhada protocolo;

    public LeitorCartaoBibliotecaCompartilhada(ProtocoloBibliotecaCompartilhada protocolo) throws ExcecaoPerifericos {
        this.protocolo = protocolo;
        this.setIdRedeAdquirente(0);
        this.setTipoAplicacao(1);
        this.setValorInicialTransacao(100L);
        GregorianCalendar calendar = new GregorianCalendar(2006, 0, 16);
        this.setDataTransacao(calendar.getTime());
        this.setTimeStamp("1602200602");
        this.setIdsRedeIndTab(null);
        this.versao = ProtocoloBibliotecaCompartilhada.versaoBiblioteca;
    }

    public char[] getSrvConPar() {
        return this.srvConPar.toCharArray();
    }

    public char[] montaCmdStartGetCard() {
        String idsAceitos;
        LeitorCartaoBibliotecaCompartilhada leitorCartaoBibliotecaCompartilhada = this;
        boolean pinEMV = leitorCartaoBibliotecaCompartilhada.protocolo.isBibliotecaEMV();
        Date dt = this.getDataTransacao();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");
        StringBuffer stringBuffer = new StringBuffer();
        DecimalFormat numberFormat = new DecimalFormat("00");
        int redeAdquirente = pinEMV ? this.getIdRedeAdquirente() : 0;
        stringBuffer.append(numberFormat.format(redeAdquirente));
        int tipoAplicacao = this.getTipoAplicacao();
        if (pinEMV && (redeAdquirente == 0 || redeAdquirente > 0 && this.getIndiceAID() != null)) {
            idsAceitos = this.formataIdsRedeIndTabs();
            if (Integer.parseInt(idsAceitos.substring(0, 2)) > 0) {
                tipoAplicacao = 0;
            }
        } else {
            idsAceitos = "00";
        }
        stringBuffer.append(numberFormat.format(tipoAplicacao));
        numberFormat.applyPattern("000000000000");
        stringBuffer.append(numberFormat.format(this.getValorInicialTransacao()));
        stringBuffer.append(dateFormat.format(dt));
        dateFormat.applyPattern("HHmmss");
        stringBuffer.append(dateFormat.format(dt));
        stringBuffer.append(this.getTimeStamp());
        stringBuffer.append(idsAceitos);
        String cmd = stringBuffer.toString();
        return cmd.toCharArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void esperaGetCard() {
        try {
            SaidaGetCardEMV result;
            LeitorCartaoBibliotecaCompartilhada leitorCartaoBibliotecaCompartilhada = this;
            synchronized (leitorCartaoBibliotecaCompartilhada) {
                int retorno;
                if (!this.getHabilitado()) {
                    return;
                }
                if (this.getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_OK || this.getSolicitaCargaTabelas() == LeitorCartaoEMV.CARGA_TABELA_SOLICITADA) {
                    retorno = this.protocolo.startGetCard(this.versao.toCharArray(), this.getSrvConPar(), this.montaCmdStartGetCard());
                    this.logger.info((Object)("retorno startGetCard = " + retorno));
                    if (retorno == 31) {
                        this.resetSerial();
                        return;
                    }
                    ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
                } else {
                    this.setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_OK);
                    retorno = this.protocolo.resumeGetCard(this.versao.toCharArray());
                    this.logger.info((Object)("retorno resumeGetCard = " + retorno));
                    if (retorno == 31) {
                        this.resetSerial();
                        return;
                    }
                }
            }
            do {
                leitorCartaoBibliotecaCompartilhada = this;
                synchronized (leitorCartaoBibliotecaCompartilhada) {
                    if (!this.getHabilitado()) {
                        return;
                    }
                    result = this.protocolo.getCard(this.versao.toCharArray(), this.montaCmdStartGetCard());
                }
                this.logger.info((Object)("retorno GetCard = " + result.getRetorno()));
                switch (result.getRetorno()) {
                    case 2: {
                        this.lancaEventoMensagem(this, result.getMsgNotify());
                        break;
                    }
                    case 20: {
                        this.setSolicitaCargaTabelas(LeitorCartaoEMV.CARGA_TABELA_TABEXP);
                        break;
                    }
                    case 31: {
                        this.resetSerial();
                    }
                }
            } while ((result.getRetorno() == 1 || result.getRetorno() == 2) && this.getHabilitado());
            if (this.getHabilitado()) {
                if (ProtocoloBibliotecaCompartilhada.isBibliotecaEMV() && ProtocoloBibliotecaCompartilhada.isComunicacaoSegura()) {
                    if (result.getPAN().trim().length() > 12) {
                        String panAbertoCompleto;
                        String panCripto = result.getPAN();
                        String panCriptoTrilha1 = result.getPANTrilha1();
                        String panCriptoTrilha2 = result.getPANTrilha2();
                        String panAberto = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panCripto, true);
                        String panAbertoTrilha1 = "";
                        String panAbertoTrilha2 = "";
                        if (panCriptoTrilha1 != null && !panCriptoTrilha1.equals("")) {
                            panAbertoTrilha1 = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panCriptoTrilha1, true);
                        }
                        if (panCriptoTrilha2 != null && !panCriptoTrilha2.equals("")) {
                            panAbertoTrilha2 = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panCriptoTrilha2, true);
                        }
                        String panCripto16 = panCripto.length() > 16 ? panCripto.substring(panCripto.length() - 16, panCripto.length()) : panCripto;
                        String panCripto16Trilha1 = panCriptoTrilha1.length() > 16 ? panCriptoTrilha1.substring(panCriptoTrilha1.length() - 16, panCriptoTrilha1.length()) : panCriptoTrilha1;
                        String panCripto16Trilha2 = panCriptoTrilha2.length() > 16 ? panCriptoTrilha2.substring(panCriptoTrilha2.length() - 16, panCriptoTrilha2.length()) : panCriptoTrilha2;
                        if (panCripto16Trilha1.length() > 0) {
                            result.setTrilha1(LeitorCartaoBibliotecaCompartilhada.atualizaTrilha(result.getTrilha1(), panCripto16Trilha1, panAbertoTrilha1));
                        }
                        if (panCripto16Trilha2.length() > 0) {
                            result.setTrilha2(LeitorCartaoBibliotecaCompartilhada.atualizaTrilha(result.getTrilha2(), panCripto16Trilha2, panAbertoTrilha2));
                        }
                        if (panCripto.length() > 16) {
                            String restantePan = panCripto.substring(0, panCripto.length() - 16);
                            this.logger.log((Priority)Level.DEBUG, (Object)("Restante PAN: " + restantePan));
                            panAbertoCompleto = restantePan + panAberto;
                        } else {
                            panAbertoCompleto = panAberto;
                        }
                        panAbertoCompleto = this.retiraEspacosPAN(panAbertoCompleto);
                        if (result.isTrilhasSemDelimitadores()) {
                            this.logger.log((Priority)Level.INFO, (Object)"Delimitadores das trilhas n\u00e3o encontrados, capturando o PAN do inicio da trilha...");
                            StringBuffer bufferPAN = new StringBuffer();
                            for (int i = 0; i < result.getTrilha2().length(); ++i) {
                                if (Character.isDigit(result.getTrilha2().charAt(i))) {
                                    bufferPAN.append(result.getTrilha2().charAt(i));
                                }
                                if (bufferPAN.length() == 19) break;
                            }
                            panAbertoCompleto = bufferPAN.toString();
                            this.logger.log((Priority)Level.INFO, (Object)("Foram capturados os " + panAbertoCompleto.length() + " primeiros d\u00edgitos da trilha 2 para constituir o PAN"));
                        }
                        String panAbertoParaReverter = panAbertoCompleto.length() < 16 ? StringUtil.completaString(panAbertoCompleto, 16, 'F', 4) : (panAbertoCompleto.length() > 16 ? panAbertoCompleto.substring(0, 16) : panAbertoCompleto);
                        String pan3DESReverso = LeitorCartaoBibliotecaCompartilhada.descriptografaPAN(panAbertoParaReverter, false);
                        if (panAbertoCompleto.length() > 16) {
                            String restantePan = panAbertoCompleto.substring(16);
                            this.logger.log((Priority)Level.DEBUG, (Object)("Restante PAN: " + restantePan));
                            pan3DESReverso = pan3DESReverso + restantePan;
                            this.logger.log((Priority)Level.DEBUG, (Object)("Pan 3Des reverso: " + pan3DESReverso));
                        }
                        result.setPANCripto(pan3DESReverso);
                        result.setPAN(panAbertoCompleto);
                        this.logger.debug((Object)"PAN do cart\u00e3o descriptografado.");
                    } else if (result.getRetorno() == 0) {
                        this.logger.debug((Object)"PAN do cart\u00e3o menor que 13 d\u00edgitos, as trilhas n\u00e3o ser\u00e3o descriptografadas.");
                    }
                } else {
                    result.setPAN(this.retiraEspacosPAN(result.getPAN()));
                }
                this.setHabilitado(false);
                this.lancaEvento(this, result, result.getRetorno() != 0 && result.getRetorno() != 13, result.getRetorno());
            }
        }
        catch (ExcecaoPerifericos e) {
            this.logger.error((Object)"erro no comando esperaGetCard.", (Throwable)e);
            this.setHabilitado(false);
            this.lancaEvento(this, null, true, 999);
        }
        catch (Exception e) {
            this.logger.error((Object)("erro no comando esperaGetCard. Wkpan:'" + ProtocoloBibliotecaCompartilhada.wkpan + "', for\u00e7ando erro: 68"), (Throwable)e);
            this.setHabilitado(false);
            this.lancaEvento(this, null, true, 68);
        }
    }

    public static String descriptografaPAN(String panCripto, boolean formatarEspacos) {
        CSISecurity csiSecurity = new CSISecurity();
        int tamanhoPan = panCripto.length();
        String panCripto16 = tamanhoPan > 16 ? panCripto.substring(tamanhoPan - 16, tamanhoPan) : panCripto;
        String panAberto = csiSecurity.decrypt3DES(ProtocoloBibliotecaCompartilhada.wkpan, panCripto16);
        if (panAberto == null) {
            loggerStatic.log((Priority)Level.ERROR, (Object)("Pan nulo antes desconvert\u00ea-lo. WKPAN='" + ProtocoloBibliotecaCompartilhada.wkpan + "', lenght pan cripto=" + panCripto16.length()));
        }
        if (formatarEspacos) {
            panAberto = LeitorCartaoBibliotecaCompartilhada.desconverterPan(panAberto);
        }
        return panAberto;
    }

    private String formataIdsRedeIndTabs() {
        List listAID = this.getIdsRedeIndTab();
        if (listAID != null && listAID.size() > 0) {
            String retorno = StringUtil.completaString("" + listAID.size(), 2, '0', 3);
            for (Aid aid : listAID) {
                retorno = retorno + StringUtil.completaString(aid.getRede(), 2, '0', 3) + StringUtil.completaString(aid.getIndice(), 2, '0', 3);
            }
            return retorno;
        }
        return "00";
    }

    public void desabilita() throws ExcecaoPerifericos {
        this.setHabilitado(false);
        this.protocolo.abort(this.versao.toCharArray());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"desabilita leitor cart\u00e3o -> abort");
        }
    }

    public void resetSerial() {
        this.setHabilitado(false);
        this.protocolo.resetSerial();
        this.lancaEvento(this, null, true, 31);
    }

    public void desabilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido, ExcecaoPerifericos {
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = false;
                break;
            }
            case 2: {
                this.trilha2Habilitada = false;
                break;
            }
            case 3: {
                this.trilha3Habilitada = false;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    public synchronized void habilita() throws ExcecaoPerifericos {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"habilita leitor cart\u00e3o");
        }
        this.protocolo.abrirComunicacao();
        this.setHabilitado(true);
        this.leitor = new Thread(this);
        this.leitor.start();
        this.notifyAll();
    }

    public void habilitaTrilha(int numTrilha) throws ExcecaoInteiroInvalido, ExcecaoPerifericos {
        switch (numTrilha) {
            case 1: {
                this.trilha1Habilitada = true;
                break;
            }
            case 2: {
                this.trilha2Habilitada = true;
                break;
            }
            case 3: {
                this.trilha3Habilitada = true;
                break;
            }
            default: {
                throw new ExcecaoInteiroInvalido("PER62");
            }
        }
    }

    public synchronized void liberaRecursos() throws ExcecaoPerifericos {
        this.logger.debug((Object)"Libera recursos leitor cartao biblioteca compartilhada");
    }

    public void run() {
        this.esperaGetCard();
    }

    public static String atualizaTrilha(String trilha, String panAntigo, String panNovo) {
        int index;
        String retorno = trilha;
        if (trilha != null && trilha.trim().length() > 0 && (index = trilha.indexOf(panAntigo)) != -1) {
            retorno = trilha.substring(0, index) + panNovo + trilha.substring(index + panAntigo.length(), trilha.length());
        }
        return retorno;
    }

    private String atualizaPan(String pan, String panCripto, String panAberto) {
        int index;
        String retorno = pan;
        if (pan != null && pan.trim().length() > 0 && (index = pan.indexOf(panCripto)) != -1) {
            retorno = pan.substring(0, index) + panAberto + pan.substring(index + panCripto.length(), pan.length());
        }
        return retorno;
    }

    private String retiraEspacosPAN(String pan) {
        if (pan != null) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < pan.length(); ++i) {
                if (pan.charAt(i) == ' ') continue;
                buffer.append(pan.charAt(i));
            }
            return buffer.toString();
        }
        return pan;
    }

    private static String desconverterPan(String pan) {
        int i;
        String panTemp = pan.replace('E', ' ');
        for (i = panTemp.length(); i > 0 && pan.substring(i - 1, i).equals("F"); --i) {
        }
        return panTemp.substring(0, i);
    }

    public int iniciaCargaTabelas(String timeStamp) throws ExcecaoPerifericos {
        this.protocolo.abrirComunicacao();
        String cmdTableInit = (this.getIdRedeAdquirente() < 10 ? "0" : "") + this.getIdRedeAdquirente() + timeStamp;
        int retorno = this.protocolo.tableLoadInit(this.versao.toCharArray(), cmdTableInit.toCharArray());
        this.logger.info((Object)("retorno tableLoadInit = " + retorno));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
        return retorno;
    }

    public int executaCargaTabelas(String tabela) throws ExcecaoPerifericos {
        int retorno = this.protocolo.tableLoadRec(this.versao.toCharArray(), tabela.toCharArray());
        this.logger.info((Object)("retorno tableLoadRec = " + retorno));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
        return retorno;
    }

    public int finalizaCargaTabelas() throws ExcecaoPerifericos {
        int retorno = this.protocolo.tableLoadEnd(this.versao.toCharArray());
        this.logger.info((Object)("retorno tableLoadEnd = " + retorno));
        ProtocoloBibliotecaCompartilhada.testaRetorno(this, retorno);
        return retorno;
    }

    public static void main(String[] args) {
        LeitorCartaoBibliotecaCompartilhada leitor = null;
        try {
            leitor = new LeitorCartaoBibliotecaCompartilhada(null);
        }
        catch (ExcecaoPerifericos e) {
            e.printStackTrace();
        }
        System.out.println(LeitorCartaoBibliotecaCompartilhada.desconverterPan("764E361234E56006"));
        System.out.println(LeitorCartaoBibliotecaCompartilhada.desconverterPan("4987432874320001"));
        System.out.println(LeitorCartaoBibliotecaCompartilhada.desconverterPan("3764361234006FFF"));
        System.out.println(LeitorCartaoBibliotecaCompartilhada.desconverterPan("376436123456006F"));
        System.out.println(LeitorCartaoBibliotecaCompartilhada.desconverterPan("6002938264523821"));
        SaidaGetCardEMV result = new SaidaGetCardEMV();
    }
}

