/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.emvfull;

import com.csi.ctfclient.tools.devices.ExcecaoBibliotecaCompartilhada;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.Periferico;
import com.csi.ctfclient.tools.devices.emv.ConstantesEMV;
import com.csi.ctfclient.tools.devices.emv.DadosGetInfoRedeEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaChipDirectEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaDefineWKPANEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaEncryptBufferEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaFinishChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGenericCmdEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetCardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetDUKPTEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoRedecardEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetInfoVisanetEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetPinEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGetTimeStampEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaGoOnChipEMV;
import com.csi.ctfclient.tools.devices.emv.SaidaRemoveCardEMV;
import com.csi.ctfclient.tools.devices.emvfull.KeyFactory;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ProtocoloBibliotecaCompartilhada
implements ConstantesEMV {
    public static final int NOT_PIN = 0;
    public static final int PIN_EMV_TYPE = 1;
    public static final int PIN_PPVISA_TYPE = 2;
    private SaidaGetInfoEMV saidaGetInfoEMV = null;
    private SaidaGetInfoVisanetEMV saidaGetInfoCielo = null;
    private SaidaGetInfoRedecardEMV saidaGetInfoRedecard = null;
    private Map mapGetInfoRedeEMV = new HashMap();
    private static Logger logger = CTFClientLogger.getPeriferico();
    private boolean comunicacaoAberta;
    private static boolean libBBCompAberta;
    private static String portaSerial;
    private static int redeAdquirente;
    private static int tipoBibliotecaPinpad;
    private static boolean comunicacaoSegura;
    private static boolean comunicacaoSeguraHabilitada;
    private static int timeoutPinDefault;
    private static int timeoutPinBlocking;
    private static int timeoutPinNoblocking;
    public static String wkpan;
    public static String versaoBiblioteca;
    private static ProtocoloBibliotecaCompartilhada instancia;

    public String getVersaoBiblioteca() {
        return versaoBiblioteca;
    }

    private ProtocoloBibliotecaCompartilhada(String porta) {
        portaSerial = ProtocoloBibliotecaCompartilhada.formatPortaSerial(porta);
    }

    public static void setTipoBibliotecaPinpad(int tipoBibliotecaPinpad) {
        if (tipoBibliotecaPinpad == 0) {
            logger.info((Object)"CTFClient configurado para biblioteca de pinpad PP_VISA");
        } else if (tipoBibliotecaPinpad == 1) {
            logger.info((Object)"CTFClient configurado para biblioteca de pinpad EMV");
        } else if (tipoBibliotecaPinpad == 2) {
            logger.info((Object)"CTFClient configurado para biblioteca de pinpad Auttar");
        }
        ProtocoloBibliotecaCompartilhada.tipoBibliotecaPinpad = tipoBibliotecaPinpad;
    }

    public static boolean isBibliotecaEMV() {
        return tipoBibliotecaPinpad == 1 || tipoBibliotecaPinpad == 2;
    }

    public static int getTipoBibliotecaPinpad() {
        return tipoBibliotecaPinpad;
    }

    private static void setComunicacaoSegura(boolean comunicacaoSegura) {
        if (comunicacaoSegura) {
            logger.log((Priority)Level.INFO, (Object)"CTFClient configurado para realizar comunica\u00e7\u00e3o segura com o pinpad");
        } else {
            logger.log((Priority)Level.INFO, (Object)"CTFClient n\u00e3o configurado para realizar comunica\u00e7\u00e3o segura com o pinpad");
        }
        ProtocoloBibliotecaCompartilhada.comunicacaoSegura = comunicacaoSegura;
    }

    public static boolean isComunicacaoSegura() {
        return comunicacaoSegura;
    }

    public static boolean isComunicacaoSeguraHabilitada() {
        return comunicacaoSeguraHabilitada;
    }

    public static void setComunicacaoSeguraHabilitada(boolean comunicacaoSeguraHabilitada) {
        ProtocoloBibliotecaCompartilhada.comunicacaoSeguraHabilitada = comunicacaoSeguraHabilitada;
    }

    public static void setTimeoutPin(int timeoutPinDefault, int timeoutPinBlocking, int timeoutPinNoblocking) {
        logger.log((Priority)Level.INFO, (Object)("Timeout default do pin configurado para " + timeoutPinDefault));
        ProtocoloBibliotecaCompartilhada.timeoutPinDefault = timeoutPinDefault;
        logger.log((Priority)Level.INFO, (Object)("Timeout blocking do pin configurado para " + timeoutPinBlocking));
        ProtocoloBibliotecaCompartilhada.timeoutPinBlocking = timeoutPinBlocking;
        logger.log((Priority)Level.INFO, (Object)("Timeout noblocking do pin configurado para " + timeoutPinNoblocking));
        ProtocoloBibliotecaCompartilhada.timeoutPinNoblocking = timeoutPinNoblocking;
    }

    public int testeOpenSerial(char[] versao, char[] porta) {
        return this.testSerial(versao, ProtocoloBibliotecaCompartilhada.isBibliotecaEMV() ? 1 : 0, porta);
    }

    public native int testSerial(char[] var1, int var2, char[] var3);

    public int openSerial(char[] versao, char[] porta) {
        return this.openSerial(versao, tipoBibliotecaPinpad, porta);
    }

    public native int openSerial(char[] var1, int var2, char[] var3);

    public native int open(char[] var1);

    public native int close(char[] var1, char[] var2);

    public native int closeSerial(char[] var1);

    public native int display(char[] var1, char[] var2);

    public native int abort(char[] var1);

    public native int startGetPIN(char[] var1, char[] var2);

    public native int startGetCard(char[] var1, char[] var2, char[] var3);

    public native int resumeGetCard(char[] var1);

    public native SaidaGetCardEMV getCard(char[] var1, char[] var2);

    public native int startGoOnChip(char[] var1, char[] var2, char[] var3, char[] var4);

    public native int startRemoveCard(char[] var1, char[] var2);

    public native int startGetKey(char[] var1);

    public native int getKey(char[] var1);

    public native SaidaGoOnChipEMV goOnChip(char[] var1);

    public native SaidaFinishChipEMV finishChip(char[] var1, char[] var2, char[] var3);

    public native SaidaGetPinEMV getPin(char[] var1);

    public native SaidaGetDUKPTEMV getDUKPT(char[] var1, char[] var2);

    public native SaidaEncryptBufferEMV encryptBuffer(char[] var1, char[] var2);

    public native SaidaEncryptBufferEMV encryptBuffer2(char[] var1, int var2, int var3, char[] var4, char[] var5);

    public SaidaGetInfoEMV getInfoEMV(char[] versao, char[] psInput) {
        if (this.saidaGetInfoEMV == null) {
            this.saidaGetInfoEMV = this.getInfo(versao, psInput);
        }
        return this.saidaGetInfoEMV;
    }

    public SaidaGetInfoVisanetEMV getInfoCieloEMV(char[] versao) {
        if (this.saidaGetInfoCielo == null) {
            this.saidaGetInfoCielo = this.getInfoVisanet(versao);
        }
        return this.saidaGetInfoCielo;
    }

    public SaidaGetInfoRedecardEMV getInfoRedecardEMV(char[] versao) {
        if (this.saidaGetInfoRedecard == null) {
            this.saidaGetInfoRedecard = this.getInfoRedecard(versao);
        }
        return this.saidaGetInfoRedecard;
    }

    public DadosGetInfoRedeEMV getInfoPorRedeEMV(int rede, char[] versao) {
        Integer redeInteger = new Integer(rede);
        DadosGetInfoRedeEMV saidaGetInfoRedeEMV = (DadosGetInfoRedeEMV)this.mapGetInfoRedeEMV.get(redeInteger);
        if (saidaGetInfoRedeEMV == null) {
            saidaGetInfoRedeEMV = this.getInfoRedeEMV(rede, versao);
            this.mapGetInfoRedeEMV.put(redeInteger, saidaGetInfoRedeEMV);
        }
        return saidaGetInfoRedeEMV;
    }

    private native SaidaGetInfoEMV getInfo(char[] var1, char[] var2);

    private native SaidaGetInfoVisanetEMV getInfoVisanet(char[] var1);

    private native SaidaGetInfoRedecardEMV getInfoRedecard(char[] var1);

    private native DadosGetInfoRedeEMV getInfoRedeEMV(int var1, char[] var2);

    public native SaidaRemoveCardEMV removeCard(char[] var1);

    public native int tableLoadInit(char[] var1, char[] var2);

    public native int tableLoadEnd(char[] var1);

    public native SaidaGetTimeStampEMV getTimeStamp(char[] var1, char[] var2);

    public native int tableLoadRec(char[] var1, char[] var2);

    public native SaidaDefineWKPANEMV defineWKPAN(char[] var1, char[] var2);

    public native SaidaChipDirectEMV chipDirect(char[] var1, char[] var2);

    public native int startGenericCmd(char[] var1, char[] var2);

    public native SaidaGenericCmdEMV genericCmd(char[] var1);

    public native void setPPTimeout(char[] var1, int var2, int var3, int var4);

    public native int changeParameter(char[] var1, char[] var2);

    public static ProtocoloBibliotecaCompartilhada getInstancia(String porta) {
        if (instancia != null && ProtocoloBibliotecaCompartilhada.getPortaSerial().equals(ProtocoloBibliotecaCompartilhada.formatPortaSerial(porta))) {
            return instancia;
        }
        logger.info((Object)("protocolo biblioteca compartilhada na porta: " + porta));
        instancia = new ProtocoloBibliotecaCompartilhada(porta);
        return instancia;
    }

    public static void finaliza() {
        instancia = null;
    }

    private static String formatPortaSerial(String porta) {
        return porta;
    }

    private static String getPortaSerial() {
        return portaSerial;
    }

    public static String retornaMensagemErro(int codErro) {
        String mensagem = "";
        switch (codErro) {
            case 0: {
                mensagem = "PP_OK";
                break;
            }
            case 1: {
                mensagem = "PP_PROCESSING";
                break;
            }
            case 2: {
                mensagem = "PP_NOTIFY";
                break;
            }
            case 4: {
                mensagem = "PP_F1";
                break;
            }
            case 5: {
                mensagem = "PP_F2";
                break;
            }
            case 6: {
                mensagem = "PP_F3";
                break;
            }
            case 7: {
                mensagem = "PP_F4";
                break;
            }
            case 8: {
                mensagem = "PP_BACKSP";
                break;
            }
            case 10: {
                mensagem = "PP_INVCALL";
                break;
            }
            case 11: {
                mensagem = "PP_INVPARM";
                break;
            }
            case 12: {
                mensagem = "PP_TIMEOUT";
                break;
            }
            case 13: {
                mensagem = "PP_CANCEL";
                break;
            }
            case 14: {
                mensagem = "PP_ALREADYOPEN";
                break;
            }
            case 15: {
                mensagem = "PP_NOTOPEN";
                break;
            }
            case 16: {
                mensagem = "PP_EXECERR";
                break;
            }
            case 17: {
                mensagem = "PP_INVMODEL";
                break;
            }
            case 18: {
                mensagem = "PP_NOFUNC";
                break;
            }
            case 20: {
                mensagem = "PP_TABEXP";
                break;
            }
            case 21: {
                mensagem = "PP_TABERR";
                break;
            }
            case 22: {
                mensagem = "PP_NOAPPLIC";
                break;
            }
            case 30: {
                mensagem = "PP_PORTERR";
                break;
            }
            case 31: {
                mensagem = "PP_COMMERR";
                break;
            }
            case 32: {
                mensagem = "PP_UNKNOWNSTAT";
                break;
            }
            case 33: {
                mensagem = "PP_RSPERR";
                break;
            }
            case 34: {
                mensagem = "PP_COMMTOUT";
                break;
            }
            case 40: {
                mensagem = "PP_INTERR";
                break;
            }
            case 41: {
                mensagem = "PP_MCDATAERR";
                break;
            }
            case 42: {
                mensagem = "PP_ERRPIN";
                break;
            }
            case 43: {
                mensagem = "PP_NOCARD";
                break;
            }
            case 44: {
                mensagem = "PP_PINBUSY";
                break;
            }
            case 50: {
                mensagem = "PP_SAMERR";
                break;
            }
            case 51: {
                mensagem = "PP_NOSAM";
                break;
            }
            case 52: {
                mensagem = "PP_SAMINV";
                break;
            }
            case 60: {
                mensagem = "PP_DUMBCARD";
                break;
            }
            case 61: {
                mensagem = "PP_ERRCARD";
                break;
            }
            case 62: {
                mensagem = "PP_CARDINV";
                break;
            }
            case 63: {
                mensagem = "PP_CARDBLOCKED";
                break;
            }
            case 64: {
                mensagem = "PP_CARDNAUTH";
                break;
            }
            case 65: {
                mensagem = "PP_CARDEXPIRED";
                break;
            }
            case 66: {
                mensagem = "PP_CARDERRSTRUCT";
                break;
            }
            case 67: {
                mensagem = "PP_CARDINVALIDAT";
                break;
            }
            case 68: {
                mensagem = "PP_CARDPROBLEMS";
                break;
            }
            case 69: {
                mensagem = "PP_CARDINVDATA";
                break;
            }
            case 70: {
                mensagem = "PP_CARDAPPNAV";
                break;
            }
            case 71: {
                mensagem = "PP_CARDAPPNAUT";
                break;
            }
            case 72: {
                mensagem = "PP_NOBALANCE";
                break;
            }
            case 73: {
                mensagem = "PP_LIMITEXC";
                break;
            }
            case 74: {
                mensagem = "PPC_CARDNOTEFFECT";
                break;
            }
            case 75: {
                mensagem = "PPC_VCINVCURR";
            }
        }
        return mensagem;
    }

    public static void testaRetorno(Periferico p, int retorno) throws ExcecaoPerifericos {
        if (retorno != 0 && retorno != 1 && retorno != 2 && retorno != 13 && retorno != 20) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("retorno da biblioteca compartilhada = " + retorno));
            }
            throw new ExcecaoPerifericos(p, ProtocoloBibliotecaCompartilhada.retornaMensagemErro(retorno), retorno);
        }
    }

    public void testarComunicacao() throws ExcecaoPerifericos {
        if (!this.comunicacaoAberta) {
            if (ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                this.setPPTimeout(versaoBiblioteca.toCharArray(), timeoutPinDefault, timeoutPinBlocking, timeoutPinNoblocking);
            }
            int retorno = this.openSerial(versaoBiblioteca.toCharArray(), portaSerial.toCharArray());
            logger.info((Object)("retorno testeOpenSerial = " + retorno));
            if (retorno == 0) {
                if (ProtocoloBibliotecaCompartilhada.isBibliotecaEMV() && !libBBCompAberta) {
                    retorno = this.open(versaoBiblioteca.toCharArray());
                    if (retorno != 0) {
                        logger.error((Object)("n\u00e3o foi poss\u00edvel abrir biblioteca compartilhada. retorno = " + retorno));
                        throw new ExcecaoPerifericos(null, "Erro ao abrir conex\u00e3o com biblioteca compartilhada");
                    }
                    libBBCompAberta = true;
                }
            } else {
                logger.error((Object)("n\u00e3o foi poss\u00edvel abrir comunica\u00e7\u00e3o com pin. retorno = " + retorno));
                if (retorno == -500) {
                    throw new ExcecaoBibliotecaCompartilhada(null, "Pin sem biblioteca compartilhada!");
                }
                throw new ExcecaoPerifericos(null, "Erro ao abrir conex\u00e3o com perif\u00e9rico!");
            }
            this.comunicacaoAberta = true;
        } else {
            logger.warn((Object)"comunica\u00e7\u00e3o com pin j\u00e1 estabelecida");
        }
    }

    public void abrirComunicacao() throws ExcecaoPerifericos {
        if (!this.comunicacaoAberta) {
            if (ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                this.setPPTimeout(versaoBiblioteca.toCharArray(), timeoutPinDefault, timeoutPinBlocking, timeoutPinNoblocking);
            }
            int retorno = this.openSerial(versaoBiblioteca.toCharArray(), portaSerial.toCharArray());
            logger.info((Object)("retorno openSerial = " + retorno));
            if (retorno == 0) {
                if (ProtocoloBibliotecaCompartilhada.isBibliotecaEMV()) {
                    boolean libBBCompAbertaComunicacaoSegura = libBBCompAberta;
                    if (!libBBCompAberta) {
                        SaidaGetInfoEMV result;
                        this.saidaGetInfoEMV = null;
                        this.saidaGetInfoRedecard = null;
                        this.saidaGetInfoCielo = null;
                        retorno = this.open(versaoBiblioteca.toCharArray());
                        logger.info((Object)("retorno open = " + retorno));
                        if (retorno != 0) {
                            logger.error((Object)("n\u00e3o foi poss\u00edvel abrir biblioteca compartilhada. retorno = " + retorno));
                            throw new ExcecaoPerifericos(null, "Erro ao abrir conex\u00e3o com biblioteca compartilhada");
                        }
                        libBBCompAberta = true;
                        char[] versaoBibComp = "".toCharArray();
                        this.saidaGetInfoEMV = result = this.getInfo(versaoBiblioteca.toCharArray(), versaoBibComp);
                        this.saidaGetInfoCielo = this.getInfoCieloEMV(versaoBibComp);
                        this.saidaGetInfoRedecard = this.getInfoRedecardEMV(versaoBibComp);
                        int rede = 4;
                        this.mapGetInfoRedeEMV.put(new Integer(rede), this.getInfoRedeEMV(4, versaoBibComp));
                        logger.info((Object)("retorno getInfo = " + result.getRetorno()));
                        logger.info((Object)("Vers\u00e3o da especifica\u00e7\u00e3o no pinpad: (" + result.getVersaoEspecificacao() + ")"));
                        BigDecimal versao = null;
                        try {
                            versao = new BigDecimal(result.getVersaoEspecificacao());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (comunicacaoSeguraHabilitada && versao != null && versao.compareTo(new BigDecimal("1.07")) > -1) {
                            ProtocoloBibliotecaCompartilhada.setComunicacaoSegura(true);
                        } else {
                            if (comunicacaoSeguraHabilitada) {
                                logger.log((Priority)Level.WARN, (Object)"Comunica\u00e7\u00e3o segura habilitada, por\u00e9m a vers\u00e3o do pinpad n\u00e3o permite comunica\u00e7\u00e3o segura pela porta serial");
                            } else {
                                logger.log((Priority)Level.WARN, (Object)"Comunica\u00e7\u00e3o segura pela porta serial desabilitada");
                            }
                            ProtocoloBibliotecaCompartilhada.setComunicacaoSegura(false);
                        }
                        if (ProtocoloBibliotecaCompartilhada.isComunicacaoSegura() && !libBBCompAbertaComunicacaoSegura) {
                            try {
                                String wkpan;
                                logger.log((Priority)Level.INFO, (Object)"Habilitando comunica\u00e7\u00e3o segura...");
                                String rsaPublicKey = KeyFactory.getRsaPublicKey();
                                logger.log((Priority)Level.DEBUG, (Object)"Definindo WKPAN...");
                                SaidaDefineWKPANEMV saidaDefineWKPANEMV = this.defineWKPAN(versaoBiblioteca.toCharArray(), rsaPublicKey.toCharArray());
                                logger.log((Priority)Level.DEBUG, (Object)"WKPAN definida");
                                ProtocoloBibliotecaCompartilhada.wkpan = wkpan = saidaDefineWKPANEMV.getWKPANCertificadoZonado(KeyFactory.getPenPassword());
                            }
                            catch (Exception e) {
                                logger.log((Priority)Level.ERROR, (Object)"Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad, fechando a comunica\u00e7\u00e3o...");
                                this.fecharComunicacao(versaoBiblioteca.toCharArray(), portaSerial.toCharArray());
                                throw new ExcecaoPerifericos(null, "Erro ao habilitar a comunica\u00e7\u00e3o segura com o pinpad: " + e.getMessage());
                            }
                        }
                    }
                }
            } else {
                logger.error((Object)("n\u00e3o foi poss\u00edvel abrir comunica\u00e7\u00e3o com pin. retorno = " + retorno));
                if (retorno == -500) {
                    throw new ExcecaoBibliotecaCompartilhada(null, "Pin sem biblioteca compartilhada!");
                }
                throw new ExcecaoPerifericos(null, "Erro ao abrir conex\u00e3o com perif\u00e9rico!");
            }
            this.comunicacaoAberta = true;
        } else {
            logger.warn((Object)"comunica\u00e7\u00e3o com pin j\u00e1 estabelecida");
        }
    }

    public void resetSerial() {
        this.comunicacaoAberta = false;
        libBBCompAberta = false;
    }

    public void fecharComunicacao() throws ExcecaoPerifericos {
        this.fecharComunicacao(true, versaoBiblioteca.toCharArray(), "Auttar".toCharArray());
    }

    public void fecharComunicacao(char[] versao, char[] msgPrompt) throws ExcecaoPerifericos {
        this.fecharComunicacao(true, versao, msgPrompt);
    }

    public void fecharComunicacao(boolean liberaBBComp, char[] versao, char[] msgPrompt) throws ExcecaoPerifericos {
        int retorno = 0;
        if (liberaBBComp) {
            retorno = this.close(versao, msgPrompt);
            libBBCompAberta = false;
            logger.info((Object)("retorno close = " + retorno));
        }
        this.closeSerial(versao);
        logger.info((Object)("retorno closeSerial = " + retorno));
        this.comunicacaoAberta = false;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"comunica\u00e7\u00e3o com pin finalizada");
        }
    }

    public boolean isComunicacaoAberta() {
        return this.comunicacaoAberta;
    }

    public String getWkpan() {
        return wkpan;
    }

    public static boolean isLibBBCompAberta() {
        return libBBCompAberta;
    }

    public static void main(String[] args) {
    }

    static {
        System.loadLibrary("ProtocoloBibliotecaCompartilhada");
        redeAdquirente = 0;
        tipoBibliotecaPinpad = 1;
        comunicacaoSegura = false;
        comunicacaoSeguraHabilitada = false;
        timeoutPinDefault = 0;
        timeoutPinBlocking = 0;
        timeoutPinNoblocking = 0;
        versaoBiblioteca = "1000";
        instancia = null;
    }
}

