/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.generic;

import com.csi.ctfclient.tools.devices.Display;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.util.StringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class JPanelDisplay
extends JPanel
implements Display {
    private static final long serialVersionUID = 1L;
    private byte[] bufferedText;
    private int numColunas;
    private int numLinhas = 0;
    private int posAtual = 0;
    private JTextArea textArea;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        Container container = frame.getContentPane();
        final JPanelDisplay d = new JPanelDisplay(15, 25, new Color(193, 193, 193));
        JPanel panel = new JPanel();
        panel.setBackground(new Color(153, 153, 153));
        panel.add(d);
        container.add(panel);
        container.setBackground(new Color(153, 153, 153));
        ImageIcon icon = new ImageIcon("imagens/status.png");
        JLabel label = new JLabel(icon);
        label.setOpaque(false);
        container.add((Component)label, "South");
        frame.pack();
        frame.setVisible(true);
        Thread thread = new Thread(){

            public void run() {
                try {
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo em 1,1...");
                    d.imprimeEm(1, 1, "Mensagem...");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo na posicao atual...");
                    d.imprime("continuada");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("ImprimeBackspace...");
                    d.imprimeBackSpace();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("ImprimeBackspace...");
                    d.imprimeBackSpace();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Posicao setada para 0,0...");
                    d.posicionaCursor(0, 0);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo na posicao atual...");
                    d.imprime("Outra Mensagem...");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Wrapping da primeira para a segunda linha");
                    d.imprime("1234567890123456789012345");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo outra coisa...");
                    d.imprime("outra coisa");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Wrapping no final");
                    d.imprimeEm(1, 10, "123456789012345");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo outra coisa...");
                    d.imprimeEm(0, 0, "outra coisa");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Wrapping na linha e no final");
                    d.imprimeEm(0, 0, "1234567890123456789012345678901234567890pulou");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo outra coisa...");
                    d.imprimeEm(0, 0, "outra coisa");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Mais um teste");
                    d.posicionaCursor(0, 18);
                    d.imprime("1234567890123456789012345");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Escrevendo outra coisa...");
                    d.imprime("outra coisa");
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    System.out.println("Limpando display...");
                    d.limpa();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    d.liberaRecursos();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        thread.start();
    }

    public JPanelDisplay(String linha, String coluna) {
        this(Integer.parseInt(linha.trim()), Integer.parseInt(coluna.trim()));
    }

    public JPanelDisplay(int linha, int coluna) {
        this(linha, coluna, new Color(153, 153, 153));
    }

    public JPanelDisplay(int linha, int coluna, Color background) {
        this.numLinhas = linha;
        this.numColunas = coluna;
        this.bufferedText = new byte[this.numLinhas * this.numColunas];
        Arrays.fill(this.bufferedText, (byte)32);
        this.setBackground(background);
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.builtEditorPanel(linha, coluna));
        this.textArea.setOpaque(false);
        FontMetrics fm = this.textArea.getFontMetrics(this.textArea.getFont());
        int comp = (this.numColunas + 1) * fm.charWidth('\u00c7');
        this.textArea.setPreferredSize(new Dimension(comp, fm.getHeight() * this.numLinhas));
        this.atualizaDisplay();
    }

    private void atualizaDisplay() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.numLinhas; ++i) {
            stringBuffer.append(new String(this.bufferedText, i * this.numColunas, this.numColunas) + "\n");
        }
        this.textArea.setText(stringBuffer.toString());
    }

    private JTextArea builtEditorPanel(int rows, int coluns) {
        if (this.textArea == null) {
            this.textArea = new JTextArea(rows, coluns);
            this.textArea.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.textArea.setFocusable(false);
            this.textArea.setEditable(false);
            this.textArea.setFont(new Font("Courier new", 0, 12));
        }
        return this.textArea;
    }

    public void desabilita() throws ExcecaoPerifericos {
        this.textArea.setVisible(false);
    }

    public int getColunaAtual() {
        return this.posAtual % this.numColunas;
    }

    public int getLinhaAtual() {
        return this.posAtual / this.numColunas;
    }

    public int getNumColunas() {
        return this.numColunas;
    }

    public int getNumLinhas() {
        return this.numLinhas;
    }

    public String getTexto() throws ExcecaoPerifericos {
        return new String(this.bufferedText);
    }

    public void habilita() throws ExcecaoPerifericos {
        this.limpa();
    }

    public void imprime(String texto) throws ExcecaoPerifericos {
        int tamStr = texto.length();
        int qtdeChrs = this.numColunas * this.numLinhas;
        if (this.posAtual > qtdeChrs) {
            return;
        }
        if (this.posAtual + tamStr > qtdeChrs) {
            tamStr = qtdeChrs - this.posAtual;
            texto = texto.substring(0, tamStr);
        }
        byte[] txtChrs = StringUtil.asciiToByteArray(texto);
        System.arraycopy(txtChrs, 0, this.bufferedText, this.posAtual, tamStr);
        this.posAtual += tamStr;
        this.atualizaDisplay();
    }

    public void imprimeBackSpace() throws ExcecaoPerifericos {
        if (this.posAtual > 0) {
            this.bufferedText[--this.posAtual] = 32;
        }
        this.atualizaDisplay();
    }

    public void imprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        this.posicionaCursor(linha, coluna);
        this.imprime(texto);
    }

    public void liberaRecursos() throws ExcecaoPerifericos {
    }

    public void limpa() throws ExcecaoPerifericos {
        this.posAtual = 0;
        for (int i = 0; i < this.numLinhas * this.numColunas; ++i) {
            this.bufferedText[i] = 32;
        }
        this.atualizaDisplay();
    }

    public void limpaEImprime(String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprime(texto);
    }

    public void limpaEImprimeEm(int linha, int coluna, String texto) throws ExcecaoPerifericos {
        this.limpa();
        this.imprimeEm(linha, coluna, texto);
    }

    public void posicionaCursor(int linha, int coluna) throws ExcecaoPerifericos {
        if (linha >= 0 && linha < this.numLinhas && coluna >= 0 && coluna < this.numColunas) {
            this.posAtual = linha * this.numColunas + coluna;
        }
    }
}

