/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef;

import com.csi.ctfclient.tools.devices.EntradaDeDados;
import com.csi.ctfclient.tools.devices.ExcecaoPerifericos;
import com.csi.ctfclient.tools.devices.postef.PinPadRemoto;
import com.csi.ctfclient.tools.devices.postef.PinPadRemotoHandler;
import com.csi.ctfclient.tools.devices.postef.PreVendaHandler;
import com.csi.ctfclient.tools.devices.postef.Protocolo;
import com.csi.ctfclient.tools.devices.postef.ProtocoloBuilder;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import java.io.ByteArrayOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class PosTEF
implements PinPadRemoto {
    private static Logger log = CTFClientLogger.getPeriferico();
    private static PosTEF posTEF;
    private boolean habilitado = false;
    private EntradaDeDados entradaDeDados = null;
    private PinPadRemotoHandler pinpadRemotoHandler;
    private ProtocoloBuilder protocoloBuilder;
    private String timeStampPinpadRemoto;

    public static PosTEF getInstance() {
        if (posTEF == null) {
            posTEF = new PosTEF();
        }
        return posTEF;
    }

    public synchronized void executa(ProtocoloBuilder protocoloBuilder, EntradaDeDados entradaDeDados) {
        this.entradaDeDados = entradaDeDados;
        this.protocoloBuilder = protocoloBuilder;
    }

    public void reset() {
        this.protocoloBuilder = null;
        this.setTimeStampPinpadRemoto(null);
    }

    public String getTimeStampPinpadRemoto() {
        return this.timeStampPinpadRemoto;
    }

    public void setTimeStampPinpadRemoto(String timeStampPinpadRemoto) {
        this.timeStampPinpadRemoto = timeStampPinpadRemoto;
    }

    private synchronized void processaPOSTefRemoto(Protocolo protocolo, Socket socket) {
        if (this.protocoloBuilder != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyHHmmssSSS");
            this.timeStampPinpadRemoto = dateFormat.format(new Date());
            this.pinpadRemotoHandler = new PinPadRemotoHandler(socket, protocolo, this.protocoloBuilder, this.timeStampPinpadRemoto);
            this.protocoloBuilder = null;
            this.pinpadRemotoHandler.start();
        } else {
            try {
                log.info((Object)"nao existe transacao para processamento remoto.");
                Protocolo.Header header = protocolo.getHeader();
                ProtocoloBuilder builder = new ProtocoloBuilder(header.getVersao(), header.getCodigoTransacao()).setSubCampo("7000", "20").setSubCampo("7300", "5398");
                socket.getOutputStream().write(builder.build());
                socket.getOutputStream().flush();
                socket.close();
            }
            catch (Exception e) {
                log.error((Object)"erro no processamento da resposta de transacao invalida para operacao 904.", (Throwable)e);
            }
        }
    }

    private synchronized void processaFinalizaVenda(Protocolo protocolo, Socket socket) {
        PreVendaHandler preVendaHandler = new PreVendaHandler(socket, protocolo, this, this.entradaDeDados);
        preVendaHandler.start();
    }

    public void habilita(final int porta) {
        Thread t = new Thread(){

            public void run() {
                try {
                    ServerSocket server = new ServerSocket(porta);
                    PosTEF.this.habilitado = true;
                    while (PosTEF.this.habilitado) {
                        Socket socket = server.accept();
                        log.debug((Object)"socket recebido...");
                        PosTEF.this.processaRequisicao(socket);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        t.start();
    }

    private void processaRequisicao(Socket socket) {
        try {
            try {
                Protocolo.Header header = Protocolo.header(socket.getInputStream());
                log.info((Object)("mensagem recebida: " + header));
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[header.getTamanhoMensagem()];
                int count = 0;
                for (int i = 0; i < header.getTamanhoMensagem(); i += count) {
                    count = socket.getInputStream().read(data);
                    buffer.write(data, 0, count);
                }
                String msg = new String(buffer.toByteArray());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("dados recebidos: " + msg));
                }
                Protocolo protocolo = Protocolo.build(header, msg);
                if (header.getCodigoTransacao() == 904) {
                    this.processaPOSTefRemoto(protocolo, socket);
                } else if (header.getCodigoTransacao() == 906) {
                    this.processaFinalizaVenda(protocolo, socket);
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"erro no processamento do protocolo. ", (Throwable)e);
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isHabilitado() {
        return this.habilitado;
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        System.out.println(calendar.getTime());
        calendar.set(5, calendar.get(5) - 15);
        System.out.println(calendar.getTime());
    }

    public void desabilita() throws ExcecaoPerifericos {
        this.habilitado = false;
    }
}

