/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.devices.postef;

import com.csi.ctfclient.tools.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;

public class Protocolo {
    public static final String VERSAO_01_00 = "0100";
    public static final String VERSAO = "0100";
    private Header header;
    private String message;
    private int modeloIntegracao;
    private Long pontoVenda;
    private Date dataAbertura;
    private boolean pinpadRemoto;
    private int codigoTransacao;
    private int codigoRetorno = -1;
    private String codigoTransacaoCTF;
    private BigDecimal valorTransacao;
    private int numeroParcelas;
    private String codigoAutorizadora;
    private String codigoRespAutorizadora;
    private String documento;
    private int tipoDocumentoCliente;
    private String documentoCliente;
    private int nsuCTF;
    private int taxaServico;
    private String timeStampTransacao;
    private long nsuAutorizadora;
    private String codigoAprovacao;
    private String mac;
    private String cnpj;
    private String codigoErro;
    private String descricaoTransacao;
    private String cupomCliente;
    private String cupomEstabelecimento;
    private String cupomClienteReimpressao;
    private String cupomEstabelecimentoReimpressao;
    private String nomeAutorizadora;
    private String codigoVan;
    private String nomeVan;
    private String codigoInstFinanceira;
    private String nomeInstFinanceira;
    private String dataTransacao;
    private String horaTransacao;
    private String logomarca;
    private String cpf;
    private String cupomReduzido;
    private String display;
    private String nomeBandeira;
    private String codigoTerminal;
    private String nomeRedeAdquirente;

    public Protocolo() {
    }

    public Protocolo(Header header) {
        this.header = header;
    }

    public Header getHeader() {
        return this.header;
    }

    public String getMessage() {
        return this.message;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public int getCodigoRetorno() {
        return this.codigoRetorno;
    }

    protected void setCodigoRetorno(int codigoRetorno) {
        this.codigoRetorno = codigoRetorno;
    }

    public int getModeloIntegracao() {
        return this.modeloIntegracao;
    }

    public boolean isPinpadRemoto() {
        return this.pinpadRemoto;
    }

    protected void setPinpadRemoto(boolean pinpadRemoto) {
        this.pinpadRemoto = pinpadRemoto;
    }

    protected void setModeloIntegracao(int modoIntegracao) {
        this.modeloIntegracao = modoIntegracao;
    }

    protected void setCodigoTransacao(int codigoTransacao) {
        this.codigoTransacao = codigoTransacao;
    }

    public int getCodigoTransacao() {
        return this.codigoTransacao;
    }

    public Long getPontoVenda() {
        return this.pontoVenda;
    }

    protected void setPontoVenda(Long pontoVenda) {
        this.pontoVenda = pontoVenda;
    }

    public Date getDataAbertura() {
        return this.dataAbertura;
    }

    protected void setDataAbertura(Date dataAbertura) {
        this.dataAbertura = dataAbertura;
    }

    public String getCodigoTransacaoCTF() {
        return this.codigoTransacaoCTF;
    }

    protected void setCodigoTransacaoCTF(String codigoTransacaoCTF) {
        this.codigoTransacaoCTF = codigoTransacaoCTF;
    }

    public BigDecimal getValorTransacao() {
        return this.valorTransacao;
    }

    protected void setValorTransacao(BigDecimal valorTransacao) {
        this.valorTransacao = valorTransacao;
    }

    public int getNumeroParcelas() {
        return this.numeroParcelas;
    }

    protected void setNumeroParcelas(int numeroParcelas) {
        this.numeroParcelas = numeroParcelas;
    }

    public String getCodigoAutorizadora() {
        return this.codigoAutorizadora;
    }

    protected void setCodigoAutorizadora(String codigoAutorizadora) {
        this.codigoAutorizadora = codigoAutorizadora;
    }

    public String getCodigoRespAutorizadora() {
        return this.codigoRespAutorizadora;
    }

    protected void setCodigoRespAutorizadora(String codigoRespAutorizadora) {
        this.codigoRespAutorizadora = codigoRespAutorizadora;
    }

    public String getDocumento() {
        return this.documento;
    }

    public int getTipoDocumentoCliente() {
        return this.tipoDocumentoCliente;
    }

    protected void setTipoDocumentoCliente(int tipoDocumentoCliente) {
        this.tipoDocumentoCliente = tipoDocumentoCliente;
    }

    public String getDocumentoCliente() {
        return this.documentoCliente;
    }

    protected void setDocumentoCliente(String documentoCliente) {
        this.documentoCliente = documentoCliente;
    }

    protected void setDocumento(String documento) {
        this.documento = documento;
    }

    public int getTaxaServico() {
        return this.taxaServico;
    }

    protected void setTaxaServico(int taxaServico) {
        this.taxaServico = taxaServico;
    }

    public int getNsuCTF() {
        return this.nsuCTF;
    }

    protected void setNsuCTF(int nsuCTF) {
        this.nsuCTF = nsuCTF;
    }

    public String getTimeStampTransacao() {
        return this.timeStampTransacao;
    }

    protected void setTimeStampTransacao(String timeStampTransacao) {
        this.timeStampTransacao = timeStampTransacao;
    }

    public long getNsuAutorizadora() {
        return this.nsuAutorizadora;
    }

    protected void setNsuAutorizadora(long nsuAutorizadora) {
        this.nsuAutorizadora = nsuAutorizadora;
    }

    public String getCodigoAprovacao() {
        return this.codigoAprovacao;
    }

    protected void setCodigoAprovacao(String codigoAprovacao) {
        this.codigoAprovacao = codigoAprovacao;
    }

    public String getMac() {
        return this.mac;
    }

    protected void setMac(String mac) {
        this.mac = mac;
    }

    public String getCnpj() {
        return this.cnpj;
    }

    protected void setCnpj(String cnpj) {
        this.cnpj = cnpj;
    }

    public String getCodigoErro() {
        return this.codigoErro;
    }

    protected void setCodigoErro(String codigoErro) {
        this.codigoErro = codigoErro;
    }

    public String getDescricaoTransacao() {
        return this.descricaoTransacao;
    }

    protected void setDescricaoTransacao(String descricaoTransacao) {
        this.descricaoTransacao = descricaoTransacao;
    }

    public String getCupomCliente() {
        return this.cupomCliente;
    }

    protected void setCupomCliente(String cupomCliente) {
        this.cupomCliente = cupomCliente;
    }

    public String getCupomEstabelecimento() {
        return this.cupomEstabelecimento;
    }

    protected void setCupomEstabelecimento(String cupomEstabelecimento) {
        this.cupomEstabelecimento = cupomEstabelecimento;
    }

    public String getCupomClienteReimpressao() {
        return this.cupomClienteReimpressao;
    }

    protected void setCupomClienteReimpressao(String cupomClienteReimpressao) {
        this.cupomClienteReimpressao = cupomClienteReimpressao;
    }

    public String getCupomEstabelecimentoReimpressao() {
        return this.cupomEstabelecimentoReimpressao;
    }

    protected void setCupomEstabelecimentoReimpressao(String cupomEstabelecimentoReimpressao) {
        this.cupomEstabelecimentoReimpressao = cupomEstabelecimentoReimpressao;
    }

    public String getNomeAutorizadora() {
        return this.nomeAutorizadora;
    }

    protected void setNomeAutorizadora(String nomeAutorizadora) {
        this.nomeAutorizadora = nomeAutorizadora;
    }

    public String getCodigoVan() {
        return this.codigoVan;
    }

    protected void setCodigoVan(String codigoVan) {
        this.codigoVan = codigoVan;
    }

    public String getNomeVan() {
        return this.nomeVan;
    }

    protected void setNomeVan(String nomeVan) {
        this.nomeVan = nomeVan;
    }

    public String getCodigoInstFinanceira() {
        return this.codigoInstFinanceira;
    }

    protected void setCodigoInstFinanceira(String codigoInstFinanceira) {
        this.codigoInstFinanceira = codigoInstFinanceira;
    }

    public String getNomeInstFinanceira() {
        return this.nomeInstFinanceira;
    }

    protected void setNomeInstFinanceira(String nomeInstFinanceira) {
        this.nomeInstFinanceira = nomeInstFinanceira;
    }

    public String getDataTransacao() {
        return this.dataTransacao;
    }

    protected void setDataTransacao(String dataTransacao) {
        this.dataTransacao = dataTransacao;
    }

    public String getHoraTransacao() {
        return this.horaTransacao;
    }

    protected void setHoraTransacao(String horaTransacao) {
        this.horaTransacao = horaTransacao;
    }

    public String getLogomarca() {
        return this.logomarca;
    }

    protected void setLogomarca(String logomarca) {
        this.logomarca = logomarca;
    }

    public String getCpf() {
        return this.cpf;
    }

    protected void setCpf(String cpf) {
        this.cpf = cpf;
    }

    public String getCupomReduzido() {
        return this.cupomReduzido;
    }

    protected void setCupomReduzido(String cupomReduzido) {
        this.cupomReduzido = cupomReduzido;
    }

    public String getDisplay() {
        return this.display;
    }

    protected void setDisplay(String display) {
        this.display = display;
    }

    public String getNomeBandeira() {
        return this.nomeBandeira;
    }

    protected void setNomeBandeira(String nomeBandeira) {
        this.nomeBandeira = nomeBandeira;
    }

    public String getCodigoTerminal() {
        return this.codigoTerminal;
    }

    protected void setCodigoTerminal(String codigoTerminal) {
        this.codigoTerminal = codigoTerminal;
    }

    public String getNomeRedeAdquirente() {
        return this.nomeRedeAdquirente;
    }

    protected void setNomeRedeAdquirente(String nomeRedeAdquirente) {
        this.nomeRedeAdquirente = nomeRedeAdquirente;
    }

    public static byte[] formataMensagem(int transacaoCTF, String msg) {
        return Protocolo.formataMensagem("0100", transacaoCTF, msg);
    }

    public static byte[] formataMensagem(String versaoHeader, int transacaoCTF, String msg) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(2);
        buffer.append(StringUtil.sprintf("%06d", new Object[]{new Integer(msg.length())}));
        buffer.append(3);
        buffer.append(versaoHeader);
        buffer.append(StringUtil.sprintf("%03d", new Object[]{new Integer(transacaoCTF)}));
        buffer.append(msg);
        byte[] bytes = buffer.toString().getBytes();
        bytes[0] = 2;
        bytes[7] = 3;
        return bytes;
    }

    public static String formataSubcampo(int numero, String conteudo) {
        return StringUtil.sprintf("%04d%04d%s", new Object[]{new Integer(numero), new Integer(conteudo.length()), conteudo});
    }

    public static String formataSubcampo(String numero, String conteudo) {
        return StringUtil.sprintf("%04s%04d%s", new Object[]{numero, new Integer(conteudo.length()), conteudo});
    }

    public static Header header(InputStream in) throws IllegalArgumentException, IOException {
        byte[] buffer = new byte[15];
        in.read(buffer);
        if (buffer.length != 15) {
            throw new IllegalArgumentException();
        }
        String strBuffer = new String(buffer);
        return Protocolo.header(strBuffer);
    }

    public static Header header(String buffer) throws IllegalArgumentException {
        int offSet = 0;
        String tam = buffer.substring(++offSet, offSet + 6);
        offSet += 6;
        String versao = buffer.substring(++offSet, offSet + 4);
        String codigoTransacao = buffer.substring(offSet += 4, offSet + 3);
        offSet += 3;
        Header header = new Header();
        header.setTamanhoMensagem(Integer.parseInt(tam));
        header.setVersao(versao);
        header.setCodigoTransacao(Integer.parseInt(codigoTransacao));
        return header;
    }

    public static Protocolo build(Header header, String buffer) throws RuntimeException {
        try {
            int tamInt;
            Protocolo protocolo = new Protocolo(header);
            protocolo.setMessage(buffer);
            int tam = buffer.length();
            for (int pos = 0; pos < tam; pos += tamInt) {
                String codigo = buffer.substring(pos, pos + 4);
                String tamStr = buffer.substring(pos += 4, pos + 4);
                tamInt = Integer.parseInt(tamStr);
                String valor = buffer.substring(pos += 4, pos + tamInt);
                if (codigo.equals("7000")) {
                    protocolo.setCodigoRetorno(Integer.parseInt(valor));
                    continue;
                }
                if ("7001".equals(codigo)) {
                    protocolo.setCodigoTransacaoCTF(valor);
                    continue;
                }
                if ("7005".equals(codigo)) {
                    protocolo.setValorTransacao(new BigDecimal(valor).movePointLeft(2));
                    continue;
                }
                if ("7008".equals(codigo)) {
                    protocolo.setNumeroParcelas(Integer.parseInt(valor));
                    continue;
                }
                if ("7011".equals(codigo)) {
                    protocolo.setCodigoAutorizadora(valor);
                    continue;
                }
                if ("7015".equals(codigo)) {
                    protocolo.setCodigoRespAutorizadora(valor);
                    continue;
                }
                if ("7020".equals(codigo)) {
                    protocolo.setDocumento(valor);
                    continue;
                }
                if ("7025".equals(codigo)) {
                    protocolo.setTipoDocumentoCliente(Integer.parseInt(valor));
                    continue;
                }
                if ("7026".equals(codigo)) {
                    protocolo.setDocumentoCliente(valor);
                    continue;
                }
                if ("7031".equals(codigo)) {
                    protocolo.setNsuCTF(Integer.parseInt(valor));
                    continue;
                }
                if ("7079".equals(codigo)) {
                    protocolo.setTimeStampTransacao(valor);
                    continue;
                }
                if ("7034".equals(codigo)) {
                    protocolo.setTaxaServico(Integer.parseInt(valor));
                    continue;
                }
                if ("7081".equals(codigo)) {
                    protocolo.setNsuAutorizadora(Long.parseLong(valor));
                    continue;
                }
                if ("7095".equals(codigo)) {
                    protocolo.setCodigoAprovacao(valor);
                    continue;
                }
                if ("7195".equals(codigo)) {
                    protocolo.setMac(valor);
                    continue;
                }
                if ("7238".equals(codigo)) {
                    protocolo.setCnpj(valor);
                    continue;
                }
                if ("7300".equals(codigo)) {
                    protocolo.setCodigoErro(valor);
                    continue;
                }
                if ("7301".equals(codigo)) {
                    protocolo.setDescricaoTransacao(valor);
                    continue;
                }
                if ("7302".equals(codigo)) {
                    protocolo.setCupomCliente(valor);
                    continue;
                }
                if ("7303".equals(codigo)) {
                    protocolo.setCupomEstabelecimento(valor);
                    continue;
                }
                if ("7304".equals(codigo)) {
                    protocolo.setCupomClienteReimpressao(valor);
                    continue;
                }
                if ("7305".equals(codigo)) {
                    protocolo.setCupomEstabelecimentoReimpressao(valor);
                    continue;
                }
                if ("7306".equals(codigo)) {
                    protocolo.setNomeAutorizadora(valor);
                    continue;
                }
                if ("7307".equals(codigo)) {
                    protocolo.setCodigoVan(valor);
                    continue;
                }
                if ("7308".equals(codigo)) {
                    protocolo.setNomeVan(valor);
                    continue;
                }
                if ("7309".equals(codigo)) {
                    protocolo.setCodigoInstFinanceira(valor);
                    continue;
                }
                if ("7310".equals(codigo)) {
                    protocolo.setNomeInstFinanceira(valor);
                    continue;
                }
                if ("7311".equals(codigo)) {
                    protocolo.setDataTransacao(valor);
                    continue;
                }
                if ("7312".equals(codigo)) {
                    protocolo.setHoraTransacao(valor);
                    continue;
                }
                if ("7313".equals(codigo)) {
                    protocolo.setLogomarca(valor);
                    continue;
                }
                if ("7335".equals(codigo)) {
                    protocolo.setCpf(valor);
                    continue;
                }
                if ("7384".equals(codigo)) {
                    protocolo.setCupomReduzido(valor);
                    continue;
                }
                if ("7385".equals(codigo)) {
                    protocolo.setDisplay(valor);
                    continue;
                }
                if ("7389".equals(codigo)) {
                    protocolo.setNomeBandeira(valor);
                    continue;
                }
                if ("7800".equals(codigo)) {
                    protocolo.setModeloIntegracao(Integer.parseInt(valor));
                    continue;
                }
                if ("7801".equals(codigo)) {
                    protocolo.setPontoVenda(new Long(valor));
                    continue;
                }
                if ("7804".equals(codigo)) {
                    if ("1".equals(valor)) {
                        protocolo.setPinpadRemoto(true);
                        continue;
                    }
                    protocolo.setPinpadRemoto(false);
                    continue;
                }
                if ("7805".equals(codigo)) {
                    protocolo.setCodigoTransacao(Integer.parseInt(valor));
                    continue;
                }
                if (!"7900".equals(codigo)) continue;
                protocolo.setCodigoTerminal(valor);
            }
            return protocolo;
        }
        catch (Exception e) {
            throw new RuntimeException("erro no processamento do protocolo. ", e);
        }
    }

    static class Header {
        private int tamanhoMensagem;
        private String versao;
        private int codigoTransacao;

        public int getTamanhoMensagem() {
            return this.tamanhoMensagem;
        }

        protected void setTamanhoMensagem(int tamanho) {
            this.tamanhoMensagem = tamanho;
        }

        public String getVersao() {
            return this.versao;
        }

        protected void setVersao(String versao) {
            this.versao = versao;
        }

        public int getCodigoTransacao() {
            return this.codigoTransacao;
        }

        protected void setCodigoTransacao(int codigoTransacao) {
            this.codigoTransacao = codigoTransacao;
        }

        public String toString() {
            return "Header [tamanhoMensagem=" + this.tamanhoMensagem + ", versao=" + this.versao + ", codigoTransacao=" + this.codigoTransacao + "]";
        }
    }
}

