/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoHexaInvalido;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static int byteArrayToInt(byte[] bytes) {
        int result = 0;
        result |= 0xFF000000 & bytes[0] << 24;
        result |= 0xFF0000 & bytes[1] << 16;
        result |= 0xFF00 & bytes[2] << 8;
        return result |= 0xFF & bytes[3];
    }

    public static long byteArrayToLong(byte[] bytes) {
        long result = 0L;
        result |= 0xFF00000000000000L & (long)bytes[0] << 56;
        result |= 0xFF000000000000L & (long)bytes[1] << 48;
        result |= 0xFF0000000000L & (long)bytes[2] << 40;
        result |= 0xFF00000000L & (long)bytes[3] << 32;
        result |= 0xFF000000L & (long)bytes[4] << 24;
        result |= 0xFF0000L & (long)bytes[5] << 16;
        result |= 0xFF00L & (long)bytes[6] << 8;
        return result |= 0xFFL & (long)bytes[7];
    }

    public static short byteArrayToShort(byte[] bytes) {
        int result = 0;
        result |= 0xFF00 & bytes[0] << 8;
        return (short)(result |= 0xFF & bytes[1]);
    }

    public static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static byte[] intToByteArray(int valor) {
        byte[] result = new byte[4];
        for (int i = 0; i < result.length; ++i) {
            result[3 - i] = (byte)(valor & 0xFF);
            valor >>= 8;
        }
        return result;
    }

    public static byte[] longToByteArray(long valor) {
        byte[] result = new byte[8];
        for (int i = 0; i < result.length; ++i) {
            result[7 - i] = (byte)(valor & 0xFFL);
            valor >>= 8;
        }
        return result;
    }

    public static byte[] shortToByteArray(int valor) {
        byte[] result = new byte[2];
        for (int i = 0; i < result.length; ++i) {
            result[1 - i] = (byte)(valor & 0xFF);
            valor >>= 8;
        }
        return result;
    }

    public static byte[] uudecode(String b) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        while (b.charAt(i) != ';') {
            sb.append(b.charAt(i));
            ++i;
        }
        ++i;
        int tam = Integer.parseInt(sb.toString());
        byte[] result = new byte[tam];
        int[] in = new int[4];
        int[] aux = new int[3];
        int j = 0;
        while (i < b.length()) {
            in[0] = b.charAt(i) - 50;
            in[1] = b.charAt(i + 1) - 50;
            in[2] = b.charAt(i + 2) - 50;
            in[3] = b.charAt(i + 3) - 50;
            aux[0] = in[0] << 2 | (in[1] & 0x30) >> 4;
            aux[1] = (in[1] & 0xF) << 4 | (in[2] & 0x3C) >> 2;
            aux[2] = (in[2] & 3) << 6 | in[3];
            for (int k = 0; k < 3; ++k) {
                if (j >= tam) continue;
                result[j++] = (byte)aux[k];
            }
            i += 4;
        }
        return result;
    }

    public static String uuencode(byte[] b) {
        StringBuffer sb = new StringBuffer(b.length * 4 / 3);
        sb.append(b.length);
        sb.append(';');
        byte[] in = new byte[3];
        char[] out = new char[4];
        int[] aux = new int[4];
        for (int i = 0; i < b.length; i += 3) {
            in[0] = b[i];
            in[1] = i + 1 < b.length ? b[i + 1] : 32;
            in[2] = i + 2 < b.length ? b[i + 2] : 32;
            aux[0] = (in[0] & 0xFC) >> 2;
            aux[1] = (in[0] & 3) << 4 | (in[1] & 0xF0) >> 4;
            aux[2] = (in[1] & 0xF) << 2 | (in[2] & 0xC0) >> 6;
            aux[3] = in[2] & 0x3F;
            for (int j = 0; j < 4; ++j) {
                out[j] = (char)(50 + aux[j]);
            }
            sb.append(out);
        }
        return sb.toString();
    }

    public static boolean getBit(byte[] bitMap, int index) throws ArrayIndexOutOfBoundsException {
        return (bitMap[index / 8] & 1 << 7 - index % 8) != 0;
    }

    public static void setBit(byte[] bitMap, int index, boolean value) throws ArrayIndexOutOfBoundsException {
        int i = index / 8;
        int mask = 1 << 7 - index % 8;
        if (value) {
            int n = i;
            bitMap[n] = (byte)(bitMap[n] | mask);
        } else {
            int n = i;
            bitMap[n] = (byte)(bitMap[n] & ~mask);
        }
    }

    private static int hexDigitValue(char c) throws ExcecaoHexaInvalido {
        int retorno = 0;
        if (c >= '0' && c <= '9') {
            retorno = (byte)c - 48;
        } else if (c >= 'A' && c <= 'F') {
            retorno = (byte)c - 55;
        } else if (c >= 'a' && c <= 'f') {
            retorno = (byte)c - 87;
        } else {
            throw new ExcecaoHexaInvalido();
        }
        return retorno;
    }

    public static byte hexToByte(String hexa) throws ExcecaoHexaInvalido {
        if (hexa == null) {
            throw new ExcecaoHexaInvalido();
        }
        if (hexa.length() != 2) {
            throw new ExcecaoHexaInvalido();
        }
        byte[] b = hexa.getBytes();
        byte valor = (byte)(ByteUtil.hexDigitValue((char)b[0]) * 16 + ByteUtil.hexDigitValue((char)b[1]));
        return valor;
    }

    public static byte[] hexToByteArray(String hexa) throws ExcecaoHexaInvalido {
        if (hexa == null) {
            throw new ExcecaoHexaInvalido();
        }
        if (hexa.length() % 2 != 0) {
            throw new ExcecaoHexaInvalido();
        }
        int tamArray = hexa.length() / 2;
        byte[] retorno = new byte[tamArray];
        for (int i = 0; i < tamArray; ++i) {
            retorno[i] = ByteUtil.hexToByte(hexa.substring(i * 2, i * 2 + 2));
        }
        return retorno;
    }

    public static void main(String[] args) {
        byte[] bytes = new byte[]{3, 64, 65, -1};
        System.out.println("String = " + ByteUtil.byteArrayToHex(bytes));
    }

    public static String byteArrayToHex(byte[] bytes) {
        String retorno = "";
        if (bytes == null || bytes.length == 0) {
            return retorno;
        }
        for (int i = 0; i < bytes.length; ++i) {
            int d1;
            byte valor;
            int d2 = (valor & 0xF0) >> 4;
            retorno = retorno + (char)(d2 += d2 < 10 ? 48 : 55) + (char)(d1 += (d1 = (valor = bytes[i]) & 0xF) < 10 ? 48 : 55);
        }
        return retorno;
    }

    public static String byteToHex(byte valor) {
        int d1;
        int d2 = (valor & 0xF0) >> 4;
        String ret = "" + (char)(d2 += d2 < 10 ? 48 : 55) + (char)(d1 += (d1 = valor & 0xF) < 10 ? 48 : 55);
        return ret;
    }

    public static byte[] copyOfRange(byte[] original, int from, int to) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        byte[] copy = new byte[newLength];
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

