/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import java.io.Serializable;
import java.math.BigDecimal;

public class CSIBigDecimal
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int ARREDONDA = 4;
    public static final int TRUNCA = 1;
    public static final int NAO_ARREDONDA = 7;
    public static final int MONETARIO = 2;
    public static final int PERCENTUAL_SIMPLES = 2;
    public static final int PERCENTUAL_DUPLO = 4;
    public static final int QUANTIDADE = 3;
    public static final int PESO = 3;
    public static final int COMPRIMENTO = 3;
    public static final CSIBigDecimal ZERO = new CSIBigDecimal("0");
    public static final CSIBigDecimal UM = new CSIBigDecimal("1");
    public static final CSIBigDecimal DEZ = new CSIBigDecimal("10");
    public static final CSIBigDecimal CEM = new CSIBigDecimal("100");
    public static final int DECIMAIS_DIVISAO_NAO_ARREDONDA = 15;
    private String representacaoInterna;
    private transient BigDecimal numero = null;

    private CSIBigDecimal() {
    }

    public CSIBigDecimal(long val, int scale) throws ArithmeticException {
        if (scale < 0) {
            throw new ArithmeticException();
        }
        try {
            BigDecimal bd = new BigDecimal("" + val);
            bd = bd.movePointLeft(scale);
            this.Novo_CSIBigDecimal(bd);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    public CSIBigDecimal(String val) throws NumberFormatException {
        this.Novo_CSIBigDecimal(new BigDecimal(val));
    }

    public CSIBigDecimal(String val, int scale) throws NumberFormatException, ArithmeticException {
        BigDecimal bd = new BigDecimal(val);
        if (bd.scale() != scale) {
            bd = bd.setScale(scale, 4);
        }
        this.Novo_CSIBigDecimal(bd);
    }

    private CSIBigDecimal(BigDecimal val) {
        this.Novo_CSIBigDecimal(val);
    }

    public CSIBigDecimal abs() {
        return new CSIBigDecimal(this.getNumero().abs());
    }

    public CSIBigDecimal add(CSIBigDecimal val) {
        return new CSIBigDecimal(this.getNumero().add(val.getNumero()));
    }

    public CSIBigDecimal divide(CSIBigDecimal val, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        int dp = this.getNumero().scale();
        if (roundingMode == 7) {
            roundingMode = 4;
            dp = 15;
        }
        return new CSIBigDecimal(this.getNumero().divide(val.getNumero(), dp, roundingMode));
    }

    public CSIBigDecimal divide(CSIBigDecimal val, int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        if (roundingMode == 7) {
            roundingMode = 4;
        }
        return new CSIBigDecimal(this.getNumero().divide(val.getNumero(), scale, roundingMode));
    }

    public double doubleValue() {
        return this.getNumero().doubleValue();
    }

    public boolean equals(CSIBigDecimal val) {
        return this.getNumero().compareTo(val.getNumero()) == 0;
    }

    public float floatValue() {
        return this.getNumero().floatValue();
    }

    public static final CSIBigDecimal getCem() {
        return new CSIBigDecimal("100");
    }

    public static final CSIBigDecimal getDez() {
        return new CSIBigDecimal("10");
    }

    public static CSIBigDecimal getInstance(long val, int scale) throws ArithmeticException {
        return new CSIBigDecimal(val, scale);
    }

    public static CSIBigDecimal getInstance(String val) throws ArithmeticException {
        return new CSIBigDecimal(val);
    }

    public static CSIBigDecimal getInstance(String val, int scale) throws NumberFormatException, ArithmeticException {
        return new CSIBigDecimal(val, scale);
    }

    private BigDecimal getNumero() {
        if (this.numero == null) {
            this.numero = new BigDecimal(this.representacaoInterna);
        }
        return this.numero;
    }

    public static final CSIBigDecimal getUm() {
        return new CSIBigDecimal("1");
    }

    public static final CSIBigDecimal getZero() {
        return new CSIBigDecimal("0");
    }

    public boolean greater(CSIBigDecimal val) {
        return this.getNumero().compareTo(val.getNumero()) > 0;
    }

    public boolean greaterOrEquals(CSIBigDecimal val) {
        return this.getNumero().compareTo(val.getNumero()) >= 0;
    }

    public int hashCode() {
        return this.getNumero().hashCode();
    }

    public int intValue() {
        return this.getNumero().intValue();
    }

    public boolean lesser(CSIBigDecimal val) {
        return this.getNumero().compareTo(val.getNumero()) < 0;
    }

    public boolean lesserOrEquals(CSIBigDecimal val) {
        return this.getNumero().compareTo(val.getNumero()) <= 0;
    }

    public long longValue() {
        return this.getNumero().longValue();
    }

    public CSIBigDecimal max(CSIBigDecimal val) {
        return new CSIBigDecimal(this.getNumero().max(val.getNumero()));
    }

    public CSIBigDecimal min(CSIBigDecimal val) {
        return new CSIBigDecimal(this.getNumero().min(val.getNumero()));
    }

    public CSIBigDecimal mod(CSIBigDecimal val, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        int dp = Math.max(this.getNumero().scale(), val.getNumero().scale());
        if (roundingMode == 7) {
            roundingMode = 4;
            dp = 15;
        }
        return this.mod(val, dp, roundingMode);
    }

    public CSIBigDecimal mod(CSIBigDecimal val, int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        if (roundingMode == 7) {
            roundingMode = 4;
        }
        BigDecimal n = this.getNumero().divide(val.getNumero(), roundingMode).setScale(0, 1);
        BigDecimal r = this.getNumero().subtract(n.multiply(val.getNumero()));
        return new CSIBigDecimal(r.setScale(scale, roundingMode));
    }

    public CSIBigDecimal movePointLeft(int n) {
        return new CSIBigDecimal(this.getNumero().movePointLeft(n));
    }

    public CSIBigDecimal movePointRight(int n) {
        return new CSIBigDecimal(this.getNumero().movePointRight(n));
    }

    public CSIBigDecimal multiply(CSIBigDecimal val) {
        return new CSIBigDecimal(this.getNumero().multiply(val.getNumero()));
    }

    public CSIBigDecimal multiply(CSIBigDecimal val, int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        BigDecimal bd = this.getNumero().multiply(val.getNumero());
        bd = bd.setScale(scale, roundingMode);
        return new CSIBigDecimal(bd);
    }

    public CSIBigDecimal negative() {
        return new CSIBigDecimal(this.getNumero().negate());
    }

    private void Novo_CSIBigDecimal(BigDecimal novoNumero) {
        this.numero = novoNumero;
        this.representacaoInterna = novoNumero.toString();
    }

    public CSIBigDecimal pow(CSIBigDecimal val, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        return this.pow(val, this.getNumero().scale(), roundingMode);
    }

    public CSIBigDecimal pow(CSIBigDecimal val, int scale, int roundingMode) throws ArithmeticException, IllegalArgumentException {
        double x = 0.0;
        try {
            x = Math.pow(Double.parseDouble(this.toString()), Double.parseDouble(val.toString()));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        BigDecimal bd = new BigDecimal(x);
        return new CSIBigDecimal(bd.setScale(scale, roundingMode));
    }

    public int scale() {
        return this.getNumero().scale();
    }

    public CSIBigDecimal setScale(int scale, int roundingMode) throws IllegalArgumentException, ArithmeticException {
        if (this.scale() == scale) {
            return this;
        }
        return new CSIBigDecimal(this.getNumero().setScale(scale, roundingMode));
    }

    public int signum() {
        return this.getNumero().signum();
    }

    public CSIBigDecimal subtract(CSIBigDecimal val) {
        return new CSIBigDecimal(this.getNumero().subtract(val.getNumero()));
    }

    public String toString() {
        return this.getNumero().toString();
    }

    public void touch() {
        this.representacaoInterna.toString();
    }
}

