/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util;

import com.csi.ctfclient.excecoes.ExcecaoApiAc;
import com.csi.ctfclient.info.constantes.ConstantesApiAc;
import com.csi.ctfclient.operacoes.ControladorPerifericos;
import com.csi.ctfclient.operacoes.model.PerifericoEventHandler;
import com.csi.ctfclient.operacoes.model.RegistroCriptografia;
import com.csi.ctfclient.operacoes.model.TabelaCriptografia;
import com.csi.ctfclient.tools.devices.EventoDispositivoEntrada;
import com.csi.ctfclient.tools.devices.EventoTeclado;
import com.csi.ctfclient.tools.devices.display.LayoutDisplay;
import com.csi.ctfclient.tools.devices.emv.EventoPinEMV;
import com.csi.ctfclient.tools.devices.emv.PinEMV;
import com.csi.ctfclient.tools.devices.emvfull.BibliotecaPinpad;
import com.csi.ctfclient.tools.util.CriptografiaUtil;
import com.csi.ctfclient.tools.util.PesquisaChavesException;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.internacionalizacao.InternacionalizacaoUtil;
import com.csi.ctfclient.tools.util.logger.CTFClientLogger;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class ChavesCriptografiaUtil {
    public static final String SUCCESS = "SUCCESS";
    public static final String ERROR = "ERROR";
    public static final String USER_CANCEL = "USER_CANCEL";
    public static final int PESQUISAR_CHAVE_SENHA = 1;
    public static final int PESQUISAR_CHAVE_DADOS = 2;
    private static final int USO_CHAVE_CRIPTOGRAFIA_PIN = 0;
    private static final int USO_CHAVE_CRIPTOGRAFIA_DADOS = 1;
    private static Logger logger = CTFClientLogger.getPeriferico();

    public static void pesquisaChavesK3(ControladorPerifericos perifericos, TabelaCriptografia tabelaCriptografia, int chavePesquisa) throws ExcecaoApiAc, PesquisaChavesException {
        if (chavePesquisa != 1 && chavePesquisa != 2) {
            throw new IllegalArgumentException();
        }
        boolean possuiContingencia = false;
        if (chavePesquisa == 1) {
            possuiContingencia = CriptografiaUtil.possuiChaveContingencia(tabelaCriptografia.getCriptografiaSenhaPrincipal(), tabelaCriptografia.getCriptografiaSenhaContingencia());
        } else if (chavePesquisa == 2) {
            possuiContingencia = CriptografiaUtil.possuiChaveContingencia(tabelaCriptografia.getCriptografiaDadosPrincipal(), tabelaCriptografia.getCriptografiaDadosContingencia());
        }
        if (!possuiContingencia) {
            logger.log((Priority)Level.INFO, (Object)"N\u00e3o existem chaves de conting\u00eancia");
            return;
        }
        InternacionalizacaoUtil inter = InternacionalizacaoUtil.getInstance();
        LayoutDisplay displayModel = new LayoutDisplay(inter.getMessage("VERCHAPIN_TITLE"));
        perifericos.imprimeDisplay(displayModel);
        PinEMV pinEMV = perifericos.getPin();
        RegistroCriptografia registroCriptografia = null;
        String descricaoChaveLog = null;
        int usoChave = 0;
        if (chavePesquisa == 1) {
            registroCriptografia = tabelaCriptografia.getCriptografiaSenhaPrincipal();
            descricaoChaveLog = "senha";
            usoChave = 0;
        } else if (chavePesquisa == 2) {
            registroCriptografia = tabelaCriptografia.getCriptografiaDadosPrincipal();
            descricaoChaveLog = "dados";
            usoChave = 1;
        }
        logger.debug((Object)("Pesquisando chave de " + descricaoChaveLog + " algoritmo: " + registroCriptografia.getAlgoritmo() + ", \u00edndice: " + registroCriptografia.getIndiceMasterKey()));
        String comandoK3 = ChavesCriptografiaUtil.montaComandoSolicitacaoK3(registroCriptografia.getAlgoritmo(), usoChave, registroCriptografia.getIndiceMasterKey());
        pinEMV.setBufferGenericCommand(comandoK3);
        PerifericoEventHandler.setActive(true);
        pinEMV.habilita(4);
        try {
            String retornoK3 = ChavesCriptografiaUtil.leituraGenericCommand(perifericos, displayModel);
            if (!retornoK3.equals(SUCCESS)) {
                throw new PesquisaChavesException("Erro ao executar a K3: " + retornoK3);
            }
        }
        catch (ChaveAusenteException e) {
            if (chavePesquisa == 1) {
                CriptografiaUtil.utilizaCriptografiaContingenciaSenha(tabelaCriptografia, logger);
            } else if (chavePesquisa == 2) {
                CriptografiaUtil.utilizaCriptografiaContingenciaDados(tabelaCriptografia, logger);
            }
            CriptografiaUtil.atualizarUsoRestritoCriptografia(tabelaCriptografia, logger);
        }
    }

    private static String montaComandoSolicitacaoK3(int tipoChave, int usoChave, int indice) {
        StringBuffer str = new StringBuffer();
        str.append("02");
        str.append("008");
        str.append("K3");
        str.append(tipoChave);
        str.append(usoChave);
        str.append(StringUtil.completaString(String.valueOf(indice), 2, '0', 3));
        str.append(StringUtil.completaString(String.valueOf(indice), 2, '0', 3));
        return str.toString();
    }

    private static String leituraGenericCommand(ControladorPerifericos perifericos, LayoutDisplay displayModel) throws ExcecaoApiAc, ChaveAusenteException {
        EventoDispositivoEntrada evento = null;
        while ((evento = perifericos.capturaDado(displayModel, ConstantesApiAc.CAP_GENERIC_COMMAND, false, new long[]{1L, 4L})) instanceof EventoTeclado && ("VOLTA".equals(((EventoTeclado)evento).getTeclaFinalizadora()) && perifericos.exibeMenuCancelamento() == 2 || "ENTRA".equals(((EventoTeclado)evento).getTeclaFinalizadora()))) {
        }
        if (evento instanceof EventoPinEMV) {
            EventoPinEMV eventoPinEMV = (EventoPinEMV)evento;
            if (eventoPinEMV.getErro()) {
                logger.log((Priority)Level.WARN, (Object)"Erro na execu\u00e7\u00e3o da PP_GENERIC_COMMAND ao tentar executar o comando K3");
                return ERROR;
            }
            if (eventoPinEMV.getDigitacaoCancelada()) {
                return USER_CANCEL;
            }
            String bufferGenericCommand = eventoPinEMV.getBufferRespostaGenericCommand();
            if (bufferGenericCommand.length() >= 4) {
                int estadoChave = Integer.parseInt(bufferGenericCommand.substring(3, 4));
                switch (estadoChave) {
                    case 0: {
                        logger.log((Priority)Level.DEBUG, (Object)"Retorno K3: Chave ausente");
                        throw new ChaveAusenteException();
                    }
                    case 1: {
                        logger.log((Priority)Level.DEBUG, (Object)"Retorno K3: Chave presente");
                        break;
                    }
                    case 2: {
                        logger.log((Priority)Level.DEBUG, (Object)"Retorno K3: Chave n\u00e3o suportada");
                        throw new ChaveAusenteException();
                    }
                    default: {
                        logger.log((Priority)Level.DEBUG, (Object)("Retorno K3 n\u00e3o tratado: " + estadoChave));
                        return ERROR;
                    }
                }
                return SUCCESS;
            }
            logger.log((Priority)Level.ERROR, (Object)"Tamanho inv\u00e1lido da resposta do K3");
            return ERROR;
        }
        if (evento instanceof EventoTeclado) {
            if (perifericos.getPin() != null) {
                BibliotecaPinpad pin = (BibliotecaPinpad)perifericos.getPin();
                pin.abort();
            }
            return USER_CANCEL;
        }
        return ERROR;
    }

    private static class ChaveAusenteException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ChaveAusenteException() {
        }
    }
}

