/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.arquivoDeObjetos;

import com.csi.ctfclient.tools.services.exceptions.ExcecaoLocal;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoObjetoInexistente;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoObjetoJaExistente;
import com.csi.ctfclient.tools.services.exceptions.ExcecaoParametroInvalido;
import com.csi.ctfclient.tools.util.CSIBigDecimal;
import com.csi.ctfclient.tools.util.arquivoDeObjetos.ExcecaoArquivoDeObjetosCheio;
import com.csi.ctfclient.tools.util.arquivoDeObjetos.ExcecaoErroAcessoArquivo;
import com.csi.ctfclient.tools.util.arquivoDeObjetos.ExcecaoTransacaoNaoAberta;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Vector;

public class ArquivoDeObjetos {
    private boolean emTransacao = false;
    protected byte[] espelho;
    protected static RandomAccessFile arqObjetos;
    protected static final int tamDiretorio = 1024;
    protected static final int tamArquivo = 32768;
    protected static final int tamNomeObjeto = 6;
    protected static final int tamEntradaDiretorio = 8;
    protected static final int maxEntradasDiretorio = 128;

    public ArquivoDeObjetos() {
    }

    public ArquivoDeObjetos(String nome) throws ExcecaoErroAcessoArquivo, ExcecaoLocal {
        try {
            arqObjetos = new RandomAccessFile(nome, "rw");
            int tamanho = (int)arqObjetos.length();
            if (tamanho != 32768) {
                arqObjetos.close();
                File f = new File(nome);
                if (f.exists()) {
                    f.delete();
                }
                arqObjetos = new RandomAccessFile(nome, "rw");
                byte[] b = new byte[32768];
                arqObjetos.write(b);
                tamanho = (int)arqObjetos.length();
            }
            this.espelho = new byte[tamanho];
            this.reload();
        }
        catch (IOException e) {
            System.out.println("Erro!!!" + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void atualizaObjeto(InfoObjetoArquivo info, Serializable valor) throws ExcecaoObjetoInexistente, ExcecaoErroAcessoArquivo, ExcecaoArquivoDeObjetosCheio {
        boolean estavaEmTransacao = this.emTransacao;
        boolean erro = false;
        if (!this.emTransacao) {
            this.beginTransaction();
        }
        try {
            this.removeObjeto(info);
            try {
                this.insereObjeto(info.nome, valor);
            }
            catch (ExcecaoObjetoJaExistente e) {
                erro = true;
            }
            if (!estavaEmTransacao) {
                try {
                    this.commitTransaction();
                }
                catch (ExcecaoTransacaoNaoAberta e) {
                    erro = true;
                }
            }
            Object var7_7 = null;
            if (!erro || estavaEmTransacao) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!erro || estavaEmTransacao) throw throwable;
            try {
                this.rollbackTransaction();
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            this.rollbackTransaction();
            return;
        }
        catch (Exception e) {}
    }

    public synchronized void atualizaObjeto(String nome, Serializable valor) throws ExcecaoObjetoInexistente, ExcecaoErroAcessoArquivo, ExcecaoArquivoDeObjetosCheio, ExcecaoParametroInvalido {
        boolean estavaEmTransacao = this.emTransacao;
        InfoObjetoArquivo info = this.getInfoObjeto(nome);
        this.atualizaObjeto(info, valor);
    }

    public synchronized void beginTransaction() {
        while (this.emTransacao) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.emTransacao = true;
    }

    private static int bytes2int(byte b1, byte b2) {
        int result = b1 < 0 ? b1 + 256 : b1;
        result *= 256;
        result = b2 < 0 ? (result += b2 + 256) : (result += b2);
        return result;
    }

    public synchronized void commitTransaction() throws ExcecaoErroAcessoArquivo, ExcecaoTransacaoNaoAberta {
        if (!this.emTransacao) {
            throw new ExcecaoTransacaoNaoAberta();
        }
        try {
            this.efetivaGravacao();
        }
        catch (ExcecaoLocal e) {
            throw new ExcecaoErroAcessoArquivo("AOBO07", e);
        }
        this.emTransacao = false;
        this.notifyAll();
    }

    protected void efetivaGravacao() throws ExcecaoErroAcessoArquivo {
        try {
            arqObjetos.seek(0L);
            arqObjetos.write(this.espelho, 0, this.espelho.length);
        }
        catch (IOException e) {
            throw new ExcecaoErroAcessoArquivo("AOB004", e);
        }
    }

    public synchronized boolean estaVazia() {
        int posDiretorio = this.espelho.length - 1024;
        return this.espelho[posDiretorio + 6] == 0 && this.espelho[posDiretorio + 7] == 0;
    }

    public synchronized boolean existeObjeto(String nome) throws ExcecaoParametroInvalido {
        boolean result = true;
        try {
            this.getInfoObjeto(nome);
        }
        catch (ExcecaoObjetoInexistente e) {
            result = false;
        }
        return result;
    }

    public synchronized Vector getDiretorio() {
        Vector<String> result = new Vector<String>();
        for (int numEntrada = 0; numEntrada < 128; ++numEntrada) {
            try {
                result.addElement(this.getInfoObjeto((int)numEntrada).nome);
                continue;
            }
            catch (ExcecaoObjetoInexistente e) {
                break;
            }
        }
        return result;
    }

    private synchronized InfoObjetoArquivo getInfoObjeto(int indice) throws ExcecaoObjetoInexistente {
        if (indice < 0 || indice >= 128) {
            throw new ExcecaoObjetoInexistente();
        }
        InfoObjetoArquivo result = new InfoObjetoArquivo();
        int posDiretorio = this.espelho.length - 1024;
        int tamanho = 0;
        int posicao = 0;
        char[] nomeObjeto = new char[6];
        byte[] entrada = new byte[8];
        System.arraycopy(this.espelho, posDiretorio + indice * 8, entrada, 0, 8);
        byte tam1 = entrada[6];
        byte tam2 = entrada[7];
        tamanho = ArquivoDeObjetos.bytes2int(tam1, tam2);
        if (tamanho == 0) {
            throw new ExcecaoObjetoInexistente();
        }
        for (int i = 0; i < 6; ++i) {
            nomeObjeto[i] = (char)entrada[i];
        }
        result.nome = new String(nomeObjeto).trim();
        result.tamanho = tamanho;
        result.posicao = posicao;
        result.indice = indice;
        return result;
    }

    private synchronized InfoObjetoArquivo getInfoObjeto(String nome) throws ExcecaoParametroInvalido, ExcecaoObjetoInexistente {
        boolean achou = false;
        int tamanho = 0;
        int posicao = 0;
        int posDiretorio = this.espelho.length - 1024;
        if (nome.length() > 6) {
            throw new ExcecaoParametroInvalido("AOB008");
        }
        InfoObjetoArquivo result = new InfoObjetoArquivo();
        char[] nomeObjeto = new char[6];
        byte[] entrada = new byte[8];
        for (int numEntrada = 0; numEntrada < 128; ++numEntrada) {
            System.arraycopy(this.espelho, posDiretorio, entrada, 0, 8);
            byte tam1 = entrada[6];
            byte tam2 = entrada[7];
            tamanho = ArquivoDeObjetos.bytes2int(tam1, tam2);
            if (tamanho == 0) break;
            for (int i = 0; i < 6; ++i) {
                nomeObjeto[i] = (char)entrada[i];
            }
            String strnomeObjeto = new String(nomeObjeto).trim();
            if (nome.equals(strnomeObjeto)) {
                achou = true;
                result.nome = strnomeObjeto;
                result.tamanho = tamanho;
                result.posicao = posicao;
                result.indice = numEntrada;
                break;
            }
            posDiretorio += 8;
            posicao += tamanho;
        }
        if (!achou) {
            throw new ExcecaoObjetoInexistente();
        }
        return result;
    }

    public synchronized void insereObjeto(String nome, Serializable valor) throws ExcecaoErroAcessoArquivo, ExcecaoObjetoJaExistente, ExcecaoArquivoDeObjetosCheio {
        int posDiretorio;
        boolean estavaEmTransacao = this.emTransacao;
        if (!this.emTransacao) {
            this.beginTransaction();
        }
        if (nome.length() > 6) {
            nome = nome.substring(0, 6);
        }
        int tamCMOS = posDiretorio = this.espelho.length - 1024;
        boolean fim = false;
        boolean achou = false;
        int posicaoNaCMOS = 0;
        int tamanhoAtual = 0;
        byte[] directoryEntry = new byte[8];
        char[] nomeEntry = new char[6];
        try {
            int i;
            while (!fim && !achou) {
                if (posDiretorio == this.espelho.length) {
                    throw new ExcecaoArquivoDeObjetosCheio();
                }
                System.arraycopy(this.espelho, posDiretorio, directoryEntry, 0, 8);
                byte tam1 = directoryEntry[6];
                byte tam2 = directoryEntry[7];
                tamanhoAtual = ArquivoDeObjetos.bytes2int(tam1, tam2);
                if (tamanhoAtual == 0) {
                    fim = true;
                    continue;
                }
                for (i = 0; i < 6; ++i) {
                    nomeEntry[i] = (char)directoryEntry[i];
                }
                boolean igual = true;
                int tamNome = nome.length();
                for (i = 0; i < 6 && igual; ++i) {
                    if (i == tamNome) {
                        igual = nomeEntry[i] == '\u0000';
                        break;
                    }
                    if (i < tamNome && nomeEntry[i] == '\u0000') {
                        igual = false;
                        continue;
                    }
                    if (nome.charAt(i) == nomeEntry[i]) continue;
                    igual = false;
                }
                if (igual) {
                    achou = true;
                    continue;
                }
                posDiretorio += 8;
                posicaoNaCMOS += tamanhoAtual;
            }
            if (achou) {
                throw new ExcecaoObjetoJaExistente("AOB002");
            }
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(valor);
            out.close();
            byte[] bytes = bout.toByteArray();
            if (tamCMOS - posicaoNaCMOS < bytes.length) {
                throw new ExcecaoArquivoDeObjetosCheio();
            }
            System.arraycopy(bytes, 0, this.espelho, posicaoNaCMOS, bytes.length);
            this.espelho[posDiretorio + 6] = (byte)(bytes.length / 256);
            this.espelho[posDiretorio + 7] = (byte)(bytes.length % 256);
            byte[] byteNomeEntry = new byte[6];
            for (i = 0; i < nome.length(); ++i) {
                byteNomeEntry[i] = (byte)nome.charAt(i);
            }
            System.arraycopy(byteNomeEntry, 0, this.espelho, posDiretorio, 6);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (!estavaEmTransacao) {
            try {
                this.commitTransaction();
            }
            catch (ExcecaoLocal e) {
                // empty catch block
            }
        }
    }

    public synchronized void limpa() throws ExcecaoErroAcessoArquivo {
        boolean estavaEmTransacao = this.emTransacao;
        if (!this.emTransacao) {
            this.beginTransaction();
        }
        for (int i = 0; i < this.espelho.length; ++i) {
            this.espelho[i] = 0;
        }
        if (!estavaEmTransacao) {
            try {
                this.commitTransaction();
            }
            catch (ExcecaoTransacaoNaoAberta excecaoTransacaoNaoAberta) {
                // empty catch block
            }
        }
    }

    public static void main(String[] args) {
        try {
            CSIBigDecimal valor;
            int i;
            ArquivoDeObjetos arq = new ArquivoDeObjetos("teste.dat");
            if (arq.estaVazia()) {
                for (i = 0; i < 20; ++i) {
                    valor = new CSIBigDecimal(i, 0);
                    arq.insereObjeto("VAL" + i, valor);
                    System.out.println("Valor armazenado = " + (CSIBigDecimal)arq.recuperaObjeto("VAL" + i));
                }
            }
            arq.beginTransaction();
            for (i = 0; i < 20; ++i) {
                valor = (CSIBigDecimal)arq.recuperaObjeto("VAL" + i);
                System.out.println("Valor recuperado = " + valor);
                arq.atualizaObjeto("VAL" + i, (Serializable)valor.add(CSIBigDecimal.getCem()));
            }
            arq.commitTransaction();
        }
        catch (Exception e) {
            System.out.println("Ocorreu erro!");
            e.printStackTrace();
        }
    }

    public synchronized Object recuperaObjeto(String nome) throws ExcecaoObjetoInexistente, ExcecaoErroAcessoArquivo, ExcecaoParametroInvalido {
        InfoObjetoArquivo info = this.getInfoObjeto(nome);
        Object result = null;
        try {
            byte[] obj = new byte[info.tamanho];
            System.arraycopy(this.espelho, info.posicao, obj, 0, info.tamanho);
            ByteArrayInputStream barr = new ByteArrayInputStream(obj);
            ObjectInputStream objInp = new ObjectInputStream(barr);
            result = objInp.readObject();
            objInp.close();
        }
        catch (IOException e) {
            throw new ExcecaoErroAcessoArquivo("AOB006", e);
        }
        catch (ClassNotFoundException e) {
            throw new ExcecaoErroAcessoArquivo("AOB007", e);
        }
        return result;
    }

    protected void reload() throws ExcecaoErroAcessoArquivo {
        byte[] aux = new byte[this.espelho.length];
        System.arraycopy(this.espelho, 0, aux, 0, aux.length);
        try {
            arqObjetos.seek(0L);
            arqObjetos.read(this.espelho, 0, this.espelho.length);
        }
        catch (IOException e) {
            System.arraycopy(aux, 0, this.espelho, 0, aux.length);
            throw new ExcecaoErroAcessoArquivo("AOB005", e);
        }
    }

    private synchronized void removeObjeto(InfoObjetoArquivo info) throws ExcecaoErroAcessoArquivo {
        int posDiretorio;
        int i;
        int nEntrAbaixo;
        boolean estavaEmTransacao = this.emTransacao;
        if (!this.emTransacao) {
            this.beginTransaction();
        }
        if ((nEntrAbaixo = 128 - (i = info.indice) - 1) > 0) {
            posDiretorio = this.espelho.length - 1024;
            System.arraycopy(this.espelho, posDiretorio + (i + 1) * 8, this.espelho, posDiretorio + i * 8, nEntrAbaixo * 8);
        }
        posDiretorio = this.espelho.length - 1024;
        this.espelho[(i + nEntrAbaixo) * 8 + posDiretorio] = 0;
        this.espelho[(i + nEntrAbaixo) * 8 + posDiretorio + 1] = 0;
        int tamResto = this.espelho.length - 1024 - (info.posicao + info.tamanho);
        System.arraycopy(this.espelho, info.posicao + info.tamanho, this.espelho, info.posicao, tamResto);
        if (!estavaEmTransacao) {
            try {
                this.commitTransaction();
            }
            catch (ExcecaoTransacaoNaoAberta e) {
                // empty catch block
            }
        }
    }

    public synchronized void removeObjeto(String nome) throws ExcecaoObjetoInexistente, ExcecaoErroAcessoArquivo, ExcecaoParametroInvalido {
        boolean estavaEmTransacao = this.emTransacao;
        InfoObjetoArquivo info = this.getInfoObjeto(nome);
        this.removeObjeto(info);
    }

    public synchronized void rollbackTransaction() throws ExcecaoTransacaoNaoAberta, ExcecaoErroAcessoArquivo {
        if (!this.emTransacao) {
            throw new ExcecaoTransacaoNaoAberta();
        }
        this.reload();
        this.emTransacao = false;
        this.notifyAll();
    }

    private class InfoObjetoArquivo {
        public String nome;
        public int tamanho;
        public int posicao;
        public int indice;

        private InfoObjetoArquivo() {
        }
    }
}

