/*
 * Decompiled with CFR 0.152.
 */
package com.csi.ctfclient.tools.util.codigobarras;

import com.csi.ctfclient.excecoes.ExcecaoCodigoInvalido;
import com.csi.ctfclient.excecoes.ExcecaoDigitoInvalido;
import com.csi.ctfclient.tools.util.StringUtil;
import com.csi.ctfclient.tools.util.codigobarras.CalculadorDigito;
import com.csi.ctfclient.tools.util.codigobarras.Codigo;

public class CodGeral
extends Codigo {
    private static transient String tipoValidacao = null;
    private static final long serialVersionUID = 5942982975780897863L;

    public CodGeral(String codigo) throws ExcecaoDigitoInvalido, ExcecaoCodigoInvalido {
        super(codigo);
        this.setCodigo(codigo);
        this.setDigitoVerificador();
    }

    public CodGeral(String codigo, String digito) throws ExcecaoDigitoInvalido, ExcecaoCodigoInvalido {
        super(codigo, digito);
    }

    public String calculaDigito(String codigo) {
        if (tipoValidacao == null) {
            // empty if block
        }
        if (tipoValidacao != null && tipoValidacao.equals("EAN13")) {
            return CalculadorDigito.calculaDigito(codigo, "EAN13");
        }
        if ((codigo = StringUtil.completaString(codigo.trim(), 10, '0', true)).length() != 10) {
            return null;
        }
        int[] digs = new int[10];
        for (int i = 0; i < 10; ++i) {
            digs[i] = codigo.charAt(i) - 48;
        }
        int total = 0;
        total += 2 * digs[9] + 3 * digs[8] + 4 * digs[7] + 5 * digs[6] + 6 * digs[5];
        total += 7 * digs[4] + 8 * digs[3] + 9 * digs[2] + 2 * digs[1] + 3 * digs[0];
        int dig = (total *= 10) % 11;
        if (dig == 0) {
            dig = 1;
        }
        if (dig == 10) {
            dig = 0;
        }
        return new Integer(dig).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CodGeral) {
            return super.equals(obj);
        }
        return false;
    }

    public static void main(String[] args) {
        for (int i = 0; i < 2; ++i) {
            if (args.length < 1) {
                System.out.println("Modo de usar: <cmd> <CODIGO> [<1-EAN13 ou 2-MOD11>] ");
                System.exit(0);
            }
            try {
                if (args.length >= 2) {
                    if (args[1].equals("1")) {
                        tipoValidacao = "EAN13";
                    } else if (args[1].equals("2")) {
                        tipoValidacao = "MODULO11";
                    } else {
                        System.out.println("Modo de usar: <cmd> <1-EAN13 ou 2-MOD11> <CODIGO>");
                        System.exit(0);
                    }
                }
                CodGeral cod1 = new CodGeral(args[0]);
                System.out.println("===> Digito = " + cod1.calculaDigito(args[0]));
                continue;
            }
            catch (ExcecaoCodigoInvalido e) {
                e.printStackTrace();
                continue;
            }
            catch (ExcecaoDigitoInvalido e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    protected void setCodigo(String codigo) throws ExcecaoCodigoInvalido {
        int i;
        codigo = codigo.trim();
        for (i = 0; codigo.charAt(i) == '0' && i < codigo.length(); ++i) {
        }
        super.setCodigo(codigo.substring(i, codigo.length()));
    }

    protected void setDigitoVerificador() throws ExcecaoDigitoInvalido {
        String digito = this.calculaDigito(this.codigo);
        if (digito == null || digito.equals("")) {
            throw new ExcecaoDigitoInvalido();
        }
        super.setDigitoVerificador(digito);
    }

    protected void setDigitoVerificador(String digito) throws ExcecaoDigitoInvalido {
        super.setDigitoVerificador(digito);
    }

    public void touch() {
    }

    protected boolean validaDigito() {
        String cod = StringUtil.completaString(this.codigo, 10, '0', true);
        if (cod.length() != 10 || this.digitoVerificador.length() != 1) {
            return false;
        }
        return this.digitoVerificador.equals("" + this.calculaDigito(cod));
    }
}

