/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.cache;

import com.sun.deploy.config.Config;
import com.sun.deploy.security.JarVerifier;
import com.sun.deploy.util.JarUtil;
import java.net.URL;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Map;

class JarSigningData {
    private CodeSigner[] signers;
    private Map signerMap;
    private Map codeSourceCache;
    private Certificate[] certificates;
    private Map signerMapCert;
    private Map codeSourceCertCache;
    private final boolean hasOnlySignedEntries;
    private final boolean hasSingleCodeSource;
    private final boolean hasMissingSignedEntries;

    JarSigningData(boolean bl, boolean bl2, boolean bl3) {
        this.hasOnlySignedEntries = bl;
        this.hasSingleCodeSource = bl2;
        this.hasMissingSignedEntries = bl3;
    }

    static JarSigningData create(JarVerifier jarVerifier) {
        List list;
        JarSigningData jarSigningData = new JarSigningData(jarVerifier.hasOnlySignedEntries(), jarVerifier.hasSingleCodeSource(), jarVerifier.hasMissingSignedEntries());
        List list2 = jarVerifier.getSignerCerts();
        if (!list2.isEmpty()) {
            jarSigningData.certificates = list2.toArray(new Certificate[list2.size()]);
            jarSigningData.signerMapCert = jarVerifier.getSignerMapCert();
            jarSigningData.codeSourceCertCache = jarVerifier.getCodeSourceCertCache();
        }
        if (!(list = jarVerifier.getSignersCS()).isEmpty()) {
            CodeSigner[] codeSignerArray = new CodeSigner[list.size()];
            jarSigningData.signers = list.toArray(codeSignerArray);
            jarSigningData.signerMap = jarVerifier.getSignerMap();
            jarSigningData.codeSourceCache = jarVerifier.getCodeSourceCache();
        }
        return jarSigningData;
    }

    void updateCertInfo(Certificate[] certificateArray, Map map, Map map2) {
        this.certificates = certificateArray;
        this.signerMapCert = map;
        this.codeSourceCertCache = map2;
    }

    void updateSignerInfo(CodeSigner[] codeSignerArray, Map map, Map map2) {
        this.signers = codeSignerArray;
        this.signerMap = map;
        this.codeSourceCache = map2;
    }

    boolean hasStrictSingleSigning() {
        return this.hasOnlySignedEntries && this.hasSingleCodeSource && !this.hasMissingSignedEntries;
    }

    synchronized Map getCertificateMap() {
        return this.signerMapCert;
    }

    synchronized Map getSignerMap() {
        if (Config.isJavaVersionAtLeast15()) {
            return this.signerMap;
        }
        return this.signerMapCert;
    }

    synchronized Map getCodeSourceCache() {
        if (Config.isJavaVersionAtLeast15()) {
            return this.codeSourceCache;
        }
        return this.codeSourceCertCache;
    }

    synchronized Map getCodeSourceCertCache() {
        return this.codeSourceCertCache;
    }

    public synchronized CodeSigner[] getCodeSigners() {
        return this.signers;
    }

    public synchronized Certificate[] getCertificates() {
        return this.certificates;
    }

    synchronized CodeSource[] getCodeSources(URL uRL) {
        CodeSource[] codeSourceArray;
        Collection collection = null;
        if (Config.isJavaVersionAtLeast15()) {
            if (this.codeSourceCache != null) {
                collection = this.codeSourceCache.values();
            }
        } else if (this.codeSourceCertCache != null) {
            collection = this.codeSourceCertCache.values();
        }
        if (collection != null) {
            int n = collection.size();
            if (this.hasOnlySignedEntries) {
                codeSourceArray = collection.toArray(new CodeSource[n]);
            } else {
                codeSourceArray = collection.toArray(new CodeSource[n + 1]);
                codeSourceArray[n] = JarSigningData.getUnsignedCS(uRL);
            }
        } else {
            codeSourceArray = new CodeSource[]{JarSigningData.getUnsignedCS(uRL)};
        }
        return codeSourceArray;
    }

    synchronized CodeSource getCodeSource(URL uRL, String string) {
        Map map;
        Map map2 = this.getSignerMap();
        int[] nArray = map2 == null || map2.isEmpty() ? null : (this.hasStrictSingleSigning() ? (!JarUtil.isSigningRelated(string) && !string.endsWith("/") ? (int[])map2.get(null) : null) : (int[])map2.get(string));
        if (nArray != null && (map = this.getCodeSourceCache()) != null) {
            return (CodeSource)map.get(nArray);
        }
        return JarSigningData.getUnsignedCS(uRL);
    }

    private static CodeSource getUnsignedCS(URL uRL) {
        return new CodeSource(uRL, (Certificate[])null);
    }
}

