/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos;

import com.ibm.jpos.AboutDialog;
import com.ibm.jpos.services.DeviceServiceConst;
import java.util.StringTokenizer;
import javax.swing.JFrame;

public final class Version {
    public static final String COPYRIGHT_INFO_MSG1 = "IBM (R) JavaPOS (TM) Services";
    public static final String COPYRIGHT_INFO_MSG2 = "Copyright (C) IBM Corp 1997, 2006.  All rights reserved.";
    public static final String VERSION_MSG = "Version";

    private Version() {
    }

    public static void main(String[] args) {
        System.out.println(Version.getInfo());
        if (Version.isSwingInstalled()) {
            new AboutDialog(new JFrame(""), COPYRIGHT_INFO_MSG2).setVisible(true);
        } else {
            System.exit(0);
        }
    }

    public static int makeIntVersion(String release) {
        StringTokenizer st;
        int nVersion = 0;
        try {
            st = new StringTokenizer(release, ".");
            int mux = 1000000;
            nVersion = mux * Integer.valueOf(st.nextToken());
            mux = 1000;
            nVersion += mux * Integer.valueOf(st.nextToken());
            if (!st.hasMoreTokens()) {
                return nVersion;
            }
        }
        catch (Exception e) {
            return 1009200;
        }
        return nVersion += (mux /= 10) * Integer.valueOf(st.nextToken());
    }

    public static String getVersionString() {
        int version = DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER;
        String major = Integer.toString(version / 1000000);
        String minor = Integer.toString(version % 1000000 / 1000);
        String build = Integer.toString(version % 1000 / 100);
        if (version % 100 != 0) {
            build = build + Integer.toString(version % 100 / 10) + Integer.toString(version % 10);
        }
        return major + "." + minor + "." + build;
    }

    private static String getInfo() {
        String msg = COPYRIGHT_INFO_MSG1;
        msg = msg + " Version " + Version.getVersionString() + "\n";
        msg = msg + COPYRIGHT_INFO_MSG2;
        return msg;
    }

    private static boolean isSwingInstalled() {
        boolean b = false;
        try {
            Class.forName("javax.swing.JComponent");
            Class.forName("javax.swing.JFrame");
            b = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return b;
    }
}

