/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.CashDrawerServiceImp;
import com.ibm.jpos.services.CashDrawerServiceState;
import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.util.Timer;
import com.ibm.jpos.util.Timerable;
import jpos.JposException;
import jpos.services.CashDrawerService19;

public abstract class CashDrawerService
extends DeviceService
implements CashDrawerService19 {
    private Timer timer = null;
    private boolean timerExpired = false;
    private boolean abort = false;
    public static final String CASHDRAWER_DEVCAT = "com.ibm.jpos.services.CashDrawerService";

    public CashDrawerService(CashDrawerServiceImp imp) {
        super(imp);
        this.setDeviceServiceState(new CashDrawerServiceState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapStatus() throws JposException {
        CashDrawerServiceState state;
        CashDrawerServiceState cashDrawerServiceState = state = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapStatus" + state.getCapStatus());
            }
            return state.getCapStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getCapStatusMultiDrawerDetect() throws JposException {
        CashDrawerServiceState state;
        CashDrawerServiceState cashDrawerServiceState = state = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getCapStatusMultiDrawerDetect" + state.getCapStatusMultiDrawerDetect());
            }
            return state.getCapStatusMultiDrawerDetect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDeviceEnabled(boolean deviceEnabled) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "-->setDeviceEnabled," + deviceEnabled);
        }
        if (!deviceEnabled) {
            this.setAbort(true);
        }
        CashDrawerService cashDrawerService = this;
        synchronized (cashDrawerService) {
            this.getDeviceServiceState().isOpen();
            this.getDeviceServiceImp().setDeviceEnabled(deviceEnabled);
            this.getDeviceServiceState().setDeviceEnabled(deviceEnabled);
        }
        if (!deviceEnabled) {
            this.setAbort(false);
        }
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "<--setDeviceEnabled," + deviceEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getDrawerOpened() throws JposException {
        CashDrawerServiceState state;
        CashDrawerServiceState cashDrawerServiceState = state = this.getCashDrawerServiceState();
        synchronized (cashDrawerServiceState) {
            state.isOpen();
            if (this.tracer.isOn()) {
                this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "getDrawerOpened" + state.getDrawerOpened());
            }
            return state.getDrawerOpened();
        }
    }

    public synchronized void release() throws JposException {
        super.releaseSharable();
    }

    public synchronized void checkHealth(int level) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "-->checkHealth," + level);
        }
        this.getDeviceServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkCheckHealthArg(level);
        this.getDeviceServiceImp().checkHealth(level);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "<--checkHealth," + level);
        }
    }

    public synchronized void openDrawer() throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "openDrawer");
        }
        this.getCashDrawerServiceState().isOpenEnable();
        this.checkClaimedService();
        this.checkOnline();
        this.getCashDrawerServiceImp().openDrawer();
    }

    public synchronized void waitForDrawerClose(int beepTimeout, int beepFrequency, int beepDuration, int beepDelay) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - CashDrawerService.getFsttmStamp(), "waitForDrawerClose," + beepTimeout + "," + beepFrequency + "," + beepDuration + "," + beepDelay);
        }
        CashDrawerServiceState state = this.getCashDrawerServiceState();
        state.checkNegativeValue(beepTimeout);
        state.checkNegativeValue(beepFrequency);
        state.checkNegativeValue(beepDuration);
        state.checkNegativeValue(beepDelay);
        state.isOpenEnable();
        this.checkOnline();
        this.checkClaimedService();
        if (!state.getDrawerOpened()) {
            return;
        }
        this.commonWaitForDrawerClose(beepTimeout, beepFrequency, beepDuration, beepDelay);
    }

    public synchronized void compareFirmwareVersion(String firmwareFileName, int[] result) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->compareFirmwareVersion");
        }
        this.getCashDrawerServiceState().isOpenClaimEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (!this.getDeviceServiceState().getCapCompareFirmwareVersion()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().compareFirmwareVersion(firmwareFileName, result);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--compareFirmwareVersion");
        }
    }

    public synchronized void updateFirmware(String firmwareFileName) throws JposException {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "-->updateFirmware");
        }
        this.getCashDrawerServiceState().isOpenClaimEnable();
        this.checkClaimedService();
        this.checkOnline();
        if (!this.getDeviceServiceState().getCapUpdateFirmware()) {
            throw new JposException(106);
        }
        this.getDeviceServiceImp().updateFirmware(firmwareFileName);
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.getinstanceID(), this.gettimeStamp() - DeviceService.getFsttmStamp(), "<--updateFirmware");
        }
    }

    public void setAbort(boolean abortFlag) {
        this.abort = abortFlag;
    }

    public boolean isAbort() {
        return this.abort;
    }

    public final String getDeviceCategory() {
        return CASHDRAWER_DEVCAT;
    }

    protected CashDrawerServiceState getCashDrawerServiceState() {
        return (CashDrawerServiceState)this.getDeviceServiceState();
    }

    protected CashDrawerServiceImp getCashDrawerServiceImp() {
        return (CashDrawerServiceImp)this.getDeviceServiceImp();
    }

    protected Timer getTimer() {
        if (this.timer == null) {
            this.timer = new Timer(new Timerable(){

                public void timerExpired() {
                    CashDrawerService.this.timerExpired = true;
                }
            });
        }
        return this.timer;
    }

    protected void commonWaitForDrawerClose(int beepTimeout, int beepFrequency, int beepDuration, int beepDelay) throws JposException {
        this.timerExpired = false;
        Timer timer = this.getTimer();
        timer.reset();
        CashDrawerServiceState state = (CashDrawerServiceState)this.getDeviceServiceState();
        timer.setTime(beepTimeout);
        timer.start();
        while (state.getDrawerOpened()) {
            boolean flag = this.isAbort();
            if (flag) {
                this.setAbort(false);
                break;
            }
            if (this.timerExpired) {
                this.getCashDrawerServiceImp().beep(beepFrequency, beepDuration, beepDelay);
            }
            try {
                Thread.currentThread();
                Thread.sleep(this.getCashDrawerServiceImp().getWaitDrawerCloseWaitTime());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.checkOnline();
        }
    }
}

