/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceService;
import com.ibm.jpos.services.EventProcessing;
import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.JposEventQueue;
import com.ibm.jutil.tracing.Tracer;
import com.ibm.jutil.tracing.TracerFactory;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;
import jpos.services.EventCallbacks;

public class EventQueueManager
implements Runnable {
    private EventCallbacks eventCallbacks = null;
    private EventProcessing eventProcessing = null;
    private JposEventQueue jposEventQueue = new JposEventQueue();
    private boolean freezeEvents = false;
    private boolean dataEventEnabled = false;
    private boolean terminated = false;
    private Thread eventThread = new Thread((Runnable)this, "EventQueueManager.eventThread");
    private Object eventPosted = new Object();
    private Object eventUnfrozen = new Object();
    private Object dataEventEnabledLock = new Object();
    private Tracer tracer = TracerFactory.getInstance().createTracer("SystemExt", "EventQueueManager");
    private String instanceID = "";
    public static final String EVENTQUEUEMANAGER_THREAD_NAME = "EventQueueManager.eventThread";

    public EventQueueManager(EventCallbacks eC, EventProcessing eP, String instance) {
        this.eventCallbacks = eC;
        this.eventProcessing = eP;
        this.instanceID = instance;
        this.eventThread.start();
    }

    public EventQueueManager(EventCallbacks eC, EventProcessing eP) {
        this.eventCallbacks = eC;
        this.eventProcessing = eP;
        this.eventThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block15: while (true) {
            if (this.jposEventQueue.isEmpty()) {
                var1_1 = this.eventPosted;
                synchronized (var1_1) {
                    try {
                        this.eventPosted.wait();
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
            }
            while (true) {
                if (!this.jposEventQueue.isEmpty()) ** break;
                continue block15;
                while (this.freezeEvents) {
                    var1_1 = this.eventUnfrozen;
                    synchronized (var1_1) {
                        try {
                            this.eventUnfrozen.wait();
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                    }
                }
                while (this.jposEventQueue.isFirstElementDataEvent() && !this.dataEventEnabled) {
                    if (this.jposEventQueue.isEnqueuedDirectIoOutputCompleteStatusUpdateEvent()) {
                        o = this.jposEventQueue.getFirstDirectIoOutputCompleteStatusUpdateEvent();
                        if (o != null) {
                            this.fireJposEvent(o);
                        }
                        if (!this.dataEventEnabled) continue;
                    }
                    var1_1 = this.dataEventEnabledLock;
                    synchronized (var1_1) {
                        try {
                            this.dataEventEnabledLock.wait();
                        }
                        catch (InterruptedException var2_5) {
                            // empty catch block
                        }
                        break;
                    }
                }
                if (this.jposEventQueue.isFirstElementDataEvent() && !this.dataEventEnabled) continue;
                if (this.terminated) {
                    return;
                }
                this.fireJposEvent(this.jposEventQueue.dequeue());
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setFreezeEvents(boolean b) {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "setFreezeEvents," + b);
        }
        this.freezeEvents = b;
        if (!this.freezeEvents) {
            Object object = this.eventUnfrozen;
            synchronized (object) {
                this.eventUnfrozen.notifyAll();
            }
        }
    }

    public boolean isFreezeEvents() {
        return this.freezeEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setDataEventEnabled(boolean b) {
        if (this.tracer.isOn()) {
            this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "setDataEventEnabled," + b);
        }
        this.dataEventEnabled = b;
        if (this.dataEventEnabled) {
            Object object = this.dataEventEnabledLock;
            synchronized (object) {
                this.dataEventEnabledLock.notifyAll();
            }
        }
    }

    public boolean isDataEventEnabled() {
        return this.dataEventEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postEvent(JposEvent jposEvent) {
        Object object;
        if (this.tracer.isOn()) {
            this.tracer.println("postEvent(JposEvent) :" + jposEvent);
        }
        this.jposEventQueue.enqueue(jposEvent);
        if (jposEvent instanceof DataEvent) {
            this.eventProcessing.newDataEventPosted();
        } else if (jposEvent instanceof ErrorEvent) {
            this.eventProcessing.newErrorEventPosted((ErrorEvent)jposEvent);
        } else if (!this.isDataEventEnabled()) {
            object = this.dataEventEnabledLock;
            synchronized (object) {
                this.dataEventEnabledLock.notifyAll();
            }
        }
        object = this.eventPosted;
        synchronized (object) {
            this.eventPosted.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void postEvent(JposEventContainer jEC) {
        if (this.tracer.isOn()) {
            this.tracer.println("postEvent(JposEventContainer) :" + jEC);
        }
        this.jposEventQueue.enqueue(jEC);
        if (jEC.getJposEvent() instanceof DataEvent) {
            this.eventProcessing.newDataEventPosted();
        }
        if (jEC.getJposEvent() instanceof ErrorEvent) {
            this.eventProcessing.newErrorEventPosted((ErrorEvent)jEC.getJposEvent());
        }
        Object object = this.eventPosted;
        synchronized (object) {
            this.eventPosted.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void terminate() {
        this.terminated = true;
        if (this.freezeEvents) {
            this.freezeEvents = false;
            Object object = this.eventUnfrozen;
            synchronized (object) {
                this.eventUnfrozen.notifyAll();
            }
            return;
        }
        if (!this.dataEventEnabled) {
            this.dataEventEnabled = true;
            Object object = this.dataEventEnabledLock;
            synchronized (object) {
                this.dataEventEnabledLock.notifyAll();
            }
        }
        if (this.jposEventQueue.isEmpty()) {
            this.postEvent(new TerminateEvent(this));
        }
    }

    public synchronized void removeAllErrorEvent() {
        this.jposEventQueue.removeAllErrorEvent();
    }

    synchronized void removeAllDataEvent() {
        this.jposEventQueue.removeAllDataEvent();
    }

    synchronized void removeAllOutputCompleteEvent() {
        this.jposEventQueue.removeAllOutputCompleteEvent();
    }

    public synchronized void removeAllEvents() {
        this.jposEventQueue.removeAllEvents();
    }

    public synchronized void removeAllEventsExceptStatusUpdateEvents() {
        this.jposEventQueue.removeAllEventsExceptStatusUpdateEvents();
    }

    public synchronized boolean isEnqueuedDataEvent() {
        return this.jposEventQueue.isEnqueuedDataEvent();
    }

    public synchronized void enqueueInFront(JposEvent e) {
        this.jposEventQueue.enqueueInFront(e);
    }

    public synchronized void enqueueInFront(JposEventContainer jEC) {
        this.jposEventQueue.enqueueInFront(jEC);
    }

    private void traceEvent(JposEvent jEvent) {
        try {
            if (this.tracer.isOn()) {
                if (jEvent instanceof DataEvent) {
                    this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "DataEvent," + jEvent + ((DataEvent)jEvent).getSource() + "," + ((DataEvent)jEvent).getStatus());
                }
                if (jEvent instanceof DirectIOEvent) {
                    this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "DirectIOEvent," + jEvent + ((DirectIOEvent)jEvent).getSource() + "," + ((DirectIOEvent)jEvent).getData());
                }
                if (jEvent instanceof ErrorEvent) {
                    this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "ErrorEvent, Errorcode-Extended" + jEvent + ((ErrorEvent)jEvent).getSource() + "," + ((ErrorEvent)jEvent).getErrorCode() + "-" + ((ErrorEvent)jEvent).getErrorCodeExtended());
                }
                if (jEvent instanceof OutputCompleteEvent) {
                    this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "OutputCompleteEvent," + jEvent + ((OutputCompleteEvent)jEvent).getSource() + ", ID " + ((OutputCompleteEvent)jEvent).getOutputID());
                }
                if (jEvent instanceof StatusUpdateEvent) {
                    this.enhTrace(this.getClass().getName(), this.instanceID, System.currentTimeMillis() - DeviceService.getFsttmStamp(), "StatusUpdateEvent," + jEvent + ((StatusUpdateEvent)jEvent).getSource() + "," + ((StatusUpdateEvent)jEvent).getStatus());
                }
            }
        }
        catch (Exception e) {
            this.tracer.print(e);
        }
    }

    public void enhTrace(String servicesClass, String instanceID, long timeStamp, String method_args) {
        try {
            if (method_args.length() > 1 && method_args.indexOf(44) == -1) {
                this.tracer.println(1, servicesClass + "," + instanceID + "," + method_args + "()");
            } else if (method_args.length() > 1 && method_args.indexOf(44) > -1) {
                this.tracer.println(1, servicesClass + "," + instanceID + "," + method_args.substring(0, method_args.indexOf(44)) + "(" + method_args.substring(method_args.indexOf(44) + 1, method_args.length()) + ")");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireJposEvent(Object event) {
        OutputCompleteEvent oce;
        if (event instanceof TerminateEvent) {
            return;
        }
        JposEvent jposEvent = null;
        JposEventContainer jEC = null;
        if (event instanceof JposEventContainer) {
            jEC = (JposEventContainer)event;
            jposEvent = jEC.getJposEvent();
        } else {
            jposEvent = (JposEvent)event;
        }
        if (this.tracer.isOn()) {
            this.tracer.println("fireJposEvent() :");
            this.traceEvent(jposEvent);
        }
        if (jposEvent instanceof DataEvent) {
            while (!this.dataEventEnabled || this.freezeEvents) {
                Object object;
                if (event instanceof JposEventContainer) {
                    this.enqueueInFront((JposEventContainer)event);
                } else {
                    this.enqueueInFront((JposEvent)event);
                }
                if (!this.dataEventEnabled) {
                    object = this.dataEventEnabledLock;
                    synchronized (object) {
                        try {
                            this.dataEventEnabledLock.wait();
                            if (!this.jposEventQueue.isEmpty()) {
                                this.fireJposEvent(this.jposEventQueue.dequeue());
                            }
                            return;
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                    }
                }
                object = this.eventUnfrozen;
                synchronized (object) {
                    try {
                        this.eventUnfrozen.wait();
                        if (!this.jposEventQueue.isEmpty()) {
                            this.fireJposEvent(this.jposEventQueue.dequeue());
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
            if (this.terminated) {
                if (jEC != null) {
                    jEC.doneFiring();
                }
                return;
            }
            DataEvent dataEvent = (DataEvent)jposEvent;
            if (jEC != null) {
                jEC.prepareToFire();
            }
            this.eventProcessing.preEventProcessing(dataEvent);
            this.eventCallbacks.fireDataEvent(dataEvent);
            this.eventProcessing.postEventProcessing(dataEvent);
            if (jEC != null) {
                jEC.doneFiring();
            }
            return;
        }
        if (this.terminated) {
            if (jEC != null) {
                jEC.doneFiring();
            }
            return;
        }
        if (jposEvent instanceof DirectIOEvent) {
            if (jEC != null) {
                jEC.prepareToFire();
            }
            this.eventCallbacks.fireDirectIOEvent((DirectIOEvent)jposEvent);
        }
        if (jposEvent instanceof ErrorEvent) {
            while (!this.dataEventEnabled || this.freezeEvents) {
                Object dataEvent;
                if (event instanceof JposEventContainer) {
                    this.enqueueInFront((JposEventContainer)event);
                } else {
                    this.enqueueInFront((JposEvent)event);
                }
                if (!this.dataEventEnabled) {
                    dataEvent = this.dataEventEnabledLock;
                    synchronized (dataEvent) {
                        try {
                            this.dataEventEnabledLock.wait();
                            if (!this.jposEventQueue.isEmpty()) {
                                this.fireJposEvent(this.jposEventQueue.dequeue());
                            }
                            return;
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                    }
                }
                dataEvent = this.eventUnfrozen;
                synchronized (dataEvent) {
                    try {
                        this.eventUnfrozen.wait();
                        if (!this.jposEventQueue.isEmpty()) {
                            this.fireJposEvent(this.jposEventQueue.dequeue());
                        }
                        return;
                    }
                    catch (InterruptedException e) {
                    }
                }
            }
            if (this.terminated) {
                if (jEC != null) {
                    jEC.doneFiring();
                }
                return;
            }
            ErrorEvent errorEvent = (ErrorEvent)jposEvent;
            if (jEC != null) {
                jEC.prepareToFire();
            }
            this.eventProcessing.preEventProcessing(errorEvent);
            this.eventCallbacks.fireErrorEvent(errorEvent);
            if (this.tracer.isOn()) {
                this.tracer.println("ErrorResponse " + errorEvent.getErrorResponse());
            }
            this.eventProcessing.postEventProcessing(errorEvent);
        }
        if (this.terminated) {
            if (jEC != null) {
                jEC.doneFiring();
            }
            return;
        }
        if (jposEvent instanceof OutputCompleteEvent) {
            oce = (OutputCompleteEvent)jposEvent;
            this.eventCallbacks.fireOutputCompleteEvent(oce);
        }
        if (jposEvent instanceof StatusUpdateEvent) {
            oce = (StatusUpdateEvent)jposEvent;
            this.eventCallbacks.fireStatusUpdateEvent((StatusUpdateEvent)jposEvent);
        }
        if (jEC != null) {
            jEC.doneFiring();
        }
    }

    private class TerminateEvent
    extends JposEvent {
        public TerminateEvent(Object source) {
            super(source);
        }
    }
}

