/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceAbstraction;
import com.ibm.jpos.services.DeviceServiceImp;
import com.ibm.jpos.services.DeviceServiceImpMsg;
import com.ibm.jpos.services.ServiceInstanceImp;
import com.ibm.jpos.util.JposEntryInfo;
import java.lang.reflect.Constructor;
import jpos.JposException;

public class ImpFactory {
    public static ServiceInstanceImp createImp(DeviceServiceAbstraction dsAbstraction) throws JposException {
        JposEntryInfo jposEntryInfo = dsAbstraction.getDeviceServiceState().getJposEntryInfo();
        String impClassName = jposEntryInfo.getImpClassName();
        Class<?> impClass = null;
        try {
            if (impClassName != null) {
                impClass = Class.forName(impClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_FOUND_MSG);
        }
        Constructor validConstructor = ImpFactory.lookForValidImpConstructor(impClass);
        if (validConstructor == null) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_NOT_COMPLIANT_MSG);
        }
        DeviceServiceImp imp = null;
        Object[] args = new Object[]{dsAbstraction};
        try {
            imp = (DeviceServiceImp)validConstructor.newInstance(args);
        }
        catch (Exception e) {
            throw new JposException(104, DeviceServiceImpMsg.IMPCLASS_INSTANTIATION_ERROR_MSG);
        }
        return imp;
    }

    private static Constructor lookForValidImpConstructor(Class aClass) {
        Constructor<?>[] constructors = null;
        try {
            constructors = aClass.getDeclaredConstructors();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (constructors == null || constructors.length == 0) {
            return null;
        }
        Constructor<?> validConstructor = null;
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] paramTypes = constructors[i].getParameterTypes();
            if (paramTypes.length != 1 || !paramTypes[0].getName().equals("com.ibm.jpos.services.DeviceServiceAbstraction")) continue;
            validConstructor = constructors[i];
            break;
        }
        return validConstructor;
    }
}

