/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceConst;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.InputDeviceServiceState;
import jpos.JposException;

public class MSRServiceState
extends DeviceServiceState
implements InputDeviceServiceState {
    private String accountNumber = "";
    private boolean autoDisable = false;
    private int dataCount = 0;
    private boolean dataEventEnabled = false;
    private boolean decodeData = true;
    private int errorReportingType = 0;
    private String expirationDate = "";
    private String firstName = "";
    private String middleInitial = "";
    private boolean parseDecodeData = false;
    private String serviceCode = "";
    private String suffix = "";
    private String surname = "";
    private String title = "";
    private byte[] track1Data = new byte[0];
    private byte[] track1DiscretionaryData = new byte[0];
    private byte[] track2Data = new byte[0];
    private byte[] track2DiscretionaryData = new byte[0];
    private byte[] track3Data = new byte[0];
    private byte[] track4Data = new byte[0];
    private int tracksToRead = 7;
    private boolean transmitSentinels = false;
    private boolean capISO = false;
    private boolean capJISOne = false;
    private boolean capJISTwo = false;
    private static final int MSR_SERVICE_VERSION = DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER;

    MSRServiceState() {
    }

    public boolean getCapISO() {
        return this.capISO;
    }

    public boolean getCapJISOne() {
        return this.capJISOne;
    }

    public boolean getCapJISTwo() {
        return this.capJISTwo;
    }

    public boolean getCapTransmitSentinels() {
        return false;
    }

    public synchronized String getAccountNumber() {
        return this.accountNumber;
    }

    public synchronized boolean getAutoDisable() {
        return this.autoDisable;
    }

    public synchronized int getDataCount() {
        return this.dataCount;
    }

    public synchronized boolean getDataEventEnabled() {
        return this.dataEventEnabled;
    }

    public synchronized boolean getDecodeData() {
        return this.decodeData;
    }

    public synchronized int getErrorReportingType() {
        return this.errorReportingType;
    }

    public synchronized String getExpirationDate() {
        return this.expirationDate;
    }

    public synchronized String getFirstName() {
        return this.firstName;
    }

    public synchronized String getMiddleInitial() {
        return this.middleInitial;
    }

    public synchronized boolean getParseDecodeData() {
        return this.parseDecodeData;
    }

    public synchronized String getServiceCode() {
        return this.serviceCode;
    }

    public synchronized String getSuffix() {
        return this.suffix;
    }

    public synchronized String getSurname() {
        return this.surname;
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized byte[] getTrack1Data() {
        return this.track1Data;
    }

    public synchronized byte[] getTrack1DiscretionaryData() {
        return this.track1DiscretionaryData;
    }

    public synchronized byte[] getTrack2Data() {
        return this.track2Data;
    }

    public synchronized byte[] getTrack2DiscretionaryData() {
        return this.track2DiscretionaryData;
    }

    public synchronized byte[] getTrack3Data() {
        return this.track3Data;
    }

    public synchronized byte[] getTrack4Data() {
        return this.track4Data;
    }

    public synchronized int getTracksToRead() {
        return this.tracksToRead;
    }

    public boolean getTransmitSentinels() {
        return this.transmitSentinels;
    }

    public void setCapISO(boolean flag) {
        this.capISO = flag;
    }

    public void setCapJISOne(boolean flag) {
        this.capJISOne = flag;
    }

    public void setCapJISTwo(boolean flag) {
        this.capJISTwo = flag;
    }

    public synchronized void setAccountNumber(String s) {
        this.accountNumber = s;
    }

    public synchronized void setAutoDisable(boolean b) {
        this.autoDisable = b;
    }

    public synchronized void setDataCount(int i) throws JposException {
        this.checkNegativeValue(i);
        this.dataCount = i;
    }

    public synchronized void setDataEventEnabled(boolean b) {
        this.dataEventEnabled = b;
    }

    synchronized void setDecodeData(boolean b) {
        if (!b) {
            this.parseDecodeData = false;
        }
        this.decodeData = b;
    }

    synchronized void setErrorReportingType(int i) throws JposException {
        this.checkErrorReportingTypeValue(i);
        this.errorReportingType = i;
    }

    public synchronized void setExpirationDate(String s) {
        this.expirationDate = s;
    }

    public synchronized void setFirstName(String s) {
        this.firstName = s;
    }

    public synchronized void setMiddleInitial(String s) {
        this.middleInitial = s;
    }

    synchronized void setParseDecodeData(boolean b) {
        if (b) {
            this.decodeData = true;
        }
        this.parseDecodeData = b;
    }

    public synchronized void setServiceCode(String s) {
        this.serviceCode = s;
    }

    public synchronized void setSuffix(String s) {
        this.suffix = s;
    }

    public synchronized void setSurname(String s) {
        this.surname = s;
    }

    public synchronized void setTitle(String s) {
        this.title = s;
    }

    public synchronized void setTrack1Data(byte[] bArray) {
        this.track1Data = bArray;
    }

    public synchronized void setTrack1DiscretionaryData(byte[] bArray) {
        this.track1DiscretionaryData = bArray;
    }

    public synchronized void setTrack2Data(byte[] bArray) {
        this.track2Data = bArray;
    }

    public synchronized void setTrack2DiscretionaryData(byte[] bArray) {
        this.track2DiscretionaryData = bArray;
    }

    public synchronized void setTrack3Data(byte[] bArray) {
        this.track3Data = bArray;
    }

    public synchronized void setTrack4Data(byte[] bArray) {
        this.track4Data = bArray;
    }

    synchronized void setTracksToRead(int i) throws JposException {
        this.checkTracksToReadValue(i);
        this.tracksToRead = i;
    }

    public synchronized void setTransmitSentinels(boolean transmit) throws JposException {
        if (transmit) {
            throw new JposException(106, "setTransmitSentinels not supported");
        }
        this.transmitSentinels = false;
    }

    public void checkErrorReportingTypeValue(int i) throws JposException {
        switch (i) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public void checkTracksToReadValue(int i) throws JposException {
        int MSR_TR_1_3_4 = 13;
        switch (i) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 4: {
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                break;
            }
            case 12: {
                break;
            }
            case 11: {
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                break;
            }
            default: {
                throw new JposException(106);
            }
        }
    }

    public synchronized void setDeviceEnabled(boolean b) {
        super.setDeviceEnabled(b);
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(MSR_SERVICE_VERSION);
        this.setAccountNumber("");
        this.setAutoDisable(false);
        this.setDataCount(0);
        this.setDataEventEnabled(false);
        this.setDecodeData(true);
        this.setErrorReportingType(0);
        this.setExpirationDate("");
        this.setFirstName("");
        this.setMiddleInitial("");
        this.setParseDecodeData(true);
        this.setServiceCode("");
        this.setSuffix("");
        this.setSurname("");
        this.setTitle("");
        this.setTrack1Data(new byte[0]);
        this.setTrack1DiscretionaryData(new byte[0]);
        this.setTrack2Data(new byte[0]);
        this.setTrack2DiscretionaryData(new byte[0]);
        this.setTrack3Data(new byte[0]);
        this.setTrack4Data(new byte[0]);
        this.setTracksToRead(7);
        this.setTransmitSentinels(false);
    }
}

