/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.services;

import com.ibm.jpos.services.DeviceServiceConst;
import com.ibm.jpos.services.DeviceServiceState;
import com.ibm.jpos.services.InputDeviceServiceState;
import java.awt.Point;
import jpos.JposException;

public class SignatureCaptureServiceState
extends DeviceServiceState
implements InputDeviceServiceState {
    private boolean autoDisable = false;
    private int dataCount = 0;
    private boolean dataEventEnabled = false;
    private int maximumX = 0;
    private int maximumY = 0;
    private byte[] rawData = null;
    private boolean realTimeDataEnabled = false;
    private Point[] pointArray = null;
    private static final int SIGNATURECAPTURE_SERVICE_VERSION = DeviceServiceConst.DEVICE_SERVICE_VERSION_NUMBER;
    private static final int MAX_MAXIMUMX = 65536;
    private static final int MAX_MAXIMUMY = 65536;

    SignatureCaptureServiceState() {
    }

    public boolean getCapDisplay() {
        return false;
    }

    public boolean getCapRealTimeData() {
        return false;
    }

    public boolean getCapUserTerminated() {
        return false;
    }

    public synchronized boolean getAutoDisable() {
        return this.autoDisable;
    }

    public synchronized int getDataCount() {
        return this.dataCount;
    }

    public synchronized boolean getDataEventEnabled() {
        return !this.getCapRealTimeData() ? false : this.dataEventEnabled;
    }

    public synchronized int getMaximumX() {
        return this.maximumX;
    }

    public synchronized int getMaximumY() {
        return this.maximumY;
    }

    public synchronized Point[] getPointArray() {
        return this.pointArray;
    }

    public synchronized byte[] getRawData() {
        return this.rawData;
    }

    public synchronized boolean getRealTimeDataEnabled() {
        return this.realTimeDataEnabled;
    }

    public synchronized void setAutoDisable(boolean b) {
        this.autoDisable = b;
    }

    public synchronized void setDataCount(int i) throws JposException {
        this.checkNegativeValue(i);
        this.dataCount = i;
    }

    public synchronized void setDataEventEnabled(boolean b) {
        this.dataEventEnabled = b;
    }

    public synchronized void setMaximumX(int i) throws JposException {
        this.checkMaximumXValue(i);
        this.maximumX = i;
    }

    public synchronized void setMaximumY(int i) throws JposException {
        this.checkMaximumYValue(i);
        this.maximumY = i;
    }

    public synchronized void setPointArray(Point[] pArray) throws JposException {
        this.checkNullValue(pArray);
        this.pointArray = pArray;
    }

    public synchronized void setRawData(byte[] bArray) throws JposException {
        this.checkNullValue(bArray);
        this.rawData = bArray;
    }

    synchronized void setRealTimeDataEnabled(boolean b) {
        this.realTimeDataEnabled = b;
    }

    public synchronized void setDeviceEnabled(boolean b) {
        super.setDeviceEnabled(b);
    }

    public void checkMaximumXValue(int i) throws JposException {
        this.checkNegativeValue(i);
        if (i > 65536) {
            throw new JposException(106);
        }
    }

    public void checkMaximumYValue(int i) throws JposException {
        this.checkNegativeValue(i);
        if (i > 65536) {
            throw new JposException(106);
        }
    }

    synchronized void initProperties() throws JposException {
        super.initProperties();
        this.setDeviceServiceVersion(SIGNATURECAPTURE_SERVICE_VERSION);
        this.setAutoDisable(false);
        this.setDataCount(0);
        this.setDataEventEnabled(false);
        this.setMaximumX(0);
        this.setMaximumY(0);
        this.setRawData(new byte[0]);
        this.setRealTimeDataEnabled(false);
        this.setPointArray(new Point[0]);
    }
}

