/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import jpos.POSPrinterConst;

public class ByteEncoder {
    private EncodingParameters encodingParameters = null;

    public ByteEncoder(int codePageOrCharacterSet) throws UnsupportedEncodingException {
        this.encodingParameters = EncodingParameters.create(codePageOrCharacterSet);
    }

    public int getCharacterSet() {
        return this.encodingParameters.getCharacterSet();
    }

    public static int getCharacterSet(int codePage) throws UnsupportedEncodingException {
        return EncodingParameters.getCharacterSet(codePage);
    }

    public int getCapCharacterSet() {
        return this.encodingParameters.getCapCharacterSet();
    }

    public static int getCapCharacterSet(int characterSet) throws UnsupportedEncodingException {
        return EncodingParameters.getCapCharacterSet(characterSet);
    }

    public int getCodePage() {
        return this.encodingParameters.getCodePage();
    }

    public static int getCodePage(int characterSet) {
        return EncodingParameters.getCodePage(characterSet);
    }

    public String getEncoding() {
        return this.encodingParameters.getEncoding();
    }

    public byte[] getDBCSLeadBytes() {
        return this.encodingParameters.getDBCSLeadBytes();
    }

    public byte[] getBytes(String s) {
        byte[] bytes = null;
        try {
            bytes = s.getBytes(this.encodingParameters.getEncoding());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return bytes;
    }

    public boolean isDBCSCodePage() {
        return this.encodingParameters.getDBCSLeadBytes().length != 0;
    }

    public static boolean isDBCSCodePage(int codePage) throws UnsupportedEncodingException {
        return EncodingParameters.isDBCSCodePage(codePage);
    }

    public boolean isDBCSLeadByte(byte b) {
        int midIndex;
        byte[] dbcsLeadBytes = this.encodingParameters.getDBCSLeadBytes();
        if (dbcsLeadBytes.length == 0) {
            return false;
        }
        int lowIndex = 0;
        int highIndex = dbcsLeadBytes.length - 1;
        if (b < dbcsLeadBytes[lowIndex] || b > dbcsLeadBytes[highIndex]) {
            return false;
        }
        while (true) {
            if ((midIndex = lowIndex + (highIndex - lowIndex) / 2) == lowIndex || midIndex == highIndex) {
                return dbcsLeadBytes[lowIndex] == b || dbcsLeadBytes[highIndex] == b;
            }
            if (b > dbcsLeadBytes[midIndex]) {
                lowIndex = midIndex + 1;
                continue;
            }
            if (b >= dbcsLeadBytes[midIndex]) break;
            highIndex = midIndex - 1;
        }
        return b == dbcsLeadBytes[midIndex];
    }

    private static class EncodingParameters
    implements Cloneable,
    POSPrinterConst {
        private static final byte[] emptyByteArray = new byte[0];
        private static final Hashtable encodingParametersTable = new Hashtable();
        private static final byte[] cp949DBCSLeadBytes = new byte[]{-113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2};
        private static final byte[] cp950DBCSLeadBytes = new byte[]{-127, -126, -125, -124, -123, -122, -121, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -83, -82, -81, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3, -2};
        private static final byte[] cp1381DBCSLeadBytes = new byte[]{-116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9};
        private static final byte[] sjisDBCSLeadBytes = new byte[]{-127, -126, -125, -124, -120, -119, -118, -117, -116, -115, -114, -113, -112, -111, -110, -109, -108, -107, -106, -105, -104, -103, -102, -101, -100, -99, -98, -97, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22};
        private static final byte[] euc_krDBCSLeadBytes = new byte[]{-95, -94, -93, -92, -91, -90, -89, -88, -87, -86, -85, -84, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -6, -5, -4, -3};
        private static final byte[] euc_cnDBCSLeadBytes = new byte[]{-95, -94, -93, -92, -91, -90, -89, -88, -87, -80, -79, -78, -77, -76, -75, -74, -73, -72, -71, -70, -69, -68, -67, -66, -65, -64, -63, -62, -61, -60, -59, -58, -57, -56, -55, -54, -53, -52, -51, -50, -49, -48, -47, -46, -45, -44, -43, -42, -41, -40, -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, -26, -25, -24, -23, -22, -21, -20, -19, -18, -17, -16, -15, -14, -13, -12, -11, -10, -9};
        private int codePage = 0;
        private int characterSet = 0;
        private int capCharacterSet = 0;
        private String encoding = "";
        private byte[] dbcsLeadBytes = emptyByteArray;

        private EncodingParameters(int codePage, int characterSet, int capCharacterSet, String encoding, byte[] dbcsLeadBytes) {
            this.codePage = codePage;
            this.characterSet = characterSet;
            this.capCharacterSet = capCharacterSet;
            this.encoding = encoding;
            this.dbcsLeadBytes = dbcsLeadBytes;
        }

        public static boolean isDBCSCodePage(int codePageOrCharacterSet) throws UnsupportedEncodingException {
            return EncodingParameters.create(codePageOrCharacterSet).getDBCSLeadBytes().length != 0;
        }

        public static EncodingParameters create(int codePageOrCharacterSet) throws UnsupportedEncodingException {
            EncodingParameters encodingParameters = null;
            if (encodingParametersTable.containsKey(new Integer(codePageOrCharacterSet))) {
                encodingParameters = (EncodingParameters)encodingParametersTable.get(new Integer(codePageOrCharacterSet));
            } else {
                Enumeration e = encodingParametersTable.elements();
                while (e.hasMoreElements()) {
                    EncodingParameters candidate = (EncodingParameters)e.nextElement();
                    if (candidate.getCodePage() != codePageOrCharacterSet) continue;
                    encodingParameters = candidate;
                    break;
                }
            }
            try {
                return (EncodingParameters)encodingParameters.clone();
            }
            catch (Exception x) {
                throw new UnsupportedEncodingException("Unsupported code page or character set: " + Integer.toString(codePageOrCharacterSet));
            }
        }

        public int getCharacterSet() {
            return this.characterSet;
        }

        public static int getCharacterSet(int codePage) throws UnsupportedEncodingException {
            Enumeration e = encodingParametersTable.elements();
            while (e.hasMoreElements()) {
                EncodingParameters encodingParameters = (EncodingParameters)e.nextElement();
                if (encodingParameters.getCodePage() != codePage) continue;
                return encodingParameters.getCharacterSet();
            }
            throw new UnsupportedEncodingException();
        }

        public int getCapCharacterSet() {
            return this.capCharacterSet;
        }

        public static int getCapCharacterSet(int characterSet) throws UnsupportedEncodingException {
            try {
                return ((EncodingParameters)encodingParametersTable.get(new Integer(characterSet))).getCapCharacterSet();
            }
            catch (Exception x) {
                throw new UnsupportedEncodingException();
            }
        }

        public static int getCodePage(int characterSet) {
            return ((EncodingParameters)encodingParametersTable.get(new Integer(characterSet))).getCodePage();
        }

        public int getCodePage() {
            return this.codePage;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public byte[] getDBCSLeadBytes() {
            return this.dbcsLeadBytes;
        }

        static {
            encodingParametersTable.put(new Integer(101), new EncodingParameters(301, 101, 10, "SJIS", sjisDBCSLeadBytes));
            encodingParametersTable.put(new Integer(102), new EncodingParameters(1088, 102, 998, "Cp949", emptyByteArray));
            encodingParametersTable.put(new Integer(103), new EncodingParameters(1381, 103, 998, "Cp1381", cp1381DBCSLeadBytes));
            encodingParametersTable.put(new Integer(104), new EncodingParameters(1361, 104, 998, "EUC_KR", euc_krDBCSLeadBytes));
            encodingParametersTable.put(new Integer(437), new EncodingParameters(437, 437, 998, "Cp437", emptyByteArray));
            encodingParametersTable.put(new Integer(850), new EncodingParameters(850, 850, 998, "Cp850", emptyByteArray));
            encodingParametersTable.put(new Integer(852), new EncodingParameters(852, 852, 998, "Cp852", emptyByteArray));
            encodingParametersTable.put(new Integer(855), new EncodingParameters(855, 855, 998, "Cp855", emptyByteArray));
            encodingParametersTable.put(new Integer(857), new EncodingParameters(857, 857, 998, "Cp857", emptyByteArray));
            encodingParametersTable.put(new Integer(858), new EncodingParameters(858, 858, 998, "Cp858", emptyByteArray));
            encodingParametersTable.put(new Integer(860), new EncodingParameters(860, 860, 998, "Cp860", emptyByteArray));
            encodingParametersTable.put(new Integer(861), new EncodingParameters(861, 861, 998, "Cp861", emptyByteArray));
            encodingParametersTable.put(new Integer(862), new EncodingParameters(862, 862, 998, "Cp862", emptyByteArray));
            encodingParametersTable.put(new Integer(863), new EncodingParameters(863, 863, 998, "Cp863", emptyByteArray));
            encodingParametersTable.put(new Integer(864), new EncodingParameters(864, 864, 998, "Cp864", emptyByteArray));
            encodingParametersTable.put(new Integer(865), new EncodingParameters(865, 865, 998, "Cp865", emptyByteArray));
            encodingParametersTable.put(new Integer(866), new EncodingParameters(866, 866, 998, "Cp866", emptyByteArray));
            encodingParametersTable.put(new Integer(808), new EncodingParameters(808, 866, 998, "Cp866", emptyByteArray));
            encodingParametersTable.put(new Integer(869), new EncodingParameters(869, 869, 998, "Cp869", emptyByteArray));
            encodingParametersTable.put(new Integer(897), new EncodingParameters(897, 897, 998, "SJIS", emptyByteArray));
            encodingParametersTable.put(new Integer(932), new EncodingParameters(932, 932, 11, "SJIS", sjisDBCSLeadBytes));
            encodingParametersTable.put(new Integer(936), new EncodingParameters(936, 936, 998, "EUC_CN", euc_cnDBCSLeadBytes));
            encodingParametersTable.put(new Integer(949), new EncodingParameters(949, 949, 998, "Cp949", cp949DBCSLeadBytes));
            encodingParametersTable.put(new Integer(950), new EncodingParameters(950, 950, 998, "Cp950", cp950DBCSLeadBytes));
            encodingParametersTable.put(new Integer(951), new EncodingParameters(951, 951, 998, "Cp949", cp949DBCSLeadBytes));
            encodingParametersTable.put(new Integer(998), new EncodingParameters(850, 998, 998, "Cp850", emptyByteArray));
            encodingParametersTable.put(new Integer(999), new EncodingParameters(850, 999, 998, "Cp850", emptyByteArray));
        }
    }
}

