/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.AbstractLogger;
import com.ibm.jpos.util.DefaultLogEntry;
import com.ibm.jpos.util.LogStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public class JDKLogStore
implements LogStore {
    private Vector entries = null;
    private int maxEntries = 100;
    private String logPathName = "." + File.separator;
    private String logFileName = "Log";
    public static final String NEW_LINE = "\n";
    public static final String DEFAULT_LOG_FILE_NAME = "Log";
    public static final String LOG_TEXT_FILE_NAME_EXT = ".log";
    public static final String LOG_SER_FILE_NAME_EXT = ".ser";

    public JDKLogStore() {
        try {
            this.entries = this.getSerializedEntries();
        }
        catch (Exception e) {
            this.entries = new Vector();
        }
    }

    public String getLogPathName() {
        return this.logPathName;
    }

    public String getLogFileName() {
        return this.logFileName;
    }

    public String getLogPathAndFileName() {
        return this.getLogPathName() + this.getLogFileName();
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setLogPathName(String s) {
        this.logPathName = s.endsWith(File.separator) ? s : s + File.separator;
    }

    public void setLogFileName(String s) {
        this.logFileName = s.lastIndexOf(".") == -1 ? s : s.substring(0, s.lastIndexOf("."));
    }

    public void setMaxEntries(int value) {
        if (value <= 0) {
            return;
        }
        if (value < this.maxEntries) {
            for (int i = 0; i < value - this.maxEntries; ++i) {
                this.entries.removeElementAt(i);
            }
        }
        this.maxEntries = value;
    }

    public void add(DefaultLogEntry entry) {
        if (this.entries.size() >= this.maxEntries) {
            this.entries.removeElementAt(0);
        }
        this.entries.addElement(entry);
    }

    public void flush() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.getLogPathAndFileName() + LOG_SER_FILE_NAME_EXT);
        ObjectOutputStream oos = new ObjectOutputStream(fos);
        oos.writeInt(DefaultLogEntry.getIDCount());
        oos.writeObject(this.entries);
        FileOutputStream outFile = new FileOutputStream(this.getLogPathAndFileName() + LOG_TEXT_FILE_NAME_EXT);
        outFile.write((AbstractLogger.getTerminalID() + NEW_LINE).getBytes());
        for (int i = 0; i < this.entries.size(); ++i) {
            outFile.write((((DefaultLogEntry)this.entries.elementAt(i)).toString() + NEW_LINE).getBytes());
        }
        fos.close();
        oos.close();
        outFile.close();
    }

    private Vector getSerializedEntries() throws Exception {
        FileInputStream fis = new FileInputStream(this.getLogPathAndFileName() + LOG_SER_FILE_NAME_EXT);
        ObjectInputStream ois = new ObjectInputStream(fis);
        int idCount = ois.readInt();
        Vector v = (Vector)ois.readObject();
        DefaultLogEntry.setIDCount(idCount);
        return v;
    }
}

