/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.JposEventContainer;
import com.ibm.jpos.util.Queue;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import jpos.events.DataEvent;
import jpos.events.DirectIOEvent;
import jpos.events.ErrorEvent;
import jpos.events.JposEvent;
import jpos.events.OutputCompleteEvent;
import jpos.events.StatusUpdateEvent;

public class JposEventQueue {
    private Queue queue = new Queue();

    public synchronized void enqueue(JposEvent jposEvent) {
        this.getQueue().enqueue(jposEvent);
    }

    public synchronized void enqueue(JposEventContainer jEC) {
        this.getQueue().enqueue(jEC);
    }

    public synchronized void enqueueInFront(JposEvent jposEvent) {
        this.getQueue().enqueueInFront(jposEvent);
    }

    public synchronized void enqueueInFront(JposEventContainer jEC) {
        this.getQueue().enqueueInFront(jEC);
    }

    public synchronized Object dequeue() {
        return this.getQueue().dequeue();
    }

    public synchronized boolean isEmpty() {
        return this.getQueue().isEmpty();
    }

    public synchronized int size() {
        return this.getQueue().size();
    }

    public synchronized boolean isEnqueuedDataEvent() {
        Enumeration elements = this.getQueue().elements();
        while (elements.hasMoreElements()) {
            Object obj = elements.nextElement();
            JposEvent jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if (!(jE instanceof DataEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean isEnqueuedDirectIoOutputCompleteStatusUpdateEvent() {
        Enumeration elements = this.getQueue().elements();
        while (elements.hasMoreElements()) {
            JposEvent jE;
            Object obj = elements.nextElement();
            JposEvent jposEvent = jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if (!(jE instanceof DirectIOEvent) && !(jE instanceof OutputCompleteEvent) && !(jE instanceof StatusUpdateEvent)) continue;
            return true;
        }
        return false;
    }

    public synchronized Object getFirstDirectIoOutputCompleteStatusUpdateEvent() {
        Enumeration elements = this.getQueue().elements();
        int queueIndex = 0;
        while (elements.hasMoreElements()) {
            JposEvent jE;
            Object obj = elements.nextElement();
            JposEvent jposEvent = jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if ((jE instanceof DirectIOEvent || jE instanceof OutputCompleteEvent || jE instanceof StatusUpdateEvent) && queueIndex <= this.getQueue().getVector().size()) {
                return this.getQueue().getVector().remove(queueIndex);
            }
            ++queueIndex;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeAllErrorEvent() {
        Queue nonErrorEvents = new Queue();
        Enumeration elements = this.getQueue().elements();
        while (elements.hasMoreElements()) {
            JposEvent jE;
            Object obj = elements.nextElement();
            JposEvent jposEvent = jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if (!(jE instanceof ErrorEvent)) {
                nonErrorEvents.enqueue(obj);
                continue;
            }
            if (obj instanceof JposEventContainer) {
                JposEventContainer jec;
                JposEventContainer jposEventContainer = jec = (JposEventContainer)obj;
                synchronized (jposEventContainer) {
                    ErrorEvent ee = (ErrorEvent)jE;
                    ee.setErrorResponse(12);
                    jec.doneFiring();
                    continue;
                }
            }
            JposEvent jposEvent2 = jE;
            synchronized (jposEvent2) {
                jE.notifyAll();
            }
        }
        this.setQueue(nonErrorEvents);
    }

    public synchronized void removeAllDataEvent() {
        Queue nonDataEvents = new Queue();
        Enumeration elements = this.getQueue().elements();
        while (elements.hasMoreElements()) {
            Object obj = elements.nextElement();
            JposEvent jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if (jE instanceof DataEvent) continue;
            nonDataEvents.enqueue(obj);
        }
        this.setQueue(nonDataEvents);
    }

    public synchronized void removeAllOutputCompleteEvent() {
        Queue nonOutputCompleteEvents = new Queue();
        Enumeration elements = this.getQueue().elements();
        while (elements.hasMoreElements()) {
            Object obj = elements.nextElement();
            JposEvent jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
            if (jE instanceof OutputCompleteEvent) continue;
            nonOutputCompleteEvents.enqueue(obj);
        }
        this.setQueue(nonOutputCompleteEvents);
    }

    public synchronized void removeAllEvents() {
        this.getQueue().removeAll();
    }

    public synchronized void removeAllEventsExceptStatusUpdateEvents() {
        this.removeAllDataEvent();
        this.removeAllErrorEvent();
        this.removeAllOutputCompleteEvent();
    }

    public synchronized boolean isFirstElementDataEvent() {
        JposEvent jE;
        Object obj = null;
        try {
            obj = this.getQueue().getFirstElement();
        }
        catch (NoSuchElementException e) {
            return false;
        }
        JposEvent jposEvent = jE = obj instanceof JposEventContainer ? ((JposEventContainer)obj).getJposEvent() : (JposEvent)obj;
        return jE instanceof DataEvent;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        sb.append("Queue size = " + this.getQueue().size() + "\n");
        Enumeration elements = this.getQueue().elements();
        int i = 0;
        while (elements.hasMoreElements()) {
            sb.append("#" + i++ + " " + elements.nextElement().toString() + "\n");
        }
        sb.append("~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n");
        return sb.toString();
    }

    protected Queue getQueue() {
        return this.queue;
    }

    protected synchronized void setQueue(Queue q) {
        this.queue = q;
    }
}

