/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.Version;
import com.ibm.jpos.util.Tracer;
import com.ibm.jpos.util.TracerListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LoadWithTrace {
    public static void main(String[] argv) {
        LoadWithTraceUI ui = new LoadWithTraceUI();
    }

    static class LoadWithTraceUI
    extends JFrame
    implements TracerListener {
        String CONFIG_FILENAME = "LoadWithTrace.config";
        JTextField programNameJTF = new JTextField("", 40);
        JButton programNameJB = new JButton("Run Program");
        JTextField programArgsJTF = new JTextField("", 40);
        JLabel programArgsJL = new JLabel("Program Arguments", 0);
        JTextField levelJTF = new JTextField("0", 40);
        JButton levelJB = new JButton("Set Level");
        JTextField classnameJTF = new JTextField("", 40);
        JButton classnameJB = new JButton("Add Class");
        JTextField filenameJTF = new JTextField("", 40);
        JButton filenameJB = new JButton("Set Filename");
        JTextField bufferSizeJTF = new JTextField("0", 40);
        JButton bufferSizeJB = new JButton("Set Trace Buffer Size");
        JButton quitJB = new JButton("Quit");
        JButton saveBufferJB = new JButton("Save Trace Buffer");
        JTextArea resultsJTA = new JTextArea(10, 60);
        Runner runner = null;
        Properties defaults = new Properties();

        public LoadWithTraceUI() {
            Thread.currentThread().setName("LoadWithTrace UI");
            Tracer.addTracerListener(this);
            this.getDefaults();
            this.getContentPane().setLayout(new BorderLayout());
            JPanel promptPanel = new JPanel();
            JPanel fieldPanel = new JPanel();
            promptPanel.setLayout(new GridLayout(6, 1));
            fieldPanel.setLayout(new GridLayout(6, 1));
            promptPanel.add(this.programNameJB);
            fieldPanel.add(this.programNameJTF);
            promptPanel.add(this.programArgsJL);
            fieldPanel.add(this.programArgsJTF);
            promptPanel.add(this.levelJB);
            fieldPanel.add(this.levelJTF);
            promptPanel.add(this.classnameJB);
            fieldPanel.add(this.classnameJTF);
            promptPanel.add(this.filenameJB);
            fieldPanel.add(this.filenameJTF);
            promptPanel.add(this.bufferSizeJB);
            fieldPanel.add(this.bufferSizeJTF);
            JPanel inputPanel = new JPanel();
            inputPanel.setLayout(new BorderLayout());
            inputPanel.add((Component)promptPanel, "West");
            inputPanel.add((Component)fieldPanel, "Center");
            inputPanel.setBorder(new TitledBorder("Options"));
            this.getContentPane().add("North", inputPanel);
            JPanel resultsPanel = new JPanel();
            resultsPanel.setLayout(new GridLayout(1, 1));
            JScrollPane resultsScrollPane = new JScrollPane(22, 30);
            resultsScrollPane.setViewportView(this.resultsJTA);
            resultsPanel.add(resultsScrollPane);
            resultsPanel.setBorder(new TitledBorder("Messages"));
            Font oFont = this.resultsJTA.getFont();
            Font font = new Font("Monospaced", 0, oFont.getSize());
            this.resultsJTA.setFont(font);
            this.getContentPane().add("Center", resultsPanel);
            JPanel buttonPanel = new JPanel();
            buttonPanel.add(this.saveBufferJB);
            buttonPanel.add(this.quitJB);
            this.getContentPane().add("South", buttonPanel);
            Listener listener = new Listener();
            this.quitJB.addActionListener(listener);
            this.saveBufferJB.addActionListener(listener);
            this.programNameJB.addActionListener(listener);
            this.levelJB.addActionListener(listener);
            this.classnameJB.addActionListener(listener);
            this.filenameJB.addActionListener(listener);
            this.bufferSizeJB.addActionListener(listener);
            this.pack();
            String copyrightMessage = "IBM LoadWithTrace Utility V" + Version.getVersionString() + ", Copyright (c) IBM Corporation, 1999";
            this.setTitle(copyrightMessage);
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ LoadWithTraceUI this$0;
                {
                    this.this$0 = this$0;
                }

                public void windowClosing(WindowEvent e) {
                    this.this$0.saveDefaults();
                    System.exit(0);
                }
            });
        }

        void getDefaults() {
            String homePath = System.getProperty("user.home");
            String defaultsFilename = homePath + this.CONFIG_FILENAME;
            try {
                FileInputStream defaultsStream = new FileInputStream(defaultsFilename);
                this.defaults.load(defaultsStream);
                defaultsStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.programNameJTF.setText(this.defaults.getProperty("ProgramName"));
            this.programArgsJTF.setText(this.defaults.getProperty("ProgramArgs"));
            this.levelJTF.setText(this.defaults.getProperty("TraceLevel"));
            this.classnameJTF.setText(this.defaults.getProperty("ClassNames"));
            this.filenameJTF.setText(this.defaults.getProperty("Filename"));
        }

        void saveDefaults() {
            String homePath = System.getProperty("user.home");
            String defaultsFilename = homePath + this.CONFIG_FILENAME;
            this.defaults.put("ProgramName", this.programNameJTF.getText());
            this.defaults.put("ProgramArgs", this.programArgsJTF.getText());
            this.defaults.put("TraceLevel", this.levelJTF.getText());
            this.defaults.put("ClassNames", this.classnameJTF.getText());
            this.defaults.put("Filename", this.filenameJTF.getText());
            try {
                FileOutputStream defaultsStream = new FileOutputStream(defaultsFilename);
                this.defaults.store(defaultsStream, "LoadWithTrace Defaults");
                defaultsStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void addMessage(String message) {
            this.resultsJTA.append(message);
            this.resultsJTA.setCaretPosition(this.resultsJTA.getText().length());
        }

        public void traceInfo(String formattedMessage, String thread, String classname, int level, String methodName, String message) {
            this.addMessage(formattedMessage + "\n");
        }

        class Runner
        implements Runnable {
            Thread me = null;
            Method method = null;
            String programName = null;
            String programArgs = null;

            public Runner(String programName, String programArgs) {
                this.programName = programName;
                this.programArgs = programArgs;
            }

            public void run() {
                try {
                    boolean found = false;
                    Object runObject = Class.forName(this.programName).newInstance();
                    Class<?> runClass = runObject.getClass();
                    Class[] methodParms = new Class[1];
                    Method[] methods = runClass.getMethods();
                    for (int i = 0; i < methods.length; ++i) {
                        if (!methods[i].getName().equals("main")) continue;
                        found = true;
                        StringTokenizer token = new StringTokenizer(this.programArgs, " ");
                        String[] strings = new String[token.countTokens()];
                        int j = 0;
                        while (token.hasMoreTokens()) {
                            strings[j++] = token.nextToken();
                        }
                        Object[] parms = new Object[]{strings};
                        methods[i].invoke(runObject, parms);
                    }
                    if (!found) {
                        LoadWithTraceUI.this.addMessage(this.programName + " does not have a main() method.\n");
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    LoadWithTraceUI.this.addMessage("Could not find class " + this.programName + "\n");
                }
                catch (Exception e) {
                    LoadWithTraceUI.this.addMessage(e.toString() + "\n");
                }
            }

            public void start() {
                if (this.me == null) {
                    this.me = new Thread(this);
                    this.me.start();
                    this.me.setName("LoadWithTrace Runner");
                }
            }
        }

        class Listener
        implements ActionListener {
            Listener() {
            }

            public void actionPerformed(ActionEvent ae) {
                LoadWithTraceUI.this.saveDefaults();
                String command = ae.getActionCommand();
                if (command.equals("Quit")) {
                    System.exit(0);
                } else if (command.equals("Run Program")) {
                    String programName = LoadWithTraceUI.this.programNameJTF.getText();
                    if (programName.length() > 0) {
                        LoadWithTraceUI.this.runner = new Runner(LoadWithTraceUI.this.programNameJTF.getText(), LoadWithTraceUI.this.programArgsJTF.getText());
                        LoadWithTraceUI.this.runner.start();
                    }
                } else if (command.equals("Set Level")) {
                    String sLevel = LoadWithTraceUI.this.levelJTF.getText();
                    int iLevel = 0;
                    if (sLevel.length() > 0) {
                        try {
                            iLevel = new Integer(sLevel);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        Tracer.setTracerLevel(iLevel);
                    }
                } else if (command.equals("Add Class")) {
                    String classname = LoadWithTraceUI.this.classnameJTF.getText();
                    Tracer.addTracerClassname(classname);
                } else if (command.equals("Set Filename")) {
                    String filename = LoadWithTraceUI.this.filenameJTF.getText();
                    Tracer.setTracerFilename(filename);
                } else if (command.equals("Set Trace Buffer Size")) {
                    String sSize = LoadWithTraceUI.this.bufferSizeJTF.getText();
                    int iSize = 0;
                    if (sSize.length() > 0) {
                        try {
                            iSize = new Integer(sSize);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        Tracer.setTracerBuffer(iSize);
                    }
                } else if (command.equals("Save Trace Buffer")) {
                    JFileChooser chooser = new JFileChooser();
                    chooser.setDialogTitle("Select Bitmap Filename");
                    int returnVal = chooser.showSaveDialog(new JTextField());
                    if (returnVal == 0) {
                        String filename = chooser.getSelectedFile().getPath();
                        try {
                            FileWriter file = new FileWriter(filename, false);
                            String[] buffer = Tracer.dumpTracerBuffer();
                            for (int i = 0; i < buffer.length; ++i) {
                                if (buffer[i] == null) continue;
                                file.write(buffer[i] + "\n");
                            }
                            file.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

