/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jpos.util;

import com.ibm.jpos.util.TracerListener;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class Tracer {
    private static int maxThreadNameLength = 8;
    private static int maxClassNameLength = 25;
    private static int traceLevel = 0;
    private static String traceFilename = new String("");
    private static Hashtable classNames = new Hashtable();
    private static String format = new String(":TIMESTAMPMILLI: (:THREADNAME:) <:CLASSNAME:> : :PADDING: :METHODNAME: - :COMMENT:");
    private static Date lastDate = new Date(System.currentTimeMillis());
    private static Vector listeners = new Vector();
    private static String[] traceBuffer = new String[1];
    private static int traceBufferLoc = 0;

    private Tracer() {
    }

    public static void addTracerListener(TracerListener tl) {
        listeners.addElement(tl);
    }

    public static void setTracerLevel(int level) {
        traceLevel = level;
    }

    public static void setTracerBuffer(int amount) {
        if (amount == 0) {
            amount = 1;
        }
        traceBuffer = new String[amount];
        traceBufferLoc = 0;
    }

    public static String[] dumpTracerBuffer() {
        String[] buffer = new String[traceBuffer.length];
        int current = traceBufferLoc;
        int end = traceBufferLoc - 1;
        if (end < 0) {
            end = traceBuffer.length - 1;
        }
        int j = 0;
        while (current != end) {
            buffer[j++] = new String(traceBuffer[current++]);
            if (current < traceBuffer.length) continue;
            current = 0;
        }
        buffer[j++] = new String(traceBuffer[current++]);
        return buffer;
    }

    public static int getTracerLevel() {
        return traceLevel;
    }

    public static int getTraceLevel() {
        return Tracer.getTracerLevel();
    }

    public static void setTracerFilename(String filename) {
        if (filename == null) {
            Tracer.clearTracerFilename();
        } else if (filename.length() == 0) {
            Tracer.clearTracerFilename();
        } else {
            traceFilename = new String(filename);
        }
    }

    public static String getTracerFilename() {
        return traceFilename;
    }

    public static void clearTracerFilename() {
        traceFilename = new String("");
    }

    public static void addTracerClassname(String classname) {
        if (classname == null) {
            Tracer.clearTracerClassnames();
        } else if (classname.length() == 0) {
            Tracer.clearTracerClassnames();
        } else {
            StringTokenizer tokens = new StringTokenizer(classname, " ,");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                classNames.put(token, token);
            }
        }
    }

    public static void removeTracerClassname(String classname) {
        classNames.remove(classname);
    }

    public static void clearTracerClassnames() {
        classNames.clear();
    }

    public static void setTracerFormat(String f) {
        format = new String(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void trace(int level, String className, String methodName, String message) {
        if (level > traceLevel) {
            return;
        }
        if (classNames.size() > 0 && !classNames.contains(className)) {
            return;
        }
        Date myDate = new Date(System.currentTimeMillis());
        SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        String tmTimeStamp = new String("");
        String tsTimeStamp = new String("");
        String tdTimeStamp = new String("");
        formatter = new SimpleDateFormat("HH:mm:ss");
        tsTimeStamp = formatter.format(myDate);
        formatter = new SimpleDateFormat("HH:mm:ss.SSS");
        tmTimeStamp = formatter.format(myDate);
        long delta = myDate.getTime() - lastDate.getTime();
        tdTimeStamp = Long.toString(delta);
        while (tdTimeStamp.length() < 3) {
            tdTimeStamp = "0" + tdTimeStamp;
        }
        lastDate = myDate;
        StringBuffer buffer = new StringBuffer();
        int indention = 0;
        StringBuffer threadName = new StringBuffer(Thread.currentThread().getName().trim());
        Tracer.fixLength(threadName, maxThreadNameLength);
        maxThreadNameLength = threadName.length();
        indention = 1;
        String tempThreadName = new String(threadName);
        if (tempThreadName.startsWith("AWT") && indention > 21) {
            indention -= 20;
        }
        buffer = new StringBuffer("");
        for (int i = 2; i < indention; ++i) {
            buffer.append(" ");
        }
        StringBuffer cName = new StringBuffer(className.trim());
        Tracer.fixLength(cName, maxClassNameLength);
        maxClassNameLength = cName.length();
        String mName = new String(Tracer.fixUnprintables(methodName));
        String outputb = new String(format);
        outputb = Tracer.replaceKey(outputb, ":TIMESTAMP:", tsTimeStamp);
        outputb = Tracer.replaceKey(outputb, ":TIMESTAMPMILLI:", tmTimeStamp);
        outputb = Tracer.replaceKey(outputb, ":TIMESTAMPDELTA:", tdTimeStamp);
        outputb = Tracer.replaceKey(outputb, ":THREADNAME:", threadName.toString());
        outputb = Tracer.replaceKey(outputb, ":CLASSNAME:", cName.toString());
        outputb = Tracer.replaceKey(outputb, ":LEVEL:", Integer.toString(level));
        outputb = Tracer.replaceKey(outputb, ":METHODNAME:", mName);
        outputb = Tracer.replaceKey(outputb, ":COMMENT:", message);
        outputb = Tracer.replaceKey(outputb, ":PADDING:", buffer.toString());
        if (traceBuffer.length > 1) {
            Tracer.traceBuffer[Tracer.traceBufferLoc] = new String(outputb);
            if (++traceBufferLoc >= traceBuffer.length) {
                traceBufferLoc = 0;
            }
        }
        if (listeners.isEmpty()) {
            if (traceFilename.length() > 0) {
                try {
                    FileWriter file = new FileWriter(traceFilename, true);
                    file.write(outputb + "\n");
                    file.close();
                }
                catch (Exception e) {}
            } else {
                System.out.println(outputb);
            }
        }
        Vector vector = listeners;
        synchronized (vector) {
            Enumeration e = listeners.elements();
            while (e.hasMoreElements()) {
                TracerListener listener = (TracerListener)e.nextElement();
                listener.traceInfo(outputb, threadName.toString(), cName.toString(), level, methodName, message);
            }
        }
    }

    private static String replaceKey(String out, String key, String data) {
        int index = out.indexOf(key);
        String newOut = new String(out);
        if (index != -1) {
            newOut = out.substring(0, index);
            newOut = newOut + data;
            newOut = newOut + out.substring(index + key.length());
        }
        return newOut;
    }

    private static String fixUnprintables(String message) {
        for (int i = 0; i < message.length(); ++i) {
            if ((byte)message.charAt(i) >= 32) continue;
            int hexChar = message.charAt(i);
            String hexString = Integer.toHexString(hexChar &= 0xFF);
            if (hexString.length() < 2) {
                hexString = "0" + hexString;
            }
            hexString = "<" + hexString + ">";
            String first = message.substring(0, i);
            String last = message.substring(i + 1);
            message = first + hexString + last;
        }
        return message;
    }

    private static void fixLength(StringBuffer str, int len) {
        if (str.length() > len) {
            return;
        }
        while (str.length() < len) {
            str.append(" ");
        }
    }
}

