/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple;

import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jpos.config.JposEntry;
import jpos.config.JposEntryRegistry;
import jpos.config.JposEntryRegistryEvent;
import jpos.config.JposEntryRegistryListener;
import jpos.config.JposRegPopulator;
import jpos.util.tracing.Tracer;
import jpos.util.tracing.TracerFactory;

public class SimpleEntryRegistry
implements JposEntryRegistry {
    public Hashtable jposEntries = new Hashtable();
    private Vector listeners = new Vector();
    private JposRegPopulator regPopulator = null;
    private boolean loaded = false;
    private Tracer tracer = TracerFactory.getInstance().createTracer("SimpleEntryRegistry");

    public SimpleEntryRegistry() {
    }

    public SimpleEntryRegistry(JposRegPopulator jposRegPopulator) {
        this.regPopulator = jposRegPopulator;
    }

    public boolean hasJposEntry(String string) {
        return this.jposEntries.containsKey(string);
    }

    public Enumeration getEntries() {
        Vector vector = new Vector();
        Enumeration enumeration = this.jposEntries.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    public JposEntry getJposEntry(String string) {
        return (JposEntry)this.jposEntries.get(string);
    }

    public void modifyJposEntry(String string, JposEntry jposEntry) {
        this.jposEntries.put(string, jposEntry);
        this.tracer.println("Modified entry.logicalName = " + string);
        this.fireJposEntryRegistryEventModified(new JposEntryRegistryEvent(this, jposEntry));
    }

    public void addJposEntry(String string, JposEntry jposEntry) {
        this.jposEntries.put(string, jposEntry);
        this.tracer.println("Added entry.logicalName = " + string);
        this.fireJposEntryRegistryEventAdded(new JposEntryRegistryEvent(this, jposEntry));
    }

    public void addJposEntry(JposEntry jposEntry) {
        this.addJposEntry(jposEntry.getLogicalName(), jposEntry);
    }

    public void removeJposEntry(JposEntry jposEntry) {
        Enumeration enumeration = this.jposEntries.elements();
        while (enumeration.hasMoreElements()) {
            JposEntry jposEntry2 = (JposEntry)enumeration.nextElement();
            if (!jposEntry2.hasPropertyWithName("logicalName")) continue;
            JposEntry jposEntry3 = (JposEntry)this.jposEntries.remove(jposEntry.getPropertyValue("logicalName"));
            this.tracer.println("Removed entry.logicalName = " + jposEntry.getLogicalName());
            this.fireJposEntryRegistryEventRemoved(new JposEntryRegistryEvent(this, jposEntry3));
            return;
        }
        this.tracer.println("Could not find entry to remove entry.logicalName = " + jposEntry.getLogicalName());
    }

    public void removeJposEntry(String string) {
        JposEntry jposEntry = (JposEntry)this.jposEntries.get(string);
        if (jposEntry != null) {
            this.jposEntries.remove(string);
            this.fireJposEntryRegistryEventRemoved(new JposEntryRegistryEvent(this, jposEntry));
        }
    }

    public void addJposEntryRegistryListener(JposEntryRegistryListener jposEntryRegistryListener) {
        this.listeners.addElement(jposEntryRegistryListener);
    }

    public void removeJposEntryRegistryListener(JposEntryRegistryListener jposEntryRegistryListener) {
        this.listeners.removeElement(jposEntryRegistryListener);
    }

    public void save() throws Exception {
        this.getRegPopulator().save(this.getEntries());
    }

    public void saveToFile(File file) throws Exception {
        this.getRegPopulator().save(this.getEntries(), file.getCanonicalPath());
    }

    public JposRegPopulator getRegPopulator() {
        return this.regPopulator;
    }

    public void load() {
        this.jposEntries.clear();
        this.getRegPopulator().load();
        Enumeration enumeration = this.getRegPopulator().getEntries();
        while (enumeration.hasMoreElements()) {
            try {
                JposEntry jposEntry = (JposEntry)enumeration.nextElement();
                this.jposEntries.put(jposEntry.getPropertyValue("logicalName"), jposEntry);
            }
            catch (Exception exception) {
                this.tracer.print(exception);
            }
        }
        this.loaded = true;
    }

    public int getSize() {
        return this.jposEntries.size();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<SimpleEntryRegistry>\n");
        stringBuffer.append("<size=\"" + this.getSize() + "\"\n/>");
        stringBuffer.append("<populatorUniqueId=\"" + this.getRegPopulator().getUniqueId() + "\"\n/>");
        stringBuffer.append("numberOfListeners=\"" + this.listeners.size() + "\"\n/>");
        stringBuffer.append("<entries>\n");
        Enumeration enumeration = this.getEntries();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringBuffer.append("<entry" + n + ".LogicalName=\"" + ((JposEntry)enumeration.nextElement()).getLogicalName() + "\"\n/>");
            ++n;
        }
        stringBuffer.append("</entries>\n");
        stringBuffer.append("</SimpleEntryRegistry>\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventAdded(JposEntryRegistryEvent jposEntryRegistryEvent) {
        Vector vector;
        this.tracer.println("fireJposEntryRegistryEventAdded: e.getJposEntry().logicalName = " + jposEntryRegistryEvent.getJposEntry().getLogicalName());
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryRegistryListener)vector.elementAt(i)).jposEntryAdded(jposEntryRegistryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventRemoved(JposEntryRegistryEvent jposEntryRegistryEvent) {
        Vector vector;
        this.tracer.println("fireJposEntryRegistryEventRemoved: e.getJposEntry().logicalName = " + jposEntryRegistryEvent.getJposEntry().getLogicalName());
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryRegistryListener)vector.elementAt(i)).jposEntryRemoved(jposEntryRegistryEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireJposEntryRegistryEventModified(JposEntryRegistryEvent jposEntryRegistryEvent) {
        Vector vector;
        this.tracer.println("fireJposEntryRegistryEventModified: e.getJposEntry().logicalName = " + jposEntryRegistryEvent.getJposEntry().getLogicalName());
        Vector vector2 = vector = (Vector)this.listeners.clone();
        synchronized (vector2) {
            for (int i = 0; i < vector.size(); ++i) {
                ((JposEntryRegistryListener)vector.elementAt(i)).jposEntryModified(jposEntryRegistryEvent);
            }
        }
    }
}

