/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import jpos.config.JposEntry;
import jpos.config.JposEntryConst;
import jpos.config.simple.editor.AbstractPropsViewPanel;
import jpos.config.simple.editor.DefaultBusPropsViewPanel;
import jpos.config.simple.editor.PropsViewPanel;
import jpos.config.simple.editor.RS232PropsViewPanel;

class BusPropsViewPanel
extends AbstractPropsViewPanel {
    private DefaultBusPropsViewPanel rs232PropsViewPanel = new RS232PropsViewPanel();
    private DefaultBusPropsViewPanel rs485PropsViewPanel = new DefaultBusPropsViewPanel();
    private DefaultBusPropsViewPanel usbPropsViewPanel = new DefaultBusPropsViewPanel();
    private DefaultBusPropsViewPanel proprietaryPropsViewPanel = new DefaultBusPropsViewPanel();
    private DefaultBusPropsViewPanel unknownPropsViewPanel = new DefaultBusPropsViewPanel();
    private AbstractPropsViewPanel visiblePropsViewPanel = null;
    private CardLayout busPropsPanelCardLayout = new CardLayout();
    private JPanel busPropsPanel = new JPanel(this.busPropsPanelCardLayout, true);
    private JComboBox deviceBusComboBox = new JComboBox<String>(JposEntryConst.DEVICE_BUS_VALUES);
    private boolean inEditMode = false;
    public static final String DEVICE_BUS_PROPERTIES_STRING = "Device Bus (Connectivity) Properties";
    public static final String DEVICE_BUS_STRING = "Device Bus";
    public static final String SAVE_CHANGES_TO_DEVICE_BUS_PROP_MSG = "Save changes and loose previous setting?";

    public BusPropsViewPanel() {
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), DEVICE_BUS_PROPERTIES_STRING));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new JLabel(DEVICE_BUS_STRING));
        jPanel.add(this.deviceBusComboBox);
        this.add((Component)jPanel, "North");
        this.initBusPropsPanels();
        JScrollPane jScrollPane = new JScrollPane(this.busPropsPanel);
        this.add((Component)jScrollPane, "Center");
        this.init();
        this.deviceBusComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BusPropsViewPanel.this.deviceBusComboBoxStateChanged();
            }
        });
    }

    private void init() {
        this.deviceBusComboBox.setSelectedItem("Unknown");
        this.deviceBusComboBox.setEnabled(false);
    }

    private void initBusPropsPanels() {
        this.busPropsPanel.add((Component)this.rs232PropsViewPanel, "RS232");
        this.busPropsPanel.add((Component)this.rs485PropsViewPanel, "RS485");
        this.busPropsPanel.add((Component)this.usbPropsViewPanel, "USB");
        this.busPropsPanel.add((Component)this.proprietaryPropsViewPanel, "Proprietary");
        this.busPropsPanel.add((Component)this.unknownPropsViewPanel, "Unknown");
        this.busPropsPanelCardLayout.show(this.busPropsPanel, "Unknown");
        this.visiblePropsViewPanel = this.unknownPropsViewPanel;
    }

    private void deviceBusComboBoxStateChanged() {
        this.showCorrectBusPanel(this.deviceBusComboBox.getSelectedItem().toString());
        if (this.inEditMode) {
            this.setEnabledAll(true);
            this.setEditableAll(true);
            this.getVisiblePropsViewPanel().setJposEntry(this.jposEntry);
        }
    }

    private void showCorrectBusPanel(String string) {
        if (string.equals("RS232")) {
            this.busPropsPanelCardLayout.show(this.busPropsPanel, "RS232");
            this.visiblePropsViewPanel = this.rs232PropsViewPanel;
        } else if (string.equals("RS485")) {
            this.busPropsPanelCardLayout.show(this.busPropsPanel, "RS485");
            this.visiblePropsViewPanel = this.rs485PropsViewPanel;
        } else if (string.equals("USB")) {
            this.busPropsPanelCardLayout.show(this.busPropsPanel, "USB");
            this.visiblePropsViewPanel = this.usbPropsViewPanel;
        } else if (string.equals("Proprietary")) {
            this.busPropsPanelCardLayout.show(this.busPropsPanel, "Proprietary");
            this.visiblePropsViewPanel = this.proprietaryPropsViewPanel;
        } else {
            this.busPropsPanelCardLayout.show(this.busPropsPanel, "Unknown");
            this.visiblePropsViewPanel = this.unknownPropsViewPanel;
        }
    }

    private PropsViewPanel getVisiblePropsViewPanel() {
        return this.visiblePropsViewPanel;
    }

    public void clearAll() {
        this.deviceBusComboBox.setSelectedItem("Unknown");
        this.getVisiblePropsViewPanel().clearAll();
    }

    public void setEnabledAll(boolean bl) {
        this.deviceBusComboBox.setEnabled(bl);
        this.getVisiblePropsViewPanel().setEnabledAll(bl);
    }

    public void setEditableAll(boolean bl) {
        this.getVisiblePropsViewPanel().setEditableAll(bl);
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        if (!this.jposEntry.hasPropertyWithName("deviceBus")) {
            this.jposEntry.addProperty("deviceBus", "Unknown");
        }
        this.inEditMode = false;
        this.deviceBusComboBox.setSelectedItem((String)this.jposEntry.getPropertyValue("deviceBus"));
        this.getVisiblePropsViewPanel().setJposEntry(jposEntry);
        this.setEnabledAll(false);
        this.setEditableAll(false);
    }

    public void aboutToLooseFocus() {
        if (this.jposEntry != null) {
            this.cancelButtonClicked();
        }
    }

    public void editButtonClicked() {
        this.getVisiblePropsViewPanel().editButtonClicked();
        this.setEnabledAll(true);
        this.setEditableAll(true);
        this.inEditMode = true;
    }

    public void okButtonClicked() {
        String string = this.deviceBusComboBox.getSelectedItem().toString();
        String string2 = this.jposEntry.getPropertyValue("deviceBus").toString();
        if (!string2.equals(string)) {
            int n = JOptionPane.showConfirmDialog(this, SAVE_CHANGES_TO_DEVICE_BUS_PROP_MSG);
            if (n == 0 || n == 2) {
                this.jposEntry.modifyPropertyValue("deviceBus", this.deviceBusComboBox.getSelectedItem().toString());
                this.getVisiblePropsViewPanel().okButtonClicked();
                this.fireJposEntryChanged(new PropsViewPanel.Event(this));
            }
        } else {
            this.getVisiblePropsViewPanel().okButtonClicked();
            this.showCorrectBusPanel(this.jposEntry.getPropertyValue("deviceBus").toString());
        }
        this.setEnabledAll(false);
        this.setEditableAll(false);
        this.inEditMode = false;
    }

    public void cancelButtonClicked() {
        if (this.jposEntry == null) {
            return;
        }
        this.getVisiblePropsViewPanel().cancelButtonClicked();
        if (this.jposEntry.hasPropertyWithName("deviceBus")) {
            this.showCorrectBusPanel((String)this.jposEntry.getPropertyValue("deviceBus"));
        } else {
            this.showCorrectBusPanel("Unknown");
        }
        this.setEnabledAll(false);
        this.setEditableAll(false);
        this.inEditMode = false;
    }
}

