/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jpos.config.JposEntry;
import jpos.config.simple.editor.EditJposEntryPropDialog;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.JposEntryList;
import jpos.config.simple.editor.JposEntryProp;
import jpos.config.simple.editor.JposEntryViewPanel;

class EditJposEntryDialog
extends JDialog {
    private JposEntry jposEntry = null;
    private JposEntryList jposEntryList = null;
    private boolean showNumbersAsHex = false;
    private JposEntryViewPanel jposEntryViewPanel = new JposEntryViewPanel();
    private EditJposEntryPropDialog editJposEntryPropDialog = new EditJposEntryPropDialog((JFrame)this.getParent());
    private JButton addPropButton = new JButton(ADD_STRING);
    private JButton modifyPropButton = new JButton(MODIFY_STRING);
    private JButton deletePropButton = new JButton(DELETE_STRING);
    private JButton okButton = new JButton(OKBUTTON_STRING);
    private JButton cancelButton = new JButton(CANCELBUTTON_STRING);
    private boolean editing = false;
    private boolean canceled = false;
    public static final String JPOSENTRYEDITOR_STRING = JposEntryEditorMsg.JPOSENTRYEDITOR_STRING;
    public static final String EDITTITLE_STRING = JposEntryEditorMsg.EDITTITLE_STRING;
    public static final String ADDPROP_STRING = JposEntryEditorMsg.ADDPROP_STRING;
    public static final String MODIFYPROP_STRING = JposEntryEditorMsg.MODIFYPROP_STRING;
    public static final String DELETEPROP_STRING = JposEntryEditorMsg.DELETEPROP_STRING;
    public static final String DELETEJPOSENTRY_STRING = JposEntryEditorMsg.DELETEJPOSENTRY_STRING;
    public static final String VALIDNAME_STRING = JposEntryEditorMsg.VALIDNAME_STRING;
    public static final String VALIDCLASS_STRING = JposEntryEditorMsg.VALIDCLASS_STRING;
    public static final String UNKNOWN_STRING = JposEntryEditorMsg.UNKNOWN_STRING;
    public static final String USEDNAME_STRING = JposEntryEditorMsg.USEDNAME_STRING;
    public static final String CANCELBUTTON_STRING = JposEntryEditorMsg.CANCELBUTTON_STRING;
    public static final String OKBUTTON_STRING = JposEntryEditorMsg.OKBUTTON_STRING;
    public static final String ADD_STRING = JposEntryEditorMsg.ADD_STRING;
    public static final String DELETE_STRING = JposEntryEditorMsg.DELETE_STRING;
    public static final String MODIFY_STRING = JposEntryEditorMsg.MODIFY_STRING;

    public EditJposEntryDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(EDITTITLE_STRING);
        this.getContentPane().setLayout(new BorderLayout());
        this.jposEntryViewPanel.setEnabledAll(true);
        this.jposEntryViewPanel.setEditableAll(true);
        this.getContentPane().add((Component)this.jposEntryViewPanel, "Center");
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(this.addPropButton);
        jPanel.add(this.modifyPropButton);
        jPanel.add(this.deletePropButton);
        jPanel.add(this.okButton);
        jPanel.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.addPropButton.setToolTipText(ADDPROP_STRING);
        this.modifyPropButton.setToolTipText(MODIFYPROP_STRING);
        this.deletePropButton.setToolTipText(DELETEPROP_STRING);
        this.addPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryDialog.this.addProp();
            }
        });
        this.modifyPropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryDialog.this.modifyProp();
            }
        });
        this.deletePropButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryDialog.this.deleteProp();
            }
        });
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryDialog.this.cancel();
            }
        });
        this.jposEntryViewPanel.addPropertiesListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditJposEntryDialog.this.enableEditModifyButtons(true);
            }
        });
        this.initDialog();
        this.pack();
        this.centerFrame();
    }

    public void initDialog() {
        this.jposEntryViewPanel.setFocusOnLogicalName();
    }

    private void centerFrame() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private void addProp() {
        JposEntryProp jposEntryProp;
        this.editJposEntryPropDialog.setJposEntryProp(new JposEntryProp());
        this.editJposEntryPropDialog.setJposEntry(this.jposEntry);
        this.editJposEntryPropDialog.setEditing(false);
        this.editJposEntryPropDialog.clearAll();
        this.editJposEntryPropDialog.setCanceled(false);
        this.editJposEntryPropDialog.setModal(true);
        this.editJposEntryPropDialog.setVisible(true);
        JposEntryProp jposEntryProp2 = jposEntryProp = this.editJposEntryPropDialog.isCanceled() ? null : this.editJposEntryPropDialog.getJposEntryProp();
        if (jposEntryProp != null) {
            this.getJposEntry().addProperty(jposEntryProp.getName(), jposEntryProp.getValue());
            this.jposEntryViewPanel.addProperty(jposEntryProp);
            this.jposEntryViewPanel.refresh();
        }
    }

    private void modifyProp() {
        JposEntryProp jposEntryProp = this.jposEntryViewPanel.getSelectedJposEntryProp();
        String string = jposEntryProp.getName();
        this.editJposEntryPropDialog.setJposEntryProp(jposEntryProp);
        this.editJposEntryPropDialog.setJposEntry(this.jposEntry);
        this.editJposEntryPropDialog.setEditing(true);
        this.editJposEntryPropDialog.setCanceled(false);
        this.editJposEntryPropDialog.setModal(true);
        this.editJposEntryPropDialog.setVisible(true);
        if (!this.editJposEntryPropDialog.isCanceled()) {
            this.jposEntry.removeProperty(string);
            this.jposEntry.addProperty(jposEntryProp.getName(), jposEntryProp.getValue());
            this.jposEntryViewPanel.refresh();
            this.jposEntryViewPanel.updateCurrentProp();
            this.enableEditModifyButtons(!this.jposEntryViewPanel.isListEmpty());
        }
    }

    private void deleteProp() {
        JposEntryProp jposEntryProp = this.jposEntryViewPanel.getSelectedJposEntryProp();
        if (jposEntryProp != null) {
            String string = jposEntryProp.getName();
            int n = JOptionPane.showConfirmDialog(this, DELETEJPOSENTRY_STRING + string, JPOSENTRYEDITOR_STRING, 0);
            if (n == 0) {
                this.jposEntry.removeProperty(jposEntryProp.getName());
                this.jposEntryViewPanel.removeProperty(jposEntryProp);
                this.jposEntryViewPanel.refresh();
                this.enableEditModifyButtons(false);
                this.jposEntryViewPanel.clearCurrentPropFields();
            }
        }
    }

    private void ok() {
        if (this.jposEntryViewPanel.getLogicalName().equals("")) {
            JOptionPane.showMessageDialog(this, VALIDNAME_STRING, JPOSENTRYEDITOR_STRING, 0);
            this.jposEntryViewPanel.setFocusOnLogicalName();
            return;
        }
        if (this.jposEntryViewPanel.getSIFactoryClassName().equals("")) {
            JOptionPane.showMessageDialog(this, VALIDCLASS_STRING, JPOSENTRYEDITOR_STRING, 0);
            this.jposEntryViewPanel.setFocusOnSIFactoryClassName();
            return;
        }
        if (this.isEditing()) {
            this.jposEntry.addProperty("logicalName", this.jposEntryViewPanel.getLogicalName());
            this.jposEntry.addProperty("serviceInstanceFactoryClass", this.jposEntryViewPanel.getSIFactoryClassName());
            Enumeration enumeration = this.jposEntryViewPanel.getJposEntryProps();
            while (enumeration.hasMoreElements()) {
                JposEntryProp jposEntryProp = (JposEntryProp)enumeration.nextElement();
                this.jposEntry.addProperty(jposEntryProp.getName(), jposEntryProp.getValue());
            }
            if (!this.jposEntry.hasPropertyWithName("deviceCategory")) {
                this.jposEntry.addProperty("deviceCategory", UNKNOWN_STRING);
            }
            if (!this.jposEntry.hasPropertyWithName("vendorName")) {
                this.jposEntry.addProperty("vendorName", UNKNOWN_STRING);
            }
            this.setVisible(false);
        } else if (!this.jposEntryList.hasJposEntry(this.jposEntryViewPanel.getLogicalName())) {
            this.jposEntry.addProperty("logicalName", this.jposEntryViewPanel.getLogicalName());
            this.jposEntry.addProperty("serviceInstanceFactoryClass", this.jposEntryViewPanel.getSIFactoryClassName());
            Enumeration enumeration = this.jposEntryViewPanel.getJposEntryProps();
            while (enumeration.hasMoreElements()) {
                JposEntryProp jposEntryProp = (JposEntryProp)enumeration.nextElement();
                this.jposEntry.addProperty(jposEntryProp.getName(), jposEntryProp.getValue());
            }
            if (!this.jposEntry.hasPropertyWithName("deviceCategory")) {
                this.jposEntry.addProperty("deviceCategory", UNKNOWN_STRING);
            }
            if (!this.jposEntry.hasPropertyWithName("vendorName")) {
                this.jposEntry.addProperty("vendorName", UNKNOWN_STRING);
            }
            this.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this, USEDNAME_STRING, JPOSENTRYEDITOR_STRING, 0);
            this.jposEntryViewPanel.setFocusOnLogicalName();
        }
    }

    private void cancel() {
        this.setCanceled(true);
        this.setVisible(false);
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        this.jposEntryViewPanel.setJposEntry(this.jposEntry);
        this.enableEditModifyButtons(!this.jposEntryViewPanel.isListEmpty());
    }

    public void clearAll() {
        this.jposEntryViewPanel.clearAll();
    }

    public void setEnabledAll(boolean bl) {
        this.jposEntryViewPanel.setEnabled(bl);
    }

    public void setEditableAll(boolean bl) {
        this.jposEntryViewPanel.setEditableAll(bl);
    }

    public void enableEditModifyButtons(boolean bl) {
        this.modifyPropButton.setEnabled(bl);
        this.deletePropButton.setEnabled(bl);
    }

    public void setJposEntryList(JposEntryList jposEntryList) {
        this.jposEntryList = jposEntryList;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void enableViewPanelLNTField(boolean bl) {
        this.jposEntryViewPanel.enableLogicalNameTextField(bl);
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean getShowNumbersAsHexFlag() {
        return this.showNumbersAsHex;
    }

    public void setShowNumbersAsHexFlag(boolean bl) {
        this.showNumbersAsHex = bl;
        this.editJposEntryPropDialog.setShowNumbersAsHexFlag(bl);
    }

    public void clearCurrentPropFields() {
        this.jposEntryViewPanel.clearCurrentPropFields();
    }
}

