/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.config.JposEntry;
import jpos.config.simple.editor.JposEntryEditorMsg;
import jpos.config.simple.editor.JposEntryEditorUtility;
import jpos.config.simple.editor.JposEntryProp;

class EditJposEntryPropDialog
extends JDialog {
    private boolean showNumbersAsHex = false;
    private JposEntry jposEntry = null;
    private JposEntryProp jposEntryProp = null;
    private JTextField currentPropNameTextField = new JTextField(15);
    private JTextField currentPropValueTextField = new JTextField(15);
    private JComboBox currentPropValueTypeComboBox = new JComboBox<String>(PROPERTY_VALUE_TYPES);
    private JButton okButton = new JButton(OKBUTTON_STRING);
    private JButton cancelButton = new JButton(CANCELBUTTON_STRING);
    private boolean canceled = false;
    private boolean invalidProperty = false;
    private boolean editing = false;
    private String currentName = "";
    private static String[] PROPERTY_VALUE_TYPES = new String[]{"String", "Integer", "Boolean", "Long", "Float", "Byte", "Character"};
    public static final String JPOSENTRYEDITOR_STRING = JposEntryEditorMsg.JPOSENTRYEDITOR_STRING;
    public static final String EDITPROPTITLE_STRING = JposEntryEditorMsg.EDITPROPTITLE_STRING;
    public static final String EDITPROPERTYNAME_STRING = JposEntryEditorMsg.EDITPROPERTYNAME_STRING;
    public static final String EDITPROPERTYVALUE_STRING = JposEntryEditorMsg.EDITPROPERTYVALUE_STRING;
    public static final String EDITPROPERTYTYPE_STRING = JposEntryEditorMsg.EDITPROPERTYTYPE_STRING;
    public static final String EDITINVALIDPROPERTY_STRING = JposEntryEditorMsg.EDITINVALIDPROPERTY_STRING;
    public static final String PROPERTYDEFINED_STRING = JposEntryEditorMsg.PROPERTYDEFINED_STRING;
    public static final String EDITVALIDNAME_STRING = JposEntryEditorMsg.EDITVALIDNAME_STRING;
    public static final String NOTCOMPATIBLE_STRING = JposEntryEditorMsg.NOTCOMPATIBLE_STRING;
    public static final String CANCELBUTTON_STRING = JposEntryEditorMsg.CANCELBUTTON_STRING;
    public static final String OKBUTTON_STRING = JposEntryEditorMsg.OKBUTTON_STRING;
    public static final String CURRENTPROPNAMETEXT_STRING = JposEntryEditorMsg.CURRENTPROPNAMETEXT_STRING;

    public EditJposEntryPropDialog(JFrame jFrame) {
        super(jFrame);
        this.setTitle(EDITPROPTITLE_STRING);
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), CURRENTPROPNAMETEXT_STRING, 1, 2));
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYNAME_STRING));
        jPanel2.add(this.currentPropNameTextField);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYVALUE_STRING));
        jPanel2.add(this.currentPropValueTextField);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(new JLabel(EDITPROPERTYVALUE_STRING));
        jPanel2.add(this.currentPropValueTypeComboBox);
        jPanel.add(jPanel2);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel3 = new JPanel(new FlowLayout(1));
        jPanel3.add(this.okButton);
        jPanel3.add(this.cancelButton);
        this.getContentPane().add((Component)jPanel3, "South");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryPropDialog.this.ok();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditJposEntryPropDialog.this.cancel();
            }
        });
        this.pack();
        this.centerDialog();
    }

    private void centerDialog() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dimension.width / 2 - this.getSize().width / 2, dimension.height / 2 - this.getSize().height / 2);
    }

    private void ok() {
        block9: {
            if (this.currentName.equals("")) {
                this.currentName = this.jposEntryProp.getName();
            }
            String string = this.currentPropNameTextField.getText().trim();
            String string2 = this.currentPropValueTextField.getText().trim();
            String string3 = (String)this.currentPropValueTypeComboBox.getSelectedItem();
            if (string3.equalsIgnoreCase("integer")) {
                string2 = JposEntryEditorUtility.readHex(string2, this.showNumbersAsHex);
            }
            boolean bl = false;
            try {
                Object object = this.determineJposEntryPropValue(string2, string3);
                this.jposEntryProp.setName(string);
                this.jposEntryProp.setValue(object);
                if (this.isEditing()) {
                    if (!this.currentName.equals(string) && this.getJposEntry().hasPropertyWithName(this.jposEntryProp.getName())) {
                        bl = true;
                        throw new Exception(EDITINVALIDPROPERTY_STRING);
                    }
                } else if (this.getJposEntry().hasPropertyWithName(this.jposEntryProp.getName())) {
                    bl = true;
                    throw new Exception(EDITINVALIDPROPERTY_STRING);
                }
                this.currentName = "";
                this.setCanceled(false);
                this.setVisible(false);
            }
            catch (Exception exception) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, PROPERTYDEFINED_STRING, JPOSENTRYEDITOR_STRING, 0);
                    this.currentPropNameTextField.requestFocus();
                    this.currentPropNameTextField.selectAll();
                }
                if (this.invalidProperty) break block9;
                JOptionPane.showMessageDialog(this, EDITVALIDNAME_STRING, JPOSENTRYEDITOR_STRING, 0);
                this.currentPropNameTextField.requestFocus();
            }
        }
    }

    private void cancel() {
        this.jposEntryProp = null;
        this.setCanceled(true);
        this.setVisible(false);
    }

    private Object determineJposEntryPropValue(String string, String string2) throws Exception {
        Object object = null;
        this.invalidProperty = false;
        try {
            if (string2.equals("String")) {
                object = string;
            } else if (string2.equals("Integer")) {
                object = new Integer(string);
            } else if (string2.equals("Long")) {
                object = new Long(string);
            } else if (string2.equals("Character")) {
                object = new Character(string.charAt(0));
            } else if (string2.equals("Byte")) {
                object = new Byte(string);
            } else if (string2.equals("Boolean")) {
                object = new Boolean(string);
            } else if (string2.equals("Float")) {
                object = new Float(string);
            }
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this, NOTCOMPATIBLE_STRING, JPOSENTRYEDITOR_STRING, 0);
            this.invalidProperty = true;
            throw exception;
        }
        return object;
    }

    public void clearAll() {
        this.currentPropNameTextField.setText("");
        this.currentPropValueTextField.setText("");
        this.currentPropValueTypeComboBox.setSelectedItem("");
        this.currentPropNameTextField.requestFocus();
    }

    public JposEntryProp getJposEntryProp() {
        return this.jposEntryProp;
    }

    public void setJposEntryProp(JposEntryProp jposEntryProp) {
        if (jposEntryProp == null) {
            return;
        }
        this.jposEntryProp = jposEntryProp;
        this.currentPropNameTextField.setText(this.jposEntryProp.getName());
        if (this.jposEntryProp.getValueType().equalsIgnoreCase("integer")) {
            this.currentPropValueTextField.setText(JposEntryEditorUtility.formatText(this.jposEntryProp.getValue().toString(), this.showNumbersAsHex));
        } else {
            this.currentPropValueTextField.setText(this.jposEntryProp.getValue().toString());
        }
        this.currentPropValueTypeComboBox.setSelectedItem(this.jposEntryProp.getValueType());
    }

    public void setCanceled(boolean bl) {
        this.canceled = bl;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public JposEntry getJposEntry() {
        return this.jposEntry;
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
    }

    public void setEditing(boolean bl) {
        this.editing = bl;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public boolean getShowNumbersAsHexFlag() {
        return this.showNumbersAsHex;
    }

    public void setShowNumbersAsHexFlag(boolean bl) {
        this.showNumbersAsHex = bl;
    }
}

