/*
 * Decompiled with CFR 0.152.
 */
package jpos.config.simple.editor;

import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.config.JposEntry;
import jpos.config.RS232Const;
import jpos.config.simple.editor.DefaultBusPropsViewPanel;
import jpos.config.simple.editor.PropsViewPanel;
import jpos.util.JposEntryUtility;

class RS232PropsViewPanel
extends DefaultBusPropsViewPanel {
    private JTextField portNameTextField = new JTextField(10);
    private JComboBox baudRateComboBox = new JComboBox<String>(RS232Const.RS232_BAUD_RATE_VALUES);
    private JComboBox dataBitsComboBox = new JComboBox<String>(RS232Const.RS232_DATA_BITS_VALUES);
    private JComboBox parityComboBox = new JComboBox<String>(RS232Const.RS232_PARITY_VALUES);
    private JComboBox stopBitsComboBox = new JComboBox<String>(RS232Const.RS232_STOP_BITS_VALUES);
    private JComboBox flowControlComboBox = new JComboBox<String>(RS232Const.RS232_FLOW_CONTROL_VALUES);
    public static final String RS232_PROPERTIES_STRING = "RS232 Properties";

    public RS232PropsViewPanel() {
        this.setBorder(BorderFactory.createLineBorder(Color.gray));
        this.setLayout(new FlowLayout(1));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(6, 1));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.gray), RS232_PROPERTIES_STRING));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("portName"));
        jPanel2.add(this.portNameTextField);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("baudRate"));
        jPanel2.add(this.baudRateComboBox);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("dataBits"));
        jPanel2.add(this.dataBitsComboBox);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("parity"));
        jPanel2.add(this.parityComboBox);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("stopBits"));
        jPanel2.add(this.stopBitsComboBox);
        jPanel.add(jPanel2);
        jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("flowControl"));
        jPanel2.add(this.flowControlComboBox);
        jPanel.add(jPanel2);
        this.add(jPanel);
        this.init();
    }

    private void init() {
        this.clearAll();
        this.setEditableAll(false);
        this.setEnabledAll(false);
    }

    private void updateViewFromJposEntry(JposEntry jposEntry) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        if (jposEntry.hasPropertyWithName("portName")) {
            string = (String)jposEntry.getPropertyValue("portName");
        }
        if (jposEntry.hasPropertyWithName("baudRate")) {
            string2 = (String)jposEntry.getPropertyValue("baudRate");
        }
        if (jposEntry.hasPropertyWithName("dataBits")) {
            string3 = (String)jposEntry.getPropertyValue("dataBits");
        }
        if (jposEntry.hasPropertyWithName("parity")) {
            string4 = (String)jposEntry.getPropertyValue("parity");
        }
        if (jposEntry.hasPropertyWithName("stopBits")) {
            string5 = (String)jposEntry.getPropertyValue("stopBits");
        }
        if (jposEntry.hasPropertyWithName("flowControl")) {
            string6 = (String)jposEntry.getPropertyValue("flowControl");
        }
        this.portNameTextField.setText(string);
        this.baudRateComboBox.setSelectedItem(string2);
        this.dataBitsComboBox.setSelectedItem(string3);
        this.parityComboBox.setSelectedItem(string4);
        this.stopBitsComboBox.setSelectedItem(string5);
        this.flowControlComboBox.setSelectedItem(string6);
    }

    private void updateJposEntryFromView(JposEntry jposEntry) {
        String string = this.portNameTextField.getText();
        String string2 = this.baudRateComboBox.getSelectedItem().toString();
        String string3 = this.dataBitsComboBox.getSelectedItem().toString();
        String string4 = this.parityComboBox.getSelectedItem().toString();
        String string5 = this.stopBitsComboBox.getSelectedItem().toString();
        String string6 = this.flowControlComboBox.getSelectedItem().toString();
        if (jposEntry.hasPropertyWithName("portName")) {
            jposEntry.modifyPropertyValue("portName", string);
        } else {
            jposEntry.addProperty("portName", string);
        }
        if (jposEntry.hasPropertyWithName("baudRate")) {
            jposEntry.modifyPropertyValue("baudRate", string2);
        } else {
            jposEntry.addProperty("baudRate", string2);
        }
        if (jposEntry.hasPropertyWithName("dataBits")) {
            jposEntry.modifyPropertyValue("dataBits", string3);
        } else {
            jposEntry.addProperty("dataBits", string3);
        }
        if (jposEntry.hasPropertyWithName("parity")) {
            jposEntry.modifyPropertyValue("parity", string4);
        } else {
            jposEntry.addProperty("parity", string4);
        }
        if (jposEntry.hasPropertyWithName("stopBits")) {
            jposEntry.modifyPropertyValue("stopBits", string5);
        } else {
            jposEntry.addProperty("stopBits", string5);
        }
        if (jposEntry.hasPropertyWithName("flowControl")) {
            jposEntry.modifyPropertyValue("flowControl", string6);
        } else {
            jposEntry.addProperty("flowControl", string6);
        }
        this.fireJposEntryChanged(new PropsViewPanel.Event(this));
    }

    public void clearAll() {
        this.portNameTextField.setText("");
        this.baudRateComboBox.setSelectedItem("9600");
        this.dataBitsComboBox.setSelectedItem("8");
        this.parityComboBox.setSelectedItem("None");
        this.stopBitsComboBox.setSelectedItem("1");
        this.flowControlComboBox.setSelectedItem("Xon/Xoff");
    }

    public void setEnabledAll(boolean bl) {
        this.portNameTextField.setEnabled(bl);
        this.baudRateComboBox.setEnabled(bl);
        this.dataBitsComboBox.setEnabled(bl);
        this.parityComboBox.setEnabled(bl);
        this.stopBitsComboBox.setEnabled(bl);
        this.flowControlComboBox.setEnabled(bl);
    }

    public void setEditableAll(boolean bl) {
        this.portNameTextField.setEditable(bl);
    }

    public void setJposEntry(JposEntry jposEntry) {
        this.jposEntry = jposEntry;
        this.updateViewFromJposEntry(this.jposEntry);
    }

    public void aboutToLooseFocus() {
        this.cancelButtonClicked();
    }

    public void editButtonClicked() {
        this.setEditableAll(true);
        this.setEnabledAll(true);
    }

    public void okButtonClicked() {
        this.updateJposEntryFromView(this.jposEntry);
        this.setEditableAll(false);
        this.setEnabledAll(false);
    }

    public void cancelButtonClicked() {
        this.setEditableAll(false);
        this.setEnabledAll(false);
    }

    public void removeBusProps(JposEntry jposEntry) {
        JposEntryUtility.removeAllRS232Props(jposEntry);
    }
}

